/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.jmrix.can.cbus.swing.CbusEventHighlightFrame;
import jmri.jmrix.can.cbus.swing.CbusFilterFrame;
import jmri.jmrix.can.cbus.swing.configtool.ConfigToolPane;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.util.JmriJFrame;

public class CbusConsoleDisplayOptionsPane
extends JPanel {
    private final CbusConsolePane _mainPane;
    private JCheckBox showLogCheckBox;
    private JCheckBox showStatsCheckBox;
    private JCheckBox showPacketCheckBox;
    private JCheckBox showSendEventCheckBox;
    public JButton filterButton;
    public JButton highlightButton;
    protected JButton evCaptureButton;
    protected CbusFilterFrame filterFrame;
    protected CbusEventHighlightFrame highlightFrame;
    private ConfigToolPane _evCapFrame;
    private JmriJFrame _ecf;

    public CbusConsoleDisplayOptionsPane(CbusConsolePane mainPane) {
        this._mainPane = mainPane;
        this.makePane();
    }

    private void makePane() {
        this.setDefaults();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("Display")));
        this.add(this.showLogCheckBox);
        this.add(this.showStatsCheckBox);
        this.add(this.showPacketCheckBox);
        this.add(this.showSendEventCheckBox);
        this.add(this.filterButton);
        this.add(this.highlightButton);
        this.add(this.evCaptureButton);
    }

    private void setDefaults() {
        this.showLogCheckBox = new JCheckBox();
        this.showStatsCheckBox = new JCheckBox();
        this.showPacketCheckBox = new JCheckBox();
        this.showSendEventCheckBox = new JCheckBox();
        this.filterButton = new JButton();
        this.highlightButton = new JButton();
        this.evCaptureButton = new JButton();
        this.showStatsCheckBox.setSelected(false);
        this.showLogCheckBox.setSelected(false);
        this.showPacketCheckBox.setSelected(false);
        this.showSendEventCheckBox.setSelected(false);
        this.setText();
    }

    private void setText() {
        this.showLogCheckBox.setText(Bundle.getMessage("Logging"));
        this.showLogCheckBox.setToolTipText(Bundle.getMessage("LoggingTip"));
        this.showStatsCheckBox.setText(Bundle.getMessage("StatisticsTitle"));
        this.showStatsCheckBox.setToolTipText(Bundle.getMessage("ButtonShowStats"));
        this.showPacketCheckBox.setText(Bundle.getMessage("ButtonShowPackets"));
        this.showPacketCheckBox.setToolTipText(Bundle.getMessage("TooltipShowPackets"));
        this.showSendEventCheckBox.setText(Bundle.getMessage("ButtonSendEvent"));
        this.showSendEventCheckBox.setToolTipText(Bundle.getMessage("TooltipShowEvents"));
        this.filterButton.setText(Bundle.getMessage("ButtonFilter"));
        this.filterButton.setToolTipText(Bundle.getMessage("TooltipFilter"));
        this.highlightButton.setText(Bundle.getMessage("ButtonHighlight"));
        this.highlightButton.setToolTipText(Bundle.getMessage("TooltipHighlighter"));
        this.evCaptureButton.setText(Bundle.getMessage("CapConfigTitle"));
        this.addListeners();
    }

    private void addListeners() {
        this.showLogCheckBox.addActionListener(e -> this._mainPane.logPane.setVisible(this.showLogCheckBox.isSelected()));
        this.showStatsCheckBox.addActionListener(e -> this._mainPane.statsPane.setVisible(this.showStatsCheckBox.isSelected()));
        this.showSendEventCheckBox.addActionListener(e -> this._mainPane.sendPane.setVisible(this.showSendEventCheckBox.isSelected()));
        this.filterButton.addActionListener(this::filterButtonActionPerformed);
        this.highlightButton.addActionListener(this::highlightButtonActionPerformed);
        this.evCaptureButton.addActionListener(this::evCaptureButtonActionPerformed);
        this.showPacketCheckBox.addActionListener(e -> this._mainPane.packetPane.setVisible(this.showPacketCheckBox.isSelected()));
    }

    public void filterButtonActionPerformed(ActionEvent e) {
        if (this.filterFrame == null) {
            this.filterFrame = new CbusFilterFrame(this._mainPane, this._evCapFrame);
            this.filterFrame.initComponents();
            if (this._evCapFrame != null) {
                this._evCapFrame.setFilter(this.filterFrame);
            }
        } else {
            this.filterFrame.setState(0);
        }
        this.filterFrame.setVisible(true);
    }

    public void highlightButtonActionPerformed(ActionEvent e) {
        if (this.highlightFrame == null) {
            this.highlightFrame = new CbusEventHighlightFrame(this._mainPane, this._evCapFrame);
            this.highlightFrame.initComponents();
            if (this._evCapFrame != null) {
                this._evCapFrame.setHighlighter(this.highlightFrame);
            }
        } else {
            this.highlightFrame.setState(0);
        }
        this.highlightFrame.setVisible(true);
    }

    public void evCaptureButtonActionPerformed(ActionEvent e) {
        if (this._evCapFrame == null) {
            this._ecf = new JmriJFrame("Event Capture paired to " + this._mainPane.getTitle() + " Filter and Highlighter");
            this._evCapFrame = new ConfigToolPane(this._mainPane, this.filterFrame, this.highlightFrame);
            this._ecf.add(this._evCapFrame);
            this._evCapFrame.initComponents(this._mainPane.getMemo());
            this._ecf.pack();
            this._ecf.setState(0);
        } else {
            this._ecf.setState(0);
        }
        this._ecf.setVisible(true);
    }

    public void dispose() {
        if (this.highlightFrame != null) {
            this.highlightFrame.dispose();
            this.highlightFrame = null;
        }
        if (this.filterFrame != null) {
            this.filterFrame.dispose();
            this.filterFrame = null;
        }
        if (this._ecf != null) {
            this._ecf.dispose();
            this._ecf = null;
        }
    }
}

