/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.cbusslotmonitor;

import jmri.DccLocoAddress;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.Bundle;

public class CbusSlotMonitorSession {
    private final DccLocoAddress _locoAddr;
    private int _sessionId;
    private int _speed;
    private String _speedSteps;
    private final boolean[] _function;
    private int _flags;
    private int _consistId;

    protected CbusSlotMonitorSession(DccLocoAddress locoAddr) {
        this._locoAddr = locoAddr;
        this._sessionId = -1;
        this._speed = 0;
        this._speedSteps = "";
        this._function = new boolean[29];
        this._flags = -1;
        this._consistId = 0;
    }

    protected DccLocoAddress getLocoAddr() {
        return this._locoAddr;
    }

    protected void setSessionId(int session) {
        this._sessionId = session;
    }

    protected int getSessionId() {
        return this._sessionId;
    }

    protected void setDccSpeed(int speed) {
        this._speed = speed;
    }

    protected int getCommandedSpeed() {
        String speedflags = String.format("%8s", Integer.toBinaryString(this._speed & 0xFF)).replace(' ', '0');
        int directionSpeed = Integer.parseInt(speedflags.substring(1), 2);
        if (directionSpeed == 1) {
            return 0;
        }
        return directionSpeed;
    }

    protected String getDirection() {
        if (this._speed == 1) {
            return String.valueOf(Bundle.getMessage("EStop")) + Bundle.getMessage("REV");
        }
        if (this._speed == 129) {
            return String.valueOf(Bundle.getMessage("EStop")) + Bundle.getMessage("FWD");
        }
        if (this.getSpeedSteps().equals("14")) {
            if (this._speed > 13) {
                return Bundle.getMessage("FWD");
            }
            return Bundle.getMessage("REV");
        }
        if (this.getSpeedSteps().equals("28") || this.getSpeedSteps().equals("28I")) {
            if (this._speed > 27) {
                return Bundle.getMessage("FWD");
            }
            return Bundle.getMessage("REV");
        }
        if (this._speed > 127) {
            return Bundle.getMessage("FWD");
        }
        return Bundle.getMessage("REV");
    }

    protected void setSpeedSteps(String steps) {
        this._speedSteps = steps;
    }

    protected String getSpeedSteps() {
        if (this._speedSteps.isEmpty()) {
            return "128";
        }
        return this._speedSteps;
    }

    protected void setFunction(int fn, boolean tof) {
        this._function[fn] = tof;
    }

    protected String getFunctionString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < 29) {
            if (this._function[i]) {
                buf.append(i);
                buf.append(" ");
            }
            ++i;
        }
        return buf.toString();
    }

    protected void setFlags(int flags) {
        boolean sm1;
        this._flags = flags;
        boolean sm0 = (flags >> 0 & 1) != 0;
        boolean bl = sm1 = (flags >> 1 & 1) != 0;
        if (!sm0 && !sm1) {
            this._speedSteps = "128";
        } else if (!sm0 && sm1) {
            this._speedSteps = "14";
        } else if (sm0 && !sm1) {
            this._speedSteps = "28I";
        } else if (sm0 && sm1) {
            this._speedSteps = "28";
        }
    }

    protected String getFlagString() {
        if (this._flags < 0) {
            return "";
        }
        StringBuilder flagstring = new StringBuilder();
        boolean esa = (this._flags >> 4 & 1) != 0;
        boolean esb = (this._flags >> 5 & 1) != 0;
        flagstring.append(Bundle.getMessage("EngineState"));
        if (!esa && !esb) {
            flagstring.append(Bundle.getMessage("Active"));
        } else if (!esa && esb) {
            flagstring.append(Bundle.getMessage("Consisted"));
        } else if (esa && !esb) {
            flagstring.append(Bundle.getMessage("Consistmaster"));
        } else if (esa && esb) {
            flagstring.append(Bundle.getMessage("Inactive"));
        }
        flagstring.append(" ");
        flagstring.append(Bundle.getMessage("Lights"));
        flagstring.append(this._flags >> 2 & 1);
        flagstring.append(" ");
        flagstring.append(Bundle.getMessage("RelDirection"));
        flagstring.append(this._flags >> 3 & 1);
        flagstring.append(" ");
        return flagstring.toString();
    }

    protected void setConsistId(int consistid) {
        this._consistId = consistid;
    }

    protected int getConsistId() {
        return this._consistId;
    }
}

