/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.cbusslotmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.throttle.LargePowerManagerButton;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.Bundle;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorDataModel;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.swing.sdi.JmriJFrameInterface;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.JTableWithColumnToolTips;

public class CbusSlotMonitorPane
extends CanPanel {
    private JScrollPane scrolltablefeedback;
    private JSplitPane split;
    private final double _splitratio = 0.95;
    private JScrollPane slotScroll;
    protected CbusSlotMonitorDataModel slotModel;
    private JTable _slotTable;
    private final XTableColumnModel tcm = new XTableColumnModel();
    private final JMenu colMenu = new JMenu(Bundle.getMessage("SessCol"));

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.slotModel = new CbusSlotMonitorDataModel(memo);
        this._slotTable = new JTableWithColumnToolTips((TableModel)this.slotModel, CbusSlotMonitorDataModel.CBUSSLOTMONTOOLTIPS);
        this.init();
    }

    public void init() {
        this._slotTable.setColumnModel(this.tcm);
        this.setupColumnsMenuLinks();
        TableRowSorter<CbusSlotMonitorDataModel> sorter = new TableRowSorter<CbusSlotMonitorDataModel>(this.slotModel);
        this._slotTable.setRowSorter(sorter);
        TableColumn estopColumn = this.tcm.getColumnByModelIndex(2);
        estopColumn.setMinWidth(60);
        estopColumn.setCellRenderer(new ButtonRenderer());
        estopColumn.setCellEditor(new ButtonEditor(new JButton()));
        this.slotScroll = new JScrollPane(this._slotTable);
        this.slotScroll.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BoxLayout(this, 1));
        this.scrolltablefeedback = new JScrollPane(this.slotModel.tablefeedback());
        this.scrolltablefeedback.setMinimumSize(new Dimension(150, 20));
        JPanel toppanelcontainer = new JPanel();
        toppanelcontainer.setLayout(new BoxLayout(toppanelcontainer, 0));
        toppanelcontainer.add(this.getStopButton());
        toppanelcontainer.add(new LargePowerManagerButton(true));
        this.split = new JSplitPane(0, this.slotScroll, this.scrolltablefeedback);
        this.split.setResizeWeight(0.95);
        this.split.setContinuousLayout(true);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)toppanelcontainer, "First");
        p1.add((Component)this.split, "Center");
        this.add(p1);
        p1.setMinimumSize(new Dimension(450, 200));
        p1.setVisible(true);
    }

    private JButton getStopButton() {
        JButton estopButton = new JButton("Stop All");
        estopButton.setIcon(new NamedIcon("resources/icons/throttles/estop.png", "resources/icons/throttles/estop.png"));
        estopButton.setToolTipText(Bundle.getMessage("ThrottleToolBarStopAllToolTip"));
        estopButton.addActionListener(e -> this.slotModel.sendcbusestop());
        return estopButton;
    }

    private void setupColumnsMenuLinks() {
        CbusCommonSwing.configureTable(this._slotTable);
        StayOpenCheckBoxItem[] cbArray = new StayOpenCheckBoxItem[this.slotModel.getColumnCount()];
        int i = 0;
        while (i < this.slotModel.getColumnCount()) {
            StayOpenCheckBoxItem cbi;
            cbArray[i] = cbi = new StayOpenCheckBoxItem(this.slotModel.getColumnName(i));
            TableColumn column = this.tcm.getColumnByModelIndex(i);
            cbi.addActionListener(e -> this.tcm.setColumnVisible(column, cbi.isSelected()));
            int ii = i;
            this.tcm.setColumnVisible(this.tcm.getColumnByModelIndex(i), Arrays.stream(CbusSlotMonitorDataModel.CBUSSLOTMONINITIALCOLS).anyMatch(j -> j == ii));
            ++i;
        }
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> tpm.persist(this._slotTable, true));
        i = 0;
        while (i < this.slotModel.getColumnCount()) {
            cbArray[i].setSelected(this.tcm.isColumnVisible(this.tcm.getColumnByModelIndex(i)));
            this.colMenu.add(cbArray[i]);
            ++i;
        }
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemCbusSlotMonitor"));
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        menuList.add(this.colMenu);
        return menuList;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorPane";
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this._slotTable));
        this._slotTable = null;
        this.slotModel.dispose();
        super.dispose();
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemCbusSlotMonitor"), new JmriJFrameInterface(), CbusSlotMonitorPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

