/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import jmri.jmrix.can.cbus.swing.bootloader.Bundle;
import jmri.jmrix.can.cbus.swing.bootloader.HexRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexFile {
    private String name;
    private final File file;
    private FileInputStream in;
    private BufferedInputStream buffIn;
    protected static final int MAX_PROG_SIZE = 262144;
    protected static final int MAX_CONFIG_SIZE = 1024;
    protected static final int MAX_EEPROM_SIZE = 1024;
    protected static final int ID_START = 0x200000;
    protected static final int CONFIG_START = 0x300000;
    private int address = 0;
    private boolean read;
    private int lineNo = 0;
    private int progEnd = 0;
    private int configEnd = 0;
    private int eeStart;
    private int eeEnd = 0;
    private byte[] hexDataProg;
    private byte[] hexDataConfig;
    private byte[] hexDataEeprom;
    private static final Logger log = LoggerFactory.getLogger(HexFile.class);

    public HexFile(String fileName, int eepromStart) {
        this.name = fileName;
        this.file = new File(fileName);
        this.eeStart = eepromStart;
        this.hexDataProg = new byte[262144];
        this.hexDataConfig = new byte[1024];
        this.hexDataEeprom = new byte[1024];
        this.setDataToErasedState();
    }

    private void setDataToErasedState() {
        Arrays.fill(this.hexDataProg, (byte)-1);
        Arrays.fill(this.hexDataConfig, (byte)-1);
        Arrays.fill(this.hexDataEeprom, (byte)-1);
    }

    public String getName() {
        return this.name;
    }

    public void openRd() throws FileNotFoundException {
        this.read = true;
        this.in = new FileInputStream(this.file);
        this.buffIn = new BufferedInputStream(this.in);
        this.address = 0;
    }

    public void close() {
        try {
            if (this.read) {
                this.buffIn.close();
                this.in.close();
            }
            this.name = null;
        }
        catch (IOException e) {
            log.warn("Exception closing hex file {}", (Throwable)e);
            this.name = null;
        }
    }

    public void read() throws IOException {
        try {
            HexRecord r;
            do {
                int i;
                r = new HexRecord(this);
                if (r.type == 4) {
                    this.address = (r.data[0] & 0xFF) * 256 * 65536 + (r.data[1] & 0xFF) * 65536;
                    log.debug("Found extended adress record. Address is now {}", (Object)Integer.toHexString(this.address));
                    ++this.lineNo;
                    r = new HexRecord(this);
                }
                if (r.type != 0) continue;
                ++this.lineNo;
                r.setLineNo(this.lineNo);
                this.address = (this.address & 0xFFFF0000) + r.getAddress();
                log.debug("Hex record for address {}", (Object)Integer.toHexString(this.address));
                if (this.address >= this.eeStart && this.address < this.eeStart + 1024) {
                    i = 0;
                    while (i < r.len) {
                        this.hexDataEeprom[this.address - this.eeStart + i] = r.getData(i);
                        ++i;
                    }
                    if (this.address + r.len <= this.eeEnd) continue;
                    this.eeEnd = this.address + r.len;
                    continue;
                }
                if (this.address >= 0x300000 && this.address < 0x300400) {
                    i = 0;
                    while (i < r.len) {
                        this.hexDataConfig[this.address - 0x300000 + i] = r.getData(i);
                        ++i;
                    }
                    if (this.address + r.len <= this.configEnd) continue;
                    this.configEnd = this.address + r.len;
                    continue;
                }
                if (this.address >= 0x200000) continue;
                i = 0;
                while (i < r.len) {
                    this.hexDataProg[this.address + i] = r.getData(i);
                    ++i;
                }
                if (this.address + r.len <= this.progEnd) continue;
                this.progEnd = this.address + r.len;
            } while (r.type != 1);
        }
        catch (IOException e) {
            log.error("Exception reading hex file {}");
            this.setDataToErasedState();
            throw new IOException(e);
        }
        log.debug("End addresses prog: {} config: {} EEPROM: {}", new Object[]{Integer.toHexString(this.progEnd), Integer.toHexString(this.configEnd), Integer.toHexString(this.eeEnd)});
    }

    public int readChar() throws IOException {
        return this.buffIn.read();
    }

    public int rdHexByte() throws IOException {
        int hi = this.rdHexDigit();
        int lo = this.rdHexDigit();
        return hi * 16 + lo;
    }

    private int rdHexDigit() throws IOException {
        int b = 0;
        b = this.buffIn.read();
        if (b >= 48 && b <= 57) {
            b -= 48;
        } else if (b >= 65 && b <= 70) {
            b = b - 65 + 10;
        } else if (b >= 97 && b <= 102) {
            b = b - 97 + 10;
        } else {
            log.error("Invalid hex digit {}", (Object)b);
            throw new IOException(Bundle.getMessage("HexInvalidDigit"));
        }
        return (byte)b;
    }

    public int getAddress() {
        return this.address;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    private byte[] getBytes(int offset, int len, byte[] hexData) {
        byte[] d = new byte[len];
        Arrays.fill(d, (byte)-1);
        int end = offset + len;
        if (offset + len > 262144) {
            end = 262144;
        }
        try {
            System.arraycopy(hexData, offset, d, 0, end - offset);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error("Index out of bounds {}", (Throwable)e);
        }
        return d;
    }

    public byte[] getData(int offset, int len) {
        byte[] d = this.getBytes(offset, len, this.hexDataProg);
        return d;
    }

    public byte[] getConfig(int offset, int len) {
        byte[] d = this.getBytes(offset, len, this.hexDataConfig);
        return d;
    }

    public byte[] getEeprom(int offset, int len) {
        byte[] d = this.getBytes(offset, len, this.hexDataEeprom);
        return d;
    }

    public int getProgEnd() {
        return this.progEnd;
    }

    public int getConfigEnd() {
        return this.configEnd;
    }

    public int getEeEnd() {
        return this.eeEnd;
    }

    public void dispose() {
        this.close();
    }
}

