/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import java.util.Arrays;
import jmri.jmrix.can.cbus.swing.bootloader.Bundle;
import jmri.jmrix.can.cbus.swing.bootloader.HexFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusParameters {
    public static final int NUM_PARAM_IDX = 0;
    public static final int MANU_ID_IDX = 1;
    public static final int MINOR_VER_IDX = 2;
    public static final int MODULE_ID_IDX = 3;
    public static final int NUM_EV_IDX = 4;
    public static final int EV_PER_EN_IDX = 5;
    public static final int NUM_NV_IDX = 6;
    public static final int MAJOR_VER_IDX = 7;
    public static final int FLAGS_IDX = 8;
    public static final int PROC_TYPE_IDX = 9;
    public static final int BUS_TYPE_IDX = 10;
    public static final int LOAD_ADDR_IDX = 11;
    public static final int CPU_ID_IDX = 15;
    public static final int CPU_CODE_IDX = 19;
    public static final int BETA_REV_IDX = 20;
    protected int[] paramData = new int[33];
    protected boolean valid = false;
    private static final Logger log = LoggerFactory.getLogger(CbusParameters.class);

    public CbusParameters() {
        Arrays.fill(this.paramData, -1);
    }

    public CbusParameters(byte[] d) {
        this();
        this.paramData[0] = d.length;
        int i = 0;
        while (i < this.paramData[0]) {
            this.paramData[i + 1] = d[i] & 0xFF;
            ++i;
        }
    }

    public int getParam(int i) {
        return this.paramData[i];
    }

    public void setParam(int i, int v) {
        this.paramData[i] = v;
    }

    public CbusParameters validate(HexFile f, CbusParameters hp) {
        CbusParameters fp;
        if (hp.paramData[0] == 7) {
            byte[] d = f.getData(2064, 7);
            fp = new CbusParameters(d);
        } else {
            byte[] d = f.getData(2080, 32);
            fp = new CbusParameters(d);
        }
        if (fp.paramData[1] == hp.paramData[1]) {
            if (fp.paramData[3] == hp.paramData[3]) {
                fp.valid = true;
                if (hp.paramData[0] > 7) {
                    if (fp.paramData[9] == hp.paramData[9]) {
                        fp.valid = true;
                    } else {
                        log.error("Processor type mismatch {} {}", (Object)fp.paramData[9], (Object)hp.paramData[9]);
                    }
                }
                return fp;
            }
            log.error("Module ID mismatch {} {}", (Object)fp.paramData[3], (Object)hp.paramData[3]);
        } else {
            log.error("Manufacturer ID mismatch {} {}", (Object)fp.paramData[1], (Object)hp.paramData[1]);
        }
        fp.valid = false;
        return fp;
    }

    public int getLoadAddress() {
        int la = this.paramData[11] + this.paramData[12] * 256 + this.paramData[13] * 256 * 256 + this.paramData[14] * 256 * 256 * 256;
        log.debug("Load address is {}", (Object)la);
        return la;
    }

    public String toString() {
        if (!this.valid) {
            return Bundle.getMessage("ParamsInvalid");
        }
        return super.toString();
    }

    public boolean areValid() {
        return this.valid;
    }

    public void setValid(boolean s) {
        this.valid = s;
    }
}

