/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jmri.InstanceManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusSend;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.swing.bootloader.Bundle;
import jmri.jmrix.can.cbus.swing.bootloader.CbusParameters;
import jmri.jmrix.can.cbus.swing.bootloader.HexFile;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import jmri.util.swing.BusyDialog;
import jmri.util.swing.TextAreaFIFO;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBootloaderPane
extends CanPanel
implements CanListener {
    protected static final int EE_START_2580 = 0xF00000;
    protected static final int EE_START_26K83 = 0x310000;
    protected static final int EE_START_27Q84 = 0x380000;
    private TrafficController tc;
    private CbusSend send;
    private CbusPreferences preferences;
    private JRadioButtonMenuItem slowWrite;
    private JRadioButtonMenuItem fastWrite;
    protected JTextField nodeNumberField = new JTextField(6);
    protected JCheckBox configCheckBox = new JCheckBox();
    protected JCheckBox eepromCheckBox = new JCheckBox();
    protected JButton programButton;
    protected JButton openFileChooserButton;
    protected JButton readNodeParamsButton;
    private final TextAreaFIFO bootConsole;
    private static final int MAX_LINES = 5000;
    private final JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
    final JFileChooser hexFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
    transient HexFile hexFile = null;
    CbusParameters hardwareParams = null;
    CbusParameters fileParams = null;
    boolean hexForBootloader = false;
    int nodeNumber;
    int nextParam;
    private int eeStart;
    BusyDialog busyDialog;
    protected BootState bootState = BootState.IDLE;
    protected int bootAddress;
    protected int checksum;
    protected int dataFramesSent;
    protected boolean writeInFlight = false;
    protected int dataTimeout;
    private TimerTask allParamTask;
    private TimerTask startBootTask;
    private TimerTask checkBootTask;
    private TimerTask pauseTask;
    private TimerTask programTask;
    private TimerTask initTask;
    private TimerTask dataTask;
    private TimerTask checkTask;
    private TimerTask configTask;
    private TimerTask eeTask;
    private static final Logger log = LoggerFactory.getLogger(CbusBootloaderPane.class);

    public CbusBootloaderPane() {
        this.bootConsole = new TextAreaFIFO(5000);
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.tc = memo.getTrafficController();
        this.addTc(this.tc);
        this.send = new CbusSend(memo, this.bootConsole);
        this.preferences = InstanceManager.getDefault(CbusPreferences.class);
        this.init();
    }

    public void init() {
        this.bootConsole.setEditable(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel nnPane = new JPanel();
        nnPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("BootNodeNumber")));
        nnPane.add(this.nodeNumberField);
        this.nodeNumberField.setText("");
        this.nodeNumberField.setToolTipText(Bundle.getMessage("BootNodeNumberTT"));
        this.nodeNumberField.setMaximumSize(this.nodeNumberField.getPreferredSize());
        this.nodeNumberField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.resetButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.resetButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.resetButtons();
            }

            public void resetButtons() {
                CbusBootloaderPane.this.openFileChooserButton.setEnabled(false);
                CbusBootloaderPane.this.programButton.setEnabled(false);
                CbusBootloaderPane.this.hardwareParams = null;
            }
        });
        nnPane.add(this.nodeNumberField);
        this.configCheckBox.setText(Bundle.getMessage("BootWriteConfigWords"));
        this.configCheckBox.setVisible(true);
        this.eepromCheckBox.setEnabled(true);
        this.eepromCheckBox.setSelected(false);
        this.configCheckBox.setToolTipText(Bundle.getMessage("BootWriteConfigWordsTT"));
        this.eepromCheckBox.setText(Bundle.getMessage("BootWriteEeprom"));
        this.eepromCheckBox.setVisible(true);
        this.eepromCheckBox.setEnabled(true);
        this.eepromCheckBox.setSelected(false);
        this.eepromCheckBox.setToolTipText(Bundle.getMessage("BootWriteEepromTT"));
        JPanel memoryPane = new JPanel();
        memoryPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("BootMemoryOptions")));
        memoryPane.setLayout(new BoxLayout(memoryPane, 0));
        memoryPane.add(this.configCheckBox);
        memoryPane.add(this.eepromCheckBox);
        JPanel selectPane = new JPanel();
        selectPane.setLayout(new BoxLayout(selectPane, 0));
        selectPane.add(nnPane);
        selectPane.add(memoryPane);
        this.readNodeParamsButton = new JButton(Bundle.getMessage("BootReadNodeParams"));
        this.readNodeParamsButton.setVisible(true);
        this.readNodeParamsButton.setEnabled(true);
        this.readNodeParamsButton.setToolTipText(Bundle.getMessage("BootReadNodeParamsTT"));
        this.readNodeParamsButton.addActionListener(e -> this.readNodeParamsButtonActionPerformed(e));
        this.openFileChooserButton = new JButton(Bundle.getMessage("BootChooseFile"));
        this.openFileChooserButton.setVisible(true);
        this.openFileChooserButton.setEnabled(false);
        this.openFileChooserButton.setToolTipText(Bundle.getMessage("BootChooseFileTT"));
        this.openFileChooserButton.addActionListener(e -> this.openFileChooserButtonActionPerformed(e));
        this.programButton = new JButton(Bundle.getMessage("BootStartProgramming"));
        this.programButton.setVisible(true);
        this.programButton.setEnabled(false);
        this.programButton.setToolTipText(Bundle.getMessage("BootStartProgrammingTT"));
        this.programButton.addActionListener(e -> this.programButtonActionPerformed(e));
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.add(this.readNodeParamsButton);
        buttonPane.add(this.openFileChooserButton);
        buttonPane.add(this.programButton);
        JPanel topPane = new JPanel();
        topPane.setLayout(new BoxLayout(topPane, 1));
        topPane.add(selectPane);
        topPane.add(buttonPane);
        JScrollPane feedbackScroll = new JScrollPane(this.bootConsole);
        feedbackScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("BootConsole")));
        feedbackScroll.setPreferredSize(new Dimension(400, 200));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BorderLayout());
        pane1.add((Component)topPane, "First");
        pane1.add((Component)feedbackScroll, "Center");
        this.add(pane1);
        this.setVisible(true);
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemBootloader"));
    }

    private void setMenuOptions() {
        this.slowWrite.setSelected(false);
        this.fastWrite.setSelected(false);
        switch (this.preferences.getBootWriteDelay()) {
            case 10: {
                this.fastWrite.setSelected(true);
                break;
            }
            case 50: {
                this.slowWrite.setSelected(true);
                break;
            }
        }
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        JMenu optionsMenu = new JMenu(Bundle.getMessage("Options"));
        JMenu writeSpeedMenu = new JMenu(Bundle.getMessage("BootWriteSpeed"));
        ButtonGroup backgroundFetchGroup = new ButtonGroup();
        this.slowWrite = new JRadioButtonMenuItem(Bundle.getMessage("Slow"));
        this.fastWrite = new JRadioButtonMenuItem(Bundle.getMessage("Fast"));
        backgroundFetchGroup.add(this.slowWrite);
        backgroundFetchGroup.add(this.fastWrite);
        writeSpeedMenu.add(this.slowWrite);
        writeSpeedMenu.add(this.fastWrite);
        optionsMenu.add(writeSpeedMenu);
        menuList.add(optionsMenu);
        ActionListener writeSpeedListener = ae -> {
            if (this.slowWrite.isSelected()) {
                this.preferences.setBootWriteDelay(CbusNode.BOOT_PROG_TIMEOUT_SLOW);
            } else if (this.fastWrite.isSelected()) {
                this.preferences.setBootWriteDelay(CbusNode.BOOT_PROG_TIMEOUT_FAST);
            }
        };
        this.slowWrite.addActionListener(writeSpeedListener);
        this.slowWrite.addActionListener(writeSpeedListener);
        this.setMenuOptions();
        return menuList;
    }

    int getWriteDelay() {
        if (this.slowWrite.isSelected()) {
            return CbusNode.BOOT_PROG_TIMEOUT_SLOW;
        }
        return CbusNode.BOOT_PROG_TIMEOUT_FAST;
    }

    private void readNodeParamsButtonActionPerformed(ActionEvent e) {
        try {
            this.nodeNumber = Integer.parseInt(this.nodeNumberField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.addToLog(Bundle.getMessage("BootInvalidNode"));
            log.error("Invalid node number {}");
            return;
        }
        this.addToLog(Bundle.getMessage("BootReadingParams"));
        this.hardwareParams = new CbusParameters();
        this.nextParam = 0;
        this.busyDialog = new BusyDialog(this.topFrame, Bundle.getMessage("BootReadingParams"), false);
        this.busyDialog.start();
        this.requestParam(this.nextParam);
    }

    private void openFileChooserButtonActionPerformed(ActionEvent e) {
        int retVal = this.hexFileChooser.showOpenDialog(this);
        if (retVal == 0) {
            this.hexFile = new HexFile(this.hexFileChooser.getSelectedFile().getPath(), this.eeStart);
            log.debug("hex file chosen: {}", (Object)this.hexFile.getName());
            this.addToLog(MessageFormat.format(Bundle.getMessage("BootFileChosen"), this.hexFile.getName()));
            try {
                this.hexFile.openRd();
                this.hexFile.read();
                this.fileParams = new CbusParameters().validate(this.hexFile, this.hardwareParams);
                if (this.fileParams.areValid()) {
                    this.addToLog(MessageFormat.format(Bundle.getMessage("BootHexFileFoundParameters"), this.fileParams.toString()));
                    this.addToLog(MessageFormat.format(Bundle.getMessage("BootHexFileParametersMatch"), this.hardwareParams.toString()));
                    this.programButton.setEnabled(true);
                } else {
                    this.addToLog(Bundle.getMessage("BootHexFileParametersMismatch"));
                }
                if (this.hardwareParams.getLoadAddress() == 0) {
                    this.addToLog(Bundle.getMessage("BootBoot"));
                    this.hexForBootloader = true;
                    this.programButton.setEnabled(true);
                }
            }
            catch (IOException iOException) {
                log.error("Error opening hex file");
                this.addToLog(Bundle.getMessage("BootHexFileOpenFailed"));
            }
        }
    }

    private void programButtonActionPerformed(ActionEvent e) {
        if (this.hasActiveTimers()) {
            return;
        }
        this.openFileChooserButton.setEnabled(false);
        this.programButton.setEnabled(false);
        this.busyDialog = new BusyDialog(this.topFrame, Bundle.getMessage("BootLoading"), false);
        this.busyDialog.start();
        this.setStartBootTimeout();
        this.bootState = BootState.START_BOOT;
        CanMessage m = CbusMessage.getBootEntry(this.nodeNumber, 0);
        this.tc.sendCanMessage(m, null);
    }

    @Override
    public void message(CanMessage m) {
        if ((this.bootState == BootState.PROG_DATA || this.bootState == BootState.CONFIG_DATA || this.bootState == BootState.EEPROM_DATA) && m.isExtended() && CbusMessage.isBootWriteData(m)) {
            log.debug("Boot data write message {}", (Object)m);
            this.writeInFlight = false;
            this.setDataTimeout(this.dataTimeout);
        }
    }

    @Override
    public void reply(CanReply r) {
        if (r.isRtr()) {
            return;
        }
        if (!r.isExtended()) {
            log.debug("Standard Reply {}", (Object)r);
            this.handleStandardReply(r);
        } else {
            log.debug("Extended Reply {} in state {}", (Object)r, (Object)this.bootState);
            this.handleExtendedReply(r);
        }
    }

    private void handleStandardReply(CanReply r) {
        int opc = CbusMessage.getOpcode(r);
        int nn = r.getElement(1) * 256 + r.getElement(2);
        if (nn != this.nodeNumber) {
            log.debug("NN {} Not for me {}", (Object)nn, (Object)this.nodeNumber);
            return;
        }
        if (opc == 155) {
            this.clearAllParamTimeout();
            this.hardwareParams.setParam(r.getElement(3), r.getElement(4));
            if (++this.nextParam < this.hardwareParams.getParam(0) + 1) {
                this.requestParam(this.nextParam);
            } else {
                this.hardwareParams.setValid(true);
                this.addToLog(MessageFormat.format(Bundle.getMessage("BootNodeParametersFinished"), this.hardwareParams.toString()));
                this.busyDialog.finish();
                this.busyDialog = null;
                if (this.hardwareParams.getParam(9) == 20) {
                    log.debug("Using EEPROM base address for PIC 18F25-26K83");
                    this.eeStart = 0x310000;
                } else if (this.hardwareParams.getParam(9) == 21 || this.hardwareParams.getParam(9) == 22) {
                    log.debug("Using EEPROM base address for PIC 18F27-47-57Q84");
                    this.eeStart = 0x380000;
                } else {
                    log.debug("Using EEPROM base address for Generic PIC18");
                    this.eeStart = 0xF00000;
                }
                this.openFileChooserButton.setEnabled(true);
            }
        }
    }

    private void handleExtendedReply(CanReply r) {
        if (CbusMessage.isBootError(r)) {
            this.clearCheckTimeout();
            log.error("Node {} checksum failed", (Object)this.nodeNumber);
            this.addToLog(MessageFormat.format(Bundle.getMessage("BootChecksumFailed"), this.nodeNumber));
            this.endProgramming();
            return;
        }
        switch (this.bootState) {
            default: {
                break;
            }
            case CHECK_BOOT_MODE: {
                this.clearCheckBootTimeout();
                if (!CbusMessage.isBootConfirm(r)) break;
                this.startProgramming(this.hardwareParams.getLoadAddress(), BootState.INIT_PROG_SENT);
                break;
            }
            case PROG_CHECK_SENT: 
            case CONFIG_CHECK_SENT: 
            case EEPROM_CHECK_SENT: {
                if (!CbusMessage.isBootOK(r)) break;
                this.nextRegion();
            }
        }
    }

    protected void sendData(int address, byte[] d, int timeout) {
        this.updateChecksum(d);
        this.bootAddress += 8;
        ++this.dataFramesSent;
        this.writeInFlight = true;
        this.dataTimeout = timeout;
        CanMessage m = CbusMessage.getBootWriteData(d, 0);
        log.debug("Write frame {} at address {} {}", new Object[]{this.dataFramesSent, Integer.toHexString(address), m});
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootAddress"), Integer.toHexString(address)));
        this.tc.sendCanMessage(m, null);
    }

    protected boolean writeNextData() {
        log.debug("writeNextData()");
        if (this.bootAddress == 2040 && this.hexForBootloader) {
            log.debug("Pause for bootloader reset");
            this.bootAddress = 2048;
            this.checksum = 0;
            this.bootState = BootState.PROG_PAUSE;
            this.setPauseTimeout();
            return true;
        }
        if (this.bootAddress < this.hexFile.getProgEnd()) {
            byte[] d = this.hexFile.getData(this.bootAddress, 8);
            this.sendData(this.bootAddress, d, this.getWriteDelay());
            return true;
        }
        if (this.bootAddress >= 0x300000 && this.bootAddress < this.hexFile.getConfigEnd()) {
            byte[] d = this.hexFile.getConfig(this.bootAddress - 0x300000, 8);
            this.sendData(this.bootAddress, d, CbusNode.BOOT_CONFIG_TIMEOUT_TIME);
            return true;
        }
        if (this.bootAddress >= this.eeStart && this.bootAddress < this.hexFile.getEeEnd()) {
            byte[] d = this.hexFile.getEeprom(this.bootAddress - this.eeStart, 8);
            this.sendData(this.bootAddress, d, CbusNode.BOOT_CONFIG_TIMEOUT_TIME);
            return true;
        }
        log.debug("No more data to send {}", (Object)Integer.toHexString(this.bootAddress));
        return false;
    }

    private void nextRegion() {
        this.clearCheckTimeout();
        log.debug("Node {} checksum OK", (Object)this.nodeNumber);
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootChecksumOK"), this.nodeNumber));
        if (this.bootState == BootState.PROG_CHECK_SENT && this.configCheckBox.isSelected()) {
            log.debug("Next region: Config words");
            this.startProgramming(0x300000, BootState.INIT_CONFIG_SENT);
        } else if (this.bootState == BootState.PROG_CHECK_SENT && this.eepromCheckBox.isSelected() || this.bootState == BootState.CONFIG_CHECK_SENT && this.eepromCheckBox.isSelected()) {
            log.debug("Next region: EEPROM");
            this.startProgramming(this.eeStart, BootState.INIT_EEPROM_SENT);
        } else {
            log.debug("Next region: Done");
            this.sendReset();
        }
    }

    private void startProgramming(int address, BootState state) {
        this.bootAddress = address;
        this.checksum = 0;
        this.dataFramesSent = 0;
        this.bootState = state;
        log.debug("Start Programming at address {}", (Object)Integer.toHexString(this.bootAddress));
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootStartAddress"), Integer.toHexString(this.bootAddress)));
        this.setInitTimeout();
        CanMessage m = CbusMessage.getBootInitialise(this.bootAddress, 0);
        this.tc.sendCanMessage(m, null);
    }

    protected void sendReset() {
        this.endProgramming();
        CanMessage m = CbusMessage.getBootReset(0);
        log.debug("Done. Resetting node...");
        this.addToLog(Bundle.getMessage("BootFinished"));
        this.tc.sendCanMessage(m, null);
    }

    private void endProgramming() {
        if (this.busyDialog != null) {
            this.busyDialog.finish();
            this.busyDialog = null;
        }
        this.openFileChooserButton.setEnabled(true);
        this.programButton.setEnabled(true);
        this.bootState = BootState.IDLE;
    }

    protected void updateChecksum(byte[] d) {
        int i = 0;
        while (i < d.length) {
            this.checksum += d[i] & 0xFF;
            ++i;
        }
    }

    public void requestParam(int param) {
        if (this.hasActiveTimers()) {
            return;
        }
        this.setAllParamTimeout(param);
        this.send.rQNPN(this.nodeNumber, param);
    }

    protected boolean hasActiveTimers() {
        return this.allParamTask != null || this.startBootTask != null || this.checkBootTask != null || this.pauseTask != null || this.programTask != null || this.initTask != null || this.dataTask != null || this.checkTask != null || this.configTask != null || this.eeTask != null;
    }

    private void clearAllParamTimeout() {
        if (this.allParamTask != null) {
            this.allParamTask.cancel();
            this.allParamTask = null;
        }
    }

    private void setAllParamTimeout(int index) {
        this.clearAllParamTimeout();
        this.allParamTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.allParamTask = null;
                if (CbusBootloaderPane.this.busyDialog != null) {
                    CbusBootloaderPane.this.busyDialog.finish();
                    CbusBootloaderPane.this.busyDialog = null;
                    CbusBootloaderPane.this.hardwareParams.setValid(true);
                    log.error("Failed to read module parameters from node {}", (Object)CbusBootloaderPane.this.nodeNumber);
                    CbusBootloaderPane.this.addToLog(MessageFormat.format(Bundle.getMessage("BootNodeParametersFailed"), CbusBootloaderPane.this.nodeNumber));
                }
            }
        };
        TimerUtil.schedule(this.allParamTask, CbusNode.SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    private void clearStartBootTimeout() {
        if (this.startBootTask != null) {
            this.startBootTask.cancel();
            this.startBootTask = null;
        }
    }

    private void setStartBootTimeout() {
        this.clearStartBootTimeout();
        this.startBootTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.startBootTask = null;
                CbusBootloaderPane.this.setCheckBootTimeout();
                CbusBootloaderPane.this.bootState = BootState.CHECK_BOOT_MODE;
                CanMessage m = CbusMessage.getBootTest(0);
                CbusBootloaderPane.this.tc.sendCanMessage(m, null);
            }
        };
        TimerUtil.schedule(this.startBootTask, CbusNode.BOOT_ENTRY_TIMEOOUT_TIME);
    }

    private void clearCheckBootTimeout() {
        if (this.checkBootTask != null) {
            this.checkBootTask.cancel();
            this.checkBootTask = null;
        }
    }

    private void setCheckBootTimeout() {
        this.clearCheckBootTimeout();
        this.checkBootTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.checkBootTask = null;
                log.error("Timeout checking for boot mode");
                CbusBootloaderPane.this.addToLog(Bundle.getMessage("BootTimeout"));
                CbusBootloaderPane.this.endProgramming();
            }
        };
        TimerUtil.schedule(this.checkBootTask, CbusNode.BOOT_SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    private void clearInitTimeout() {
        if (this.initTask != null) {
            this.initTask.cancel();
            this.initTask = null;
        }
    }

    private void setInitTimeout() {
        log.debug("setInitTimeout()");
        this.clearInitTimeout();
        this.initTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.initTask = null;
                if (CbusBootloaderPane.this.bootState == BootState.INIT_PROG_SENT) {
                    CbusBootloaderPane.this.bootState = BootState.PROG_DATA;
                    log.debug("Bootstate is PROG_DATA");
                } else if (CbusBootloaderPane.this.bootState == BootState.INIT_CONFIG_SENT) {
                    CbusBootloaderPane.this.bootState = BootState.CONFIG_DATA;
                    log.debug("Bootstate is CONFIG_DATA");
                } else {
                    CbusBootloaderPane.this.bootState = BootState.EEPROM_DATA;
                    log.debug("Bootstate is EEPROM_DATA");
                }
                CbusBootloaderPane.this.writeNextData();
            }
        };
        TimerUtil.schedule(this.initTask, CbusNode.BOOT_SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    private void clearPauseTimeout() {
        if (this.pauseTask != null) {
            this.pauseTask.cancel();
            this.pauseTask = null;
        }
    }

    private void setPauseTimeout() {
        this.clearPauseTimeout();
        this.pauseTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.pauseTask = null;
                CbusBootloaderPane.this.hexForBootloader = false;
                CbusBootloaderPane.this.bootState = BootState.INIT_PROG_SENT;
                log.debug("Start writing at address {}", (Object)Integer.toHexString(CbusBootloaderPane.this.bootAddress));
                CbusBootloaderPane.this.addToLog(MessageFormat.format(Bundle.getMessage("BootStartAddress"), Integer.toHexString(CbusBootloaderPane.this.bootAddress)));
                CbusBootloaderPane.this.setInitTimeout();
                CanMessage m = CbusMessage.getBootInitialise(CbusBootloaderPane.this.bootAddress, 0);
                CbusBootloaderPane.this.tc.sendCanMessage(m, null);
                CbusBootloaderPane.this.writeNextData();
            }
        };
        TimerUtil.schedule(this.pauseTask, CbusNode.BOOT_PAUSE_TIMEOUT_TIME);
    }

    private void clearDataTimeout() {
        if (this.dataTask != null) {
            this.dataTask.cancel();
            this.dataTask = null;
        }
    }

    private void setDataTimeout(int timeout) {
        this.clearDataTimeout();
        this.dataTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.dataTask = null;
                if (!CbusBootloaderPane.this.writeNextData()) {
                    CbusBootloaderPane.this.bootState = CbusBootloaderPane.this.bootState == BootState.PROG_DATA ? BootState.PROG_CHECK_SENT : (CbusBootloaderPane.this.bootState == BootState.CONFIG_DATA ? BootState.CONFIG_CHECK_SENT : BootState.EEPROM_CHECK_SENT);
                    CbusBootloaderPane.this.addToLog(Bundle.getMessage("BootVerifyChecksum"));
                    log.debug("Sending checksum {} as 2s complement {}", (Object)CbusBootloaderPane.this.checksum, (Object)(0 - CbusBootloaderPane.this.checksum));
                    CbusBootloaderPane.this.setCheckTimeout();
                    CanMessage m = CbusMessage.getBootCheck(0 - CbusBootloaderPane.this.checksum, 0);
                    CbusBootloaderPane.this.tc.sendCanMessage(m, null);
                }
            }
        };
        TimerUtil.schedule(this.dataTask, timeout);
    }

    private void clearCheckTimeout() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
            this.checkTask = null;
        }
    }

    private void setCheckTimeout() {
        this.clearCheckTimeout();
        this.checkTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.checkTask = null;
                CbusBootloaderPane.this.endProgramming();
                log.error("Timeout verifying checksum");
                CbusBootloaderPane.this.addToLog(Bundle.getMessage("BootCheckTimeout"));
            }
        };
        TimerUtil.schedule(this.checkTask, CbusNode.BOOT_SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    public void addToLog(String boottext) {
        ThreadingUtil.runOnGUI(() -> this.bootConsole.append("\n" + boottext));
    }

    @Override
    public void dispose() {
        if (this.hexFile != null) {
            this.hexFile.dispose();
        }
        this.bootConsole.dispose();
        this.tc.removeCanListener(this);
    }

    protected static enum BootState {
        IDLE,
        START_BOOT,
        CHECK_BOOT_MODE,
        INIT_PROG_SENT,
        PROG_DATA,
        PROG_PAUSE,
        PROG_CHECK_SENT,
        INIT_CONFIG_SENT,
        CONFIG_DATA,
        CONFIG_CHECK_SENT,
        INIT_EEPROM_SENT,
        EEPROM_DATA,
        EEPROM_CHECK_SENT;

    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemBootloader"), new JmriJFrameInterface(), CbusBootloaderPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

