/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.jmrit.swing.meter.MeterAction;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.cbus.swing.modeswitcher.SprogCbusModeSwitcherAction;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class SprogCbusMenu
extends JMenu {
    Item[] panelItems;

    public SprogCbusMenu(CanSystemConnectionMemo memo) {
        if (memo != null) {
            this.setText(memo.getUserName());
        } else {
            this.setText(Bundle.getMessage("MenuItemCBUS"));
        }
        JmriJFrameInterface wi = new JmriJFrameInterface();
        if (memo != null) {
            this.panelItems = this.createPanelItems(memo);
        }
        Item[] itemArray = this.panelItems;
        int n = this.panelItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item == null) {
                this.add(new JSeparator());
            } else {
                this.add(new CanNamedPaneAction(Bundle.getMessage(item.name), wi, item.load, memo));
            }
            ++n2;
        }
        this.add(new JSeparator());
        if (memo != null && !memo.getProgModeSwitch().equals((Object)ConfigurationManager.ProgModeSwitch.NONE)) {
            this.add(new SprogCbusModeSwitcherAction(Bundle.getMessage("MenuItemSPROGModeSwitcher"), memo));
        }
        this.add(new JSeparator());
        this.add(new MeterAction());
    }

    private Item[] createPanelItems(CanSystemConnectionMemo memo) {
        if (memo.getSubProtocol().equals((Object)ConfigurationManager.SubProtocol.CBUS)) {
            return new Item[]{new Item("MenuItemConsole", "jmri.jmrix.can.cbus.swing.console.CbusConsolePane"), new Item("MenuItemSendFrame", "jmri.jmrix.can.swing.send.CanSendPane"), new Item("MenuItemEventCapture", "jmri.jmrix.can.cbus.swing.configtool.ConfigToolPane"), new Item("MenuItemEventTable", "jmri.jmrix.can.cbus.swing.eventtable.CbusEventTablePane"), new Item("MenuItemNodeConfig", "jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane"), new Item("MenuItemCbusSlotMonitor", "jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorPane"), new Item("MenuItemEvRequestMon", "jmri.jmrix.can.cbus.swing.eventrequestmonitor.CbusEventRequestTablePane"), new Item("MenuItemNetworkSim", "jmri.jmrix.can.cbus.swing.simulator.SimulatorPane"), new Item("MenuItemBootloader", "jmri.jmrix.can.cbus.swing.bootloader.CbusBootloaderPane")};
        }
        return new Item[]{new Item("MenuItemSPROGConsole", "jmri.jmrix.can.cbus.swing.console.CbusConsolePane"), new Item("MenuItemSendFrame", "jmri.jmrix.can.swing.send.CanSendPane"), new Item("MenuItemSPROGNodeConfig", "jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane"), new Item("MenuItemSPROGCbusSlotMonitor", "jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorPane"), new Item("MenuItemSPROGBootloader", "jmri.jmrix.can.cbus.swing.bootloader.CbusBootloaderPane")};
    }

    static class Item {
        String name;
        String load;

        Item(String name, String load) {
            this.name = name;
            this.load = load;
        }
    }
}

