/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.swing.ValidationNotifications;

public class CbusSendEventPane
extends JPanel {
    private final CanPanel _mainPane;
    private JRadioButton onButton;
    private JRadioButton offButton;
    private JRadioButton requestButton;
    private ButtonGroup onOffGroup;
    private ButtonGroup dataGroup;
    private JTextField nnField;
    private JTextField evField;
    private JButton sendEvButton;
    private JCheckBox showEventData;
    private JCheckBox decimalCheckBoxC;
    private JPanel eventDataPanel;
    private JTextField[] data;
    private JRadioButton select0Data;
    private JRadioButton select1Data;
    private JRadioButton select2Data;
    private JRadioButton select3Data;
    private int _selectedData = 0;

    public CbusSendEventPane(CanPanel mainPane) {
        this._mainPane = mainPane;
        this.init();
    }

    private void init() {
        this.onButton = new JRadioButton();
        this.offButton = new JRadioButton();
        this.requestButton = new JRadioButton();
        this.showEventData = new JCheckBox();
        this.onOffGroup = new ButtonGroup();
        this.dataGroup = new ButtonGroup();
        this.sendEvButton = new JButton();
        this.decimalCheckBoxC = new JCheckBox();
        this.initButtons();
        this.addToPanel();
    }

    private void addToPanel() {
        JPanel mainEventPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("ButtonSendEvent")));
        this.nnField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CbusNode")));
        mainEventPanel.add(this.nnField);
        this.evField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CbusEvent")));
        mainEventPanel.add(this.evField);
        mainEventPanel.add(this.decimalCheckBoxC);
        this.onOffGroup.add(this.onButton);
        this.onOffGroup.add(this.offButton);
        this.onOffGroup.add(this.requestButton);
        JPanel group = new JPanel();
        group.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        group.add(this.onButton);
        group.add(this.offButton);
        group.add(this.requestButton);
        mainEventPanel.add(group);
        mainEventPanel.add(this.sendEvButton);
        mainEventPanel.add(this.showEventData);
        this.setLayout(new BoxLayout(this, 1));
        this.add(mainEventPanel);
        this.eventDataPanel = this.getNewDataPanel();
        this.add(this.eventDataPanel);
        this.dataSelectTypePerformed(null);
    }

    private void initButtons() {
        this.onButton.setText(Bundle.getMessage("InitialStateOn"));
        this.onButton.setToolTipText(Bundle.getMessage("TooltipSendOnEvent"));
        this.onButton.setSelected(true);
        this.offButton.setText(Bundle.getMessage("InitialStateOff"));
        this.offButton.setToolTipText(Bundle.getMessage("TooltipSendOffEvent"));
        this.requestButton.setText(Bundle.getMessage("CbusEventRequest"));
        this.requestButton.setToolTipText(Bundle.getMessage("TooltipSendRequestEvent"));
        this.sendEvButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendEvButton.setToolTipText(Bundle.getMessage("TooltipSendEvent"));
        this.decimalCheckBoxC.setText(Bundle.getMessage("ButtonDecimal"));
        this.decimalCheckBoxC.setToolTipText(Bundle.getMessage("TooltipDecimal"));
        this.decimalCheckBoxC.setSelected(true);
        this.showEventData.setText("Event Data");
        this.showEventData.setToolTipText("Show / hide Event Data Input");
        this.addButtonListeners();
    }

    private JPanel getNewDataPanel() {
        this.initDataPanelInputs();
        JPanel dataPanel = new JPanel();
        JPanel group = new JPanel();
        group.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        group.add(this.select0Data);
        group.add(this.select1Data);
        group.add(this.select2Data);
        group.add(this.select3Data);
        this.data = new JTextField[3];
        int i = 0;
        while (i < 3) {
            this.data[i] = new JTextField("0", 10);
            this.data[i].setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), String.valueOf(Bundle.getMessage("OPC_DA")) + (i + 1)));
            this.data[i].setToolTipText(Bundle.getMessage("TooltipDbX", i + 1));
            dataPanel.add(this.data[i]);
            ++i;
        }
        dataPanel.add(group);
        dataPanel.setVisible(false);
        return dataPanel;
    }

    private void initDataPanelInputs() {
        this.select0Data = new JRadioButton();
        this.select1Data = new JRadioButton();
        this.select2Data = new JRadioButton();
        this.select3Data = new JRadioButton();
        this.select0Data.setText("No Data");
        this.select1Data.setText("1 byte");
        this.select2Data.setText("2 bytes");
        this.select3Data.setText("3 bytes");
        this.dataGroup.add(this.select0Data);
        this.dataGroup.add(this.select1Data);
        this.dataGroup.add(this.select2Data);
        this.dataGroup.add(this.select3Data);
        this.select0Data.setSelected(true);
        this._selectedData = 0;
        this.select0Data.addActionListener(this::dataSelectTypePerformed);
        this.select1Data.addActionListener(this::dataSelectTypePerformed);
        this.select2Data.addActionListener(this::dataSelectTypePerformed);
        this.select3Data.addActionListener(this::dataSelectTypePerformed);
    }

    private void addButtonListeners() {
        this.nnField = new JTextField("0", 5);
        this.nnField.setToolTipText("<html>" + Bundle.getMessage("ToolTipNodeNumber") + "<br>" + Bundle.getMessage("ToolTipPrefix") + "</html>");
        this.evField = new JTextField("0", 5);
        this.evField.setToolTipText("<html>" + Bundle.getMessage("ToolTipEvent") + "<br>" + Bundle.getMessage("ToolTipPrefix") + "</html>");
        this.nnField.addActionListener(this::sendEvButtonActionPerformed);
        this.evField.addActionListener(this::sendEvButtonActionPerformed);
        this.sendEvButton.addActionListener(this::sendEvButtonActionPerformed);
        this.showEventData.addActionListener(e -> this.eventDataPanel.setVisible(this.showEventData.isSelected()));
        this.onButton.addActionListener(this::dataSelectTypePerformed);
        this.offButton.addActionListener(this::dataSelectTypePerformed);
        this.requestButton.addActionListener(this::dataSelectTypePerformed);
    }

    private void dataSelectTypePerformed(ActionEvent e) {
        this.select0Data.setEnabled(!this.requestButton.isSelected());
        this.select1Data.setEnabled(!this.requestButton.isSelected());
        this.select2Data.setEnabled(!this.requestButton.isSelected());
        this.select3Data.setEnabled(!this.requestButton.isSelected());
        if (this.requestButton.isSelected() || this.select0Data.isSelected()) {
            this._selectedData = 0;
        } else if (this.select1Data.isSelected()) {
            this._selectedData = 1;
        } else if (this.select2Data.isSelected()) {
            this._selectedData = 2;
        } else if (this.select3Data.isSelected()) {
            this._selectedData = 3;
        }
        this.setWhichDataEnabled(this._selectedData);
    }

    private void setWhichDataEnabled(int numData) {
        int i = 0;
        while (i < 3) {
            this.data[i].setEnabled(numData > i);
            ++i;
        }
    }

    private void sendEvButtonActionPerformed(ActionEvent e) {
        int nn = ValidationNotifications.parseBinDecHexByte(this.nnField.getText().trim(), 65535, this.decimalCheckBoxC.isSelected(), Bundle.getMessage("SendEventNodeError"), this._mainPane);
        if (nn == -1) {
            return;
        }
        int ev = ValidationNotifications.parseBinDecHexByte(this.evField.getText().trim(), 65535, this.decimalCheckBoxC.isSelected(), Bundle.getMessage("SendEventInvalidError"), this._mainPane);
        if (ev == -1) {
            return;
        }
        CbusEvent event = new CbusEvent(this._mainPane.getMemo(), nn, ev);
        if (!this.checkData(event)) {
            return;
        }
        if (this.onButton.isSelected()) {
            event.sendOn();
        } else if (this.offButton.isSelected()) {
            event.sendOff();
        } else {
            event.sendRequest();
        }
    }

    private boolean checkData(CbusEvent event) {
        event.setNumElements(this._selectedData);
        int i = 0;
        while (i < this._selectedData) {
            int dat = ValidationNotifications.parseBinDecHexByte(this.data[i].getText().trim(), 256, this.decimalCheckBoxC.isSelected(), Bundle.getMessage("DbxErrorDialog", i + 1), this._mainPane);
            if (dat == -1) {
                return false;
            }
            event.setData(i + 1, dat);
            ++i;
        }
        return true;
    }
}

