/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import java.awt.Color;
import java.awt.GridLayout;
import javax.annotation.Nonnull;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.DefaultFormatter;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrix.can.cbus.CbusFilterType;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.cbus.swing.CbusFilterFrame;
import jmri.util.ThreadingUtil;

public class CbusFilterPanel
extends JPanel {
    private final CbusFilterType _fType;
    private final int _index;
    private final CbusFilterFrame _filterFrame;
    private String _textLabel;
    private int _countFilter = 0;
    private int _countPass = 0;
    private JLabel fLabel;
    private JPanel evPane;
    private boolean _available;
    private String _buttonText = Bundle.getMessage("ButtonPass");
    private static final Color greenish = new Color(110, 235, 131);
    private static final Color redish = new Color(255, 132, 84);
    private static final Color amberish = new Color(228, 255, 26);
    private JToggleButton enableButton;
    private JToggleButton catButton;
    private static double _iconScale = 0.25;

    public CbusFilterPanel(CbusFilterFrame filterFrame, int index) {
        this._index = index;
        this._filterFrame = filterFrame;
        this._fType = CbusFilterType.CFNODES;
        this._textLabel = Bundle.getMessage("CbusNodes");
        this._available = false;
        this.setVisible(false);
    }

    public CbusFilterPanel(CbusFilterFrame filterFrame, CbusFilterType fType) {
        this._index = fType.ordinal();
        this._filterFrame = filterFrame;
        this._fType = fType;
        this._textLabel = this._fType.getName();
        this._available = true;
        this.initComponents();
    }

    private NamedIcon getCollapsed() {
        NamedIcon collapsed = new NamedIcon("resources/icons/decorations/ArrowStyle2.png", "resources/icons/decorations/ArrowStyle2.png");
        collapsed.scale(_iconScale, this);
        return collapsed;
    }

    private NamedIcon getShowing() {
        NamedIcon showing = new NamedIcon("resources/icons/decorations/ArrowStyle2.png", "resources/icons/decorations/ArrowStyle2.png");
        showing.scale(_iconScale, this);
        showing.setRotation(3, this);
        return showing;
    }

    protected final void initComponents() {
        this.setLayout(new GridLayout(1, 1, 30, 30));
        this.evPane = new JPanel();
        this.evPane.setBackground(Color.white);
        this.catButton = new JToggleButton();
        this.fLabel = new JLabel(this._textLabel, 4);
        this.fLabel.setToolTipText(this.getFilterType().getToolTip());
        if (this.getFilterType().isCategoryHead()) {
            this.evPane.setLayout(new GridLayout(1, 2, 0, 10));
            this.configCatButton(this.catButton);
            this.evPane.add(this.catButton);
        } else {
            this.evPane.setLayout(new GridLayout(1, 2, 40, 10));
            if (this._fType.showSpinners()) {
                this.evPane.add(this.getNewSpinnerAndButton(this._fType));
            } else {
                this.evPane.add(this.fLabel);
            }
        }
        this.enableButton = this.getNewEnableButton();
        this.evPane.add(this.enableButton);
        this.evPane.setVisible(true);
        this.add(this.evPane);
        this.setVisible(this.getFilterType().alwaysDisplay());
    }

    private void configCatButton(@Nonnull JToggleButton button) {
        button.setBackground(Color.white);
        button.setText(this._textLabel);
        button.setIcon(this.getCollapsed());
        button.setHorizontalAlignment(4);
        button.setHorizontalTextPosition(2);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.addActionListener(e -> {
            if (button.isSelected()) {
                button.setIcon(this.getShowing());
            } else {
                button.setIcon(this.getCollapsed());
            }
            ThreadingUtil.runOnGUIEventually(() -> this._filterFrame.showFiltersChanged(this._index, button.isSelected(), this.getFilterType()));
        });
    }

    private JPanel getNewSpinnerAndButton(@Nonnull CbusFilterType fType) {
        JPanel spinnerAndButton = new JPanel();
        spinnerAndButton.setLayout(new GridLayout(1, 2, 0, 0));
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, 0, 65535, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "#");
        spinner.setEditor(editor);
        JFormattedTextField field = (JFormattedTextField)editor.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        spinner.addChangeListener(e -> this._filterFrame.setMinMax(fType, (Integer)spinner.getValue()));
        spinnerAndButton.setBackground(Color.white);
        spinnerAndButton.add(spinner);
        spinnerAndButton.add(this.fLabel);
        return spinnerAndButton;
    }

    private JToggleButton getNewEnableButton() {
        JToggleButton newButton = new JToggleButton();
        newButton.setUI(new BasicToggleButtonUI());
        newButton.setText(this.newTextString());
        newButton.setBackground(greenish);
        newButton.setFocusPainted(false);
        newButton.setToolTipText(Bundle.getMessage("ButtonPassTip"));
        newButton.addActionListener(e -> {
            this.resetenableButton();
            ThreadingUtil.runOnGUIEventually(() -> {
                this._filterFrame.checkBoxChanged(this._index, this.enableButton.isSelected(), this.getFilterType());
                StringBuilder txt = new StringBuilder();
                txt.append(this._textLabel).append(": ").append(this._buttonText);
                if (this.getFilterType().isCategoryHead()) {
                    txt.append(" ").append(Bundle.getMessage("All"));
                }
                this._filterFrame.updateListeners(txt.toString());
            });
        });
        return newButton;
    }

    private void resetenableButton() {
        if (this.enableButton.isSelected()) {
            this._buttonText = Bundle.getMessage("ButtonFilter");
            this.enableButton.setText(this.newTextString());
            this.enableButton.setToolTipText(Bundle.getMessage("ButtonFilterTip"));
            this.enableButton.setBackground(redish);
        } else {
            this._buttonText = Bundle.getMessage("ButtonPass");
            this.enableButton.setText(this.newTextString());
            this.enableButton.setToolTipText(Bundle.getMessage("ButtonPassTip"));
            this.enableButton.setBackground(greenish);
        }
    }

    protected void setMixed() {
        this._buttonText = Bundle.getMessage("ButtonMixed");
        this.enableButton.setText(this.newTextString());
        this.enableButton.setToolTipText(Bundle.getMessage("ButtonMixedTip"));
        this.enableButton.setBackground(amberish);
        this.enableButton.setSelected(false);
    }

    protected final int getIndex() {
        return this._index;
    }

    protected void visibleFilter(boolean showornot) {
        this.setVisible(showornot);
    }

    @Nonnull
    protected final CbusFilterType getFilterType() {
        return this._fType;
    }

    protected void incrementFilter() {
        ++this._countFilter;
        this.enableButton.setText(this.newTextString());
    }

    protected void incrementPass() {
        ++this._countPass;
        this.enableButton.setText(this.newTextString());
    }

    @Nonnull
    private String newTextString() {
        StringBuilder t = new StringBuilder();
        t.append(this._buttonText).append(" ( ").append(this._countPass).append(" / ").append(this._countFilter).append(" ) ");
        return t.toString();
    }

    protected boolean getButton() {
        return this.enableButton.isSelected();
    }

    protected boolean getVisible() {
        return this.isVisible();
    }

    protected boolean getAvailable() {
        return this._available;
    }

    protected void setNode(int node, boolean filter, boolean show) {
        this.initComponents();
        this._available = true;
        this._textLabel = String.valueOf(Bundle.getMessage("CbusNode")) + Integer.toString(node);
        this.fLabel.setText(this._textLabel);
        this.setVisible(show);
        this.setPass(filter);
    }

    protected void setPass(boolean trueorfalse) {
        this.enableButton.setSelected(trueorfalse);
        this.resetenableButton();
    }
}

