/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.EnumSet;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.cbus.CbusFilter;
import jmri.jmrix.can.cbus.CbusFilterType;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.cbus.swing.CbusFilterPanel;
import jmri.jmrix.can.cbus.swing.configtool.ConfigToolPane;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;

public class CbusFilterFrame
extends JmriJFrame {
    private final CbusConsolePane _console;
    private final ConfigToolPane _evCap;
    private final CbusFilter _filter;
    private final HashMap<Integer, CbusFilterPanel> hash_map;
    private static final Dimension minimumSize = new Dimension(400, 200);

    public CbusFilterFrame(CbusConsolePane console, ConfigToolPane evCap) {
        this._console = console;
        this._evCap = evCap;
        this._filter = new CbusFilter(this);
        this.hash_map = new HashMap(CbusFilter.getHMapSize(CbusFilter.CFMAXCATS + 100));
        super.setDefaultCloseOperation(1);
    }

    protected void updateListeners(String text) {
        if (this._console != null) {
            this._console.nextLine(String.valueOf(text) + " \n", String.valueOf(text) + " \n", -1);
        }
    }

    @Nonnull
    protected String title() {
        if (this._console != null) {
            return String.valueOf(this._console.getTitle()) + " " + Bundle.getMessage("EventFilterTitleX", "");
        }
        if (this._evCap != null) {
            return String.valueOf(this._evCap.getTitle()) + " " + Bundle.getMessage("EventFilterTitleX", "");
        }
        return Bundle.getMessage("EventFilterTitleX", "");
    }

    @Override
    public void initComponents() {
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.setTitle(this.title());
        JPanel fPane = new JPanel();
        fPane.setLayout(new BoxLayout(fPane, 1));
        EnumSet.range(CbusFilterType.CFIN, CbusFilterType.CFNODEMAX).forEach(singleFilter -> this.addPaneToMap(fPane, new CbusFilterPanel(this, (CbusFilterType)((Object)singleFilter))));
        int j = 0;
        while (j < 100) {
            this.addPaneToMap(fPane, new CbusFilterPanel(this, CbusFilter.CFMAXCATS + j));
            ++j;
        }
        EnumSet.range(CbusFilterType.CFDATA, CbusFilterType.CFUNKNOWN).forEach(singleFilter -> this.addPaneToMap(fPane, new CbusFilterPanel(this, (CbusFilterType)((Object)singleFilter))));
        JScrollPane fPaneScroll = new JScrollPane();
        fPaneScroll.setPreferredSize(minimumSize);
        fPaneScroll.getViewport().add(fPane);
        fPaneScroll.setHorizontalScrollBarPolicy(31);
        fPaneScroll.setVerticalScrollBarPolicy(22);
        fPaneScroll.setVisible(true);
        this.getContentPane().add(fPaneScroll);
        this.pack();
        this.updateListeners(Bundle.getMessage("FilterWindowActive"));
    }

    public void addPaneToMap(JPanel fPane, CbusFilterPanel panel) {
        fPane.add(panel);
        this.hash_map.put(panel.getIndex(), panel);
    }

    public void addNode(int nodenum, int position) {
        this.hash_map.get(position).setNode(nodenum, this.hash_map.get(CbusFilterType.CFNODE.ordinal()).getButton(), this.hash_map.get(CbusFilterType.CFNODEMIN.ordinal()).getVisible());
    }

    protected void checkBoxChanged(int id, boolean newselected, @Nonnull CbusFilterType changedFilter) {
        this._filter.setFilter(id, newselected);
        if (changedFilter.alwaysDisplay()) {
            this.setCategoryChanged(id, newselected, changedFilter);
        } else {
            if (changedFilter.getCategory() == null) {
                return;
            }
            boolean hasTrue = this.hash_map.values().stream().filter((? super T value) -> value.getFilterType().getCategory() == changedFilter.getCategory() && value.getAvailable() && value.getButton()).count() > 0L;
            boolean hasFalse = this.hash_map.values().stream().filter((? super T value) -> value.getFilterType().getCategory() == changedFilter.getCategory() && value.getAvailable() && !value.getButton()).count() > 0L;
            this.setFilterMaybeMixed(changedFilter.getCategory(), hasTrue, hasFalse);
        }
    }

    private void setFilterMaybeMixed(CbusFilterType changedFilter, boolean hasTrue, boolean hasFalse) {
        if (hasTrue && hasFalse) {
            this.hash_map.get(changedFilter.ordinal()).setMixed();
            this._filter.setFilter(changedFilter.ordinal(), false);
        } else if (hasTrue && !hasFalse) {
            this.hash_map.get(changedFilter.ordinal()).setPass(true);
            this._filter.setFilter(changedFilter.ordinal(), true);
        } else if (!hasTrue && hasFalse) {
            this.hash_map.get(changedFilter.ordinal()).setPass(false);
            this._filter.setFilter(changedFilter.ordinal(), false);
        }
    }

    private void setCategoryChanged(int id, boolean newselected, @Nonnull CbusFilterType changedFilter) {
        this.hash_map.values().stream().filter((? super T value) -> value.getFilterType().getCategory() == changedFilter && value.getAvailable()).forEach(value -> {
            this._filter.setFilter(id, newselected);
            value.setPass(newselected);
        });
    }

    protected void showFiltersChanged(int id, boolean newselected, @Nonnull CbusFilterType categoryType) {
        this.hash_map.values().stream().filter((? super T value) -> value.getFilterType().getCategory() == categoryType && value.getAvailable()).forEach(value -> value.visibleFilter(newselected));
    }

    public void passIncrement(int id) {
        ThreadingUtil.runOnGUIEventually(() -> this.hash_map.get(id).incrementPass());
    }

    protected void setMinMax(@Nonnull CbusFilterType filter, int value) {
        this._filter.setMinMax(filter, value);
        switch (filter) {
            case CFEVENTMIN: {
                this.updateListeners(Bundle.getMessage("MinEventSet", value));
                break;
            }
            case CFEVENTMAX: {
                this.updateListeners(Bundle.getMessage("MaxEventSet", value));
                break;
            }
            case CFNODEMIN: {
                this.updateListeners(Bundle.getMessage("MinNodeSet", value));
                break;
            }
            case CFNODEMAX: {
                this.updateListeners(Bundle.getMessage("MaxNodeSet", value));
                break;
            }
        }
    }

    public boolean filter(@Nonnull AbstractMessage m) {
        int result = this._filter.filter(m);
        if (result > -1) {
            ThreadingUtil.runOnGUIEventually(() -> this.hash_map.get(result).incrementFilter());
            return true;
        }
        return false;
    }
}

