/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.cbus.swing.CbusEventHighlightFrame;

public class CbusEventHighlightPanel
extends JPanel {
    private int _index;
    private CbusEventHighlightFrame _highlightFrame;
    private Boolean _isActive;
    protected JCheckBox evEnButton = new JCheckBox();
    protected JCheckBox nnEnButton = new JCheckBox();
    protected JSpinner eventnumberspinner = new JSpinner(new SpinnerNumberModel(1, 1, 65535, 1));
    protected JSpinner nodenumberspinner = new JSpinner(new SpinnerNumberModel(0, 0, 65535, 1));
    protected JCheckBox onButton = new JCheckBox();
    protected JCheckBox offButton = new JCheckBox();
    protected JCheckBox inButton = new JCheckBox();
    protected JCheckBox outButton = new JCheckBox();

    public CbusEventHighlightPanel(CbusEventHighlightFrame highlightFrame, int index) {
        this._index = index;
        this._highlightFrame = highlightFrame;
    }

    protected CbusEventHighlightPanel() {
    }

    public void initComponents(int index) {
        this._isActive = false;
        this.setLayout(new BoxLayout(this, 0));
        JPanel evPane = new JPanel();
        evPane.setLayout(new BoxLayout(evPane, 0));
        evPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("EventCol")));
        this.evEnButton.setText(Bundle.getMessage("ButtonEnable"));
        this.evEnButton.setVisible(true);
        this.evEnButton.setSelected(true);
        this.evEnButton.setToolTipText(Bundle.getMessage("EnableEventTooltip"));
        evPane.add(this.evEnButton);
        this.eventnumberspinner.setToolTipText(Bundle.getMessage("EvLowfieldTooltip"));
        evPane.add(this.eventnumberspinner);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.eventnumberspinner, "#");
        this.eventnumberspinner.setEditor(editor);
        JFormattedTextField fieldEv = (JFormattedTextField)editor.getComponent(0);
        DefaultFormatter formatterEv = (DefaultFormatter)fieldEv.getFormatter();
        fieldEv.setColumns(2);
        formatterEv.setCommitsOnValidEdit(true);
        this.add(evPane);
        JPanel nnPane = new JPanel();
        nnPane.setLayout(new BoxLayout(nnPane, 0));
        nnPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("NodeNumberTitle")));
        this.nnEnButton.setText(Bundle.getMessage("ButtonEnable"));
        this.nnEnButton.setVisible(true);
        this.nnEnButton.setToolTipText(Bundle.getMessage("EnableNodeTooltip"));
        nnPane.add(this.nnEnButton);
        JSpinner.NumberEditor neditor = new JSpinner.NumberEditor(this.nodenumberspinner, "#");
        this.nodenumberspinner.setEditor(neditor);
        JFormattedTextField fieldNd = (JFormattedTextField)neditor.getComponent(0);
        DefaultFormatter formatterNd = (DefaultFormatter)fieldNd.getFormatter();
        fieldNd.setColumns(2);
        formatterNd.setCommitsOnValidEdit(true);
        this.nodenumberspinner.setToolTipText(Bundle.getMessage("NnLowfieldTooltip"));
        nnPane.add(this.nodenumberspinner);
        this.add(nnPane);
        JPanel eventPane = new JPanel();
        eventPane.setLayout(new BoxLayout(eventPane, 0));
        eventPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("EventTypeTitle")));
        this.onButton.setText(Bundle.getMessage("CbusEventOn"));
        this.onButton.setVisible(true);
        this.onButton.setToolTipText(Bundle.getMessage("OnEventsTooltip"));
        eventPane.add(this.onButton);
        this.offButton.setText(Bundle.getMessage("CbusEventOff"));
        this.offButton.setVisible(true);
        this.offButton.setToolTipText(Bundle.getMessage("OffEventsTooltip"));
        eventPane.add(this.offButton);
        this.add(eventPane);
        JPanel directionPane = new JPanel();
        directionPane.setLayout(new BoxLayout(directionPane, 0));
        directionPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("EventdirectionTitle")));
        this.inButton.setText(Bundle.getMessage("InEventsButton"));
        this.inButton.setVisible(true);
        this.inButton.setToolTipText(Bundle.getMessage("InEventsTooltip"));
        directionPane.add(this.inButton);
        this.outButton.setText(Bundle.getMessage("OutEventsButton"));
        this.outButton.setVisible(true);
        this.outButton.setToolTipText(Bundle.getMessage("OutEventsTooltip"));
        directionPane.add(this.outButton);
        this.add(directionPane);
        this.eventnumberspinner.addChangeListener(e -> {
            if (this.evEnButton.isSelected()) {
                this.setoptions();
            }
        });
        this.nodenumberspinner.addChangeListener(e -> {
            if (this.nnEnButton.isSelected()) {
                this.setoptions();
            }
        });
        this.nnEnButton.addActionListener(e -> this.setoptions());
        this.evEnButton.addActionListener(e -> this.setoptions());
        this.onButton.addActionListener(e -> this.setoptions());
        this.offButton.addActionListener(e -> this.setoptions());
        this.inButton.addActionListener(e -> this.setoptions());
        this.outButton.addActionListener(e -> this.setoptions());
    }

    private void setoptions() {
        int nn = 0;
        int ev = 0;
        int ty = 3;
        int dr = 0;
        if (this.nnEnButton.isSelected()) {
            nn = (Integer)this.nodenumberspinner.getValue();
        }
        if (this.evEnButton.isSelected()) {
            ev = (Integer)this.eventnumberspinner.getValue();
        }
        if (this.onButton.isSelected()) {
            ty = 0;
        }
        if (this.offButton.isSelected()) {
            ty = 1;
        }
        if (this.onButton.isSelected() && this.offButton.isSelected()) {
            ty = 2;
        }
        if (this.inButton.isSelected()) {
            ++dr;
        }
        if (this.outButton.isSelected()) {
            dr += 2;
        }
        if (dr > 0 && this._isActive.booleanValue() && ty != 3) {
            this._highlightFrame.enable(this._index, nn, this.nnEnButton.isSelected(), ev, this.evEnButton.isSelected(), ty, dr);
        }
        if (dr > 0 && !this._isActive.booleanValue() && ty != 3) {
            this._highlightFrame.enable(this._index, nn, this.nnEnButton.isSelected(), ev, this.evEnButton.isSelected(), ty, dr);
            this._isActive = true;
        }
        if ((dr == 0 || ty == 3) && this._isActive.booleanValue()) {
            this._highlightFrame.disable(this._index);
            this._isActive = false;
        }
    }
}

