/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.cbus.CbusEventHighlighter;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.cbus.swing.CbusEventHighlightPanel;
import jmri.jmrix.can.cbus.swing.configtool.ConfigToolPane;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.util.JmriJFrame;

public class CbusEventHighlightFrame
extends JmriJFrame {
    protected static final int HIGHLIGHTERS = 4;
    public static final Color[] highlightColors = new Color[]{new Color(110, 235, 131), new Color(68, 235, 255), new Color(228, 255, 26), new Color(255, 132, 84)};
    protected CbusEventHighlightPanel[] highlightPanes = new CbusEventHighlightPanel[4];
    protected CbusEventHighlighter[] _highlight = new CbusEventHighlighter[4];
    protected boolean[] _highlightActive = new boolean[4];
    private CbusConsolePane _console;
    private ConfigToolPane _evCap;

    public CbusEventHighlightFrame(CbusConsolePane console, ConfigToolPane evCap) {
        int i = 0;
        while (i < 4) {
            this._highlight[i] = new CbusEventHighlighter();
            this._highlightActive[i] = false;
            ++i;
        }
        this._console = console;
        this._evCap = evCap;
        this.setDefaultCloseOperation(1);
    }

    protected CbusEventHighlightFrame() {
    }

    @Override
    public String getTitle() {
        if (this._console != null) {
            return String.valueOf(this._console.getTitle()) + " " + Bundle.getMessage("EventHighlightTitle");
        }
        if (this._evCap != null) {
            return String.valueOf(this._evCap.getTitle()) + " " + Bundle.getMessage("EventHighlightTitle");
        }
        return Bundle.getMessage("EventHighlightTitle");
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void initComponents() {
        this.setTitle(this.getTitle());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        int i = 0;
        while (i < 4) {
            this.highlightPanes[i] = new CbusEventHighlightPanel(this, i);
            this.highlightPanes[i].setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(highlightColors[i], 4), Bundle.getMessage("EventHighlightTitleX", i + 1)));
            this.highlightPanes[i].initComponents(i);
            this.getContentPane().add(this.highlightPanes[i]);
            ++i;
        }
        this.pack();
    }

    public void enable(int index, int nn, boolean nnEn, int ev, boolean evEn, int ty, int dr) {
        this._highlight[index].setNn(nn);
        this._highlight[index].setNnEnable(nnEn);
        this._highlight[index].setEv(ev);
        this._highlight[index].setEvEnable(evEn);
        this._highlight[index].setType(ty);
        this._highlight[index].setDir(dr);
        this._highlightActive[index] = true;
        if (this._console != null) {
            this.updateConsole(index);
        }
    }

    private void updateConsole(int index) {
        StringBuilder sb = new StringBuilder(80);
        if (this._highlight[index].getNnEnable()) {
            sb.append(Bundle.getMessage("CbusNode")).append(this._highlight[index].getNn()).append(" ");
        }
        if (this._highlight[index].getEvEnable()) {
            sb.append(Bundle.getMessage("CbusEvent")).append(this._highlight[index].getEv()).append(" ");
        }
        this.appendType(sb, index);
        this.appendDirection(sb, index);
        sb.append("\n");
        this._console.nextLine(sb.toString(), sb.toString(), index);
    }

    private void appendType(StringBuilder sb, int index) {
        switch (this._highlight[index].getType()) {
            case 0: {
                sb.append(Bundle.getMessage("CbusEventOn"));
                break;
            }
            case 1: {
                sb.append(Bundle.getMessage("CbusEventOff"));
                break;
            }
            default: {
                sb.append(Bundle.getMessage("CbusEventOnOrOff"));
            }
        }
    }

    private void appendDirection(StringBuilder sb, int index) {
        switch (this._highlight[index].getDir()) {
            case 1: {
                sb.append(Bundle.getMessage("InEventsTooltip"));
                break;
            }
            case 2: {
                sb.append(Bundle.getMessage("OutEventsTooltip"));
                break;
            }
            default: {
                sb.append(Bundle.getMessage("InOrOutEventsToolTip"));
            }
        }
    }

    public void disable(int index) {
        this._highlightActive[index] = false;
        if (this._console != null) {
            this._console.nextLine(String.valueOf(Bundle.getMessage("HighlightDisabled")) + " \n", String.valueOf(Bundle.getMessage("HighlightDisabled")) + " \n", index);
        }
    }

    public int highlight(AbstractMessage m) {
        int i = 0;
        while (i < 4) {
            if (this._highlightActive[i] && this._highlight[i].highlight(m)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Color getColor(int i) {
        return highlightColors[i];
    }
}

