/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import java.awt.Color;
import java.text.DateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.swing.Bundle;

public class CbusCommonSwing {
    public static final Color VERY_LIGHT_RED = new Color(255, 176, 173);
    public static final Color VERY_LIGHT_GREEN = new Color(165, 255, 164);
    public static final Color WHITE_GREEN = new Color(245, 245, 245);
    public static final Color GOLD = new Color(255, 204, 51);

    public static void setCellBackground(boolean isSelected, JComponent f, JTable table, int row) {
        f.setBackground(isSelected ? table.getSelectionBackground() : (row % 2 == 0 ? table.getBackground() : WHITE_GREEN));
    }

    public static void setCellFocus(boolean hasFocus, JComponent f, JTable table) {
        f.setBorder(hasFocus ? BorderFactory.createMatteBorder(1, 1, 1, 1, Color.blue) : BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    public static void hideNumbersLessThan(int min, String string, JTextField f) {
        try {
            if (Integer.parseInt(string) < min) {
                f.setText("");
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public static void setCellFromCbusEventEnum(Object object, JTextField f) {
        if (object instanceof CbusEventDataElements.EvState) {
            CbusEventDataElements.EvState state = (CbusEventDataElements.EvState)((Object)object);
            switch (state) {
                case ON: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("CbusEventOn"), VERY_LIGHT_GREEN);
                    break;
                }
                case OFF: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("CbusEventOff"), VERY_LIGHT_RED);
                    break;
                }
                case REQUEST: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("CbusEventRequest"), GOLD);
                    break;
                }
                case UNKNOWN: {
                    f.setText("");
                    break;
                }
            }
        }
    }

    public static void setCellFromBackupEnum(Object object, JTextField f) {
        if (object instanceof CbusNodeConstants.BackupType) {
            CbusNodeConstants.BackupType type = (CbusNodeConstants.BackupType)((Object)object);
            switch (type) {
                case INCOMPLETE: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("BackupIncomplete"), VERY_LIGHT_RED);
                    break;
                }
                case COMPLETE: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("BackupComplete"), VERY_LIGHT_GREEN);
                    break;
                }
                case COMPLETEDWITHERROR: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("BackupCompleteError"), VERY_LIGHT_RED);
                    break;
                }
                case NOTONNETWORK: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("BackupNotOnNetwork"), VERY_LIGHT_RED);
                    break;
                }
                case OUTSTANDING: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("BackupOutstanding"), GOLD);
                    break;
                }
                case SLIM: {
                    CbusCommonSwing.setTextBackGround(f, Bundle.getMessage("NodeInSlim"), GOLD);
                    break;
                }
            }
        }
    }

    private static void setTextBackGround(JTextField f, String text, Color bg) {
        f.setBackground(bg);
        f.setText(text);
    }

    public static void setCellFromDate(Object object, JTextField f, DateFormat dformat) {
        if (object instanceof Date) {
            f.setText(dformat.format((Date)object));
        }
    }

    public static void setCellTextHighlighter(String textForSearch, String string, JTextField f) {
        if (Pattern.compile(Pattern.quote(textForSearch), 2).matcher(string).find()) {
            string = string.toLowerCase();
            textForSearch = textForSearch.toLowerCase();
            int indexOf = string.indexOf(textForSearch);
            try {
                f.getHighlighter().addHighlight(indexOf, indexOf + textForSearch.length(), new DefaultHighlighter.DefaultHighlightPainter(Color.CYAN));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public static void configureTable(JTable table) {
        table.getTableHeader().setReorderingAllowed(true);
        table.createDefaultColumnsFromModel();
        table.setAutoCreateColumnsFromModel(false);
        table.setAutoResizeMode(0);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(false);
        table.setSelectionMode(0);
        table.setRowHeight(new JTextField((String)"Y").getPreferredSize().height + 6);
        table.setName(table.getModel().getClass().getName());
        int i = 0;
        while (i < table.getColumnCount()) {
            int width = Math.min(260, new JTextField((String)table.getColumnName((int)i)).getPreferredSize().width * 2);
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        table.sizeColumnsToFit(-1);
    }
}

