/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.simulator.CbusDummyCS;
import jmri.jmrix.can.cbus.simulator.CbusDummyNode;
import jmri.jmrix.can.cbus.simulator.CbusEventResponder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusSimulator {
    private final CanSystemConnectionMemo memo;
    public ArrayList<CbusDummyCS> _csArr;
    public ArrayList<CbusDummyNode> _ndArr;
    public ArrayList<CbusEventResponder> _evResponseArr;
    private static final Logger log = LoggerFactory.getLogger(CbusSimulator.class);

    public CbusSimulator(CanSystemConnectionMemo sysmemo) {
        this.memo = sysmemo;
        InstanceManager.store(this, CbusSimulator.class);
        this.init();
    }

    public final void init() {
        log.info("Starting CBUS Network Simulation Tools");
        this._csArr = new ArrayList();
        this._csArr.add(new CbusDummyCS(this.memo));
        this._ndArr = new ArrayList();
        this._ndArr.add(new CbusDummyNode(0, 165, 0, 0, this.memo));
        this._evResponseArr = new ArrayList();
        this._evResponseArr.add(new CbusEventResponder(this.memo));
    }

    public int getNumCS() {
        return this._csArr.size();
    }

    public int getNumNd() {
        return this._ndArr.size();
    }

    public int getNumEv() {
        return this._evResponseArr.size();
    }

    public CbusDummyCS getCS(int id) {
        return this._csArr.get(id);
    }

    public CbusDummyNode getNd(int id) {
        return this._ndArr.get(id);
    }

    public CbusEventResponder getEv(int id) {
        return this._evResponseArr.get(id);
    }

    public CbusDummyCS getNewCS() {
        CbusDummyCS newcs = new CbusDummyCS(this.memo);
        this._csArr.add(newcs);
        return newcs;
    }

    public CbusDummyNode getNewNd() {
        CbusDummyNode newnd = new CbusDummyNode(0, 165, 0, 0, this.memo);
        this._ndArr.add(newnd);
        return newnd;
    }

    public CbusEventResponder getNewEv() {
        CbusEventResponder newcs = new CbusEventResponder(this.memo);
        this._evResponseArr.add(newcs);
        return newcs;
    }

    public void dispose() {
        log.info("Stopping all CBUS Simulation Tools");
        int i = 0;
        while (i < this._csArr.size()) {
            this._csArr.get(i).dispose();
            this._csArr.set(i, null);
            ++i;
        }
        this._csArr = null;
        i = 0;
        while (i < this._ndArr.size()) {
            this._ndArr.get(i).dispose();
            this._ndArr.set(i, null);
            ++i;
        }
        this._ndArr = null;
        i = 0;
        while (i < this._evResponseArr.size()) {
            this._evResponseArr.get(i).dispose();
            this._evResponseArr.set(i, null);
            ++i;
        }
        this._evResponseArr = null;
        InstanceManager.deregister(this, CbusSimulator.class);
    }
}

