/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.simulator.CbusDummyNode;
import jmri.jmrix.can.cbus.simulator.CbusSimCanListener;
import jmri.util.StringUtil;

public class CbusDummyNodeCanListener
extends CbusSimCanListener {
    private final CbusDummyNode _dummyNode;

    public CbusDummyNodeCanListener(CanSystemConnectionMemo connmemo, CbusDummyNode node) {
        super(connmemo, node);
        this._dummyNode = node;
        this.setDelay(40);
    }

    @Override
    protected void startProcessFrame(AbstractMessage m) {
        if (this._dummyNode.getNodeParamManager().getParameter(3) == 0) {
            return;
        }
        if (this._dummyNode.getNodeInSetupMode()) {
            this.processDummyCanSetupMode(m);
        } else if (this._dummyNode.getNodeInFLiMMode()) {
            if (m.getElement(0) == 13) {
                this._dummyNode.sendPNN();
            }
            if (this._dummyNode.getNodeNumber() == m.getElement(1) * 256 + m.getElement(2)) {
                this.processDummyCanFLimMode(m);
            }
            if (this._dummyNode.getNodeInLearnMode()) {
                this.processDummyCanLearnMode(m);
            }
        }
    }

    private void processDummyCanFLimMode(AbstractMessage m) {
        switch (m.getElement(0)) {
            case 84: {
                this._dummyNode.setNodeInLearnMode(false);
                break;
            }
            case 83: {
                this._dummyNode.setNodeInLearnMode(true);
                break;
            }
            case 115: {
                this._dummyNode.sendPARAN(m.getElement(3));
                break;
            }
            case 113: {
                this._dummyNode.sendNVANS(m.getElement(3));
                break;
            }
            case 150: {
                this._dummyNode.setDummyNV(m.getElement(3), m.getElement(4));
                break;
            }
            default: {
                this.processDummyCanFLimModeEventStuff(m);
            }
        }
    }

    private void processDummyCanFLimModeEventStuff(AbstractMessage m) {
        switch (m.getElement(0)) {
            case 88: {
                this._dummyNode.sendNUMEV();
                break;
            }
            case 87: {
                this._dummyNode.sendENRSP();
                break;
            }
            case 156: {
                this._dummyNode.sendNEVAL(m.getElement(3), m.getElement(4));
                break;
            }
        }
    }

    private void processDummyCanSetupMode(AbstractMessage m) {
        switch (m.getElement(0)) {
            case 16: {
                this._dummyNode.sendPARAMS();
                break;
            }
            case 66: {
                this._dummyNode.setDNN(m.getElement(1) * 256 + m.getElement(2));
                break;
            }
            case 17: {
                byte[] byteArr = StringUtil.fullTextToHexArray(this._dummyNode.getNodeNameFromName(), 7);
                CanReply r = new CanReply(8);
                r.setElement(0, 226);
                r.setElement(1, byteArr[0] & 0xFF);
                r.setElement(2, byteArr[1] & 0xFF);
                r.setElement(3, byteArr[2] & 0xFF);
                r.setElement(4, byteArr[3] & 0xFF);
                r.setElement(5, byteArr[4] & 0xFF);
                r.setElement(6, byteArr[5] & 0xFF);
                r.setElement(7, byteArr[6] & 0xFF);
                this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
                break;
            }
        }
    }

    private void processDummyCanLearnMode(AbstractMessage m) {
        switch (m.getElement(0)) {
            case 210: {
                this.evLearn(m.getElement(1) * 256 + m.getElement(2), m.getElement(3) * 256 + m.getElement(4), m.getElement(5), m.getElement(6));
                break;
            }
            case 149: {
                this._dummyNode.getNodeEventManager().removeEvent(m.getElement(1) * 256 + m.getElement(2), m.getElement(3) * 256 + m.getElement(4));
                break;
            }
            case 85: {
                if (m.getElement(1) * 256 + m.getElement(2) != this._dummyNode.getNodeNumber()) break;
                this._dummyNode.getNodeEventManager().resetNodeEventsToZero();
                break;
            }
        }
    }

    private void evLearn(int nn, int en, int index, int val) {
        if (val < 0 || val > 255) {
            this._dummyNode.sendCMDERR(11);
            return;
        }
        if (index < 0 || index > 255) {
            this._dummyNode.sendCMDERR(6);
            return;
        }
        this._dummyNode.getNodeEventManager().provideNodeEvent(nn, en).setEvVar(index, val);
        if (this._dummyNode.getNodeEventManager().provideNodeEvent(nn, en).getIndex() < 0) {
            this._dummyNode.getNodeEventManager().provideNodeEvent(nn, en).setIndex(this._dummyNode.getNodeEventManager().getNextFreeIndex());
        }
        this._dummyNode.sendWRACK();
    }
}

