/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import java.util.ArrayList;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeCanListener;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.simulator.CbusDummyNodeCanListener;
import jmri.jmrix.can.cbus.swing.simulator.NdPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusDummyNode
extends CbusNode {
    private NdPane _pane;
    private CbusDummyNodeCanListener canListener;
    private static final Logger log = LoggerFactory.getLogger(CbusDummyNode.class);

    public CbusDummyNode(int nodenumber, int manufacturer, int nodeType, int canId, CanSystemConnectionMemo sysmemo) {
        super(sysmemo, nodenumber);
        this.setDummyType(manufacturer, nodeType);
        this.setCanId(canId);
        this._pane = null;
    }

    @Override
    public CbusNodeCanListener getNewCanListener() {
        this.canListener = new CbusDummyNodeCanListener(this._memo, this);
        return this.canListener;
    }

    public static final ArrayList<Integer> getNodeTypes() {
        ArrayList<Integer> ndTypes = new ArrayList<Integer>();
        ndTypes.add(0);
        ndTypes.add(29);
        ndTypes.add(255);
        return ndTypes;
    }

    protected void sendNUMEV() {
        CanReply r = new CanReply(4);
        r.setElement(0, 116);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        r.setElement(3, Math.max(0, this.getNodeEventManager().getTotalNodeEvents()) & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendENRSP() {
        int extraDelay = 5;
        int i = 0;
        while (i < this.getNodeEventManager().getTotalNodeEvents()) {
            CbusNodeEvent ndEv = this.getNodeEventManager().getNodeEventByArrayID(i);
            if (ndEv == null) break;
            if (ndEv.getIndex() < 0) {
                ndEv.setIndex(this.getNodeEventManager().getNextFreeIndex());
            }
            CanReply r = new CanReply(8);
            r.setElement(0, 242);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, ndEv.getNn() >> 8);
            r.setElement(4, ndEv.getNn() & 0xFF);
            r.setElement(5, ndEv.getEn() >> 8);
            r.setElement(6, ndEv.getEn() & 0xFF);
            r.setElement(7, ndEv.getIndex() & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay() + extraDelay * i);
            ++i;
        }
    }

    protected void sendNEVAL(int index, int varIndex) {
        CbusNodeEvent _ndEv = this.getNodeEventManager().getNodeEventByIndex(index);
        if (index < 0 || index > 255) {
            this.sendCMDERR(7);
        } else if (_ndEv == null) {
            this.sendCMDERR(12);
        } else {
            CanReply r = new CanReply(6);
            r.setElement(0, 181);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, index & 0xFF);
            r.setElement(4, varIndex & 0xFF);
            r.setElement(5, _ndEv.getEvVar(varIndex) & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
    }

    protected void sendPARAMS() {
        CanReply r = new CanReply(8);
        r.setElement(0, 239);
        r.setElement(1, this.getNodeParamManager().getParameter(1) & 0xFF);
        r.setElement(2, this.getNodeParamManager().getParameter(2) & 0xFF);
        r.setElement(3, this.getNodeParamManager().getParameter(3) & 0xFF);
        r.setElement(4, this.getNodeParamManager().getParameter(4) & 0xFF);
        r.setElement(5, this.getNodeParamManager().getParameter(5) & 0xFF);
        r.setElement(6, this.getNodeParamManager().getParameter(6) & 0xFF);
        r.setElement(7, this.getNodeParamManager().getParameter(7) & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendPNN() {
        CanReply r = new CanReply(6);
        r.setElement(0, 182);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        r.setElement(3, this.getNodeParamManager().getParameter(1) & 0xFF);
        r.setElement(4, this.getNodeParamManager().getParameter(3) & 0xFF);
        r.setElement(5, this.getNodeParamManager().getParameter(8) & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendPARAN(int index) {
        try {
            CanReply r = new CanReply(5);
            r.setElement(0, 155);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, index & 0xFF);
            r.setElement(4, this.getNodeParamManager().getParameter(index) & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.sendCMDERR(9);
        }
    }

    protected void sendNVANS(int index) {
        try {
            CanReply r = new CanReply(5);
            r.setElement(0, 151);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, index & 0xFF);
            r.setElement(4, this.getNodeNvManager().getNV(index) & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.sendCMDERR(10);
        }
    }

    protected void setDummyNV(int index, int newval) {
        if (newval < 0 || newval > 255) {
            this.sendCMDERR(12);
            return;
        }
        if (index == 0) {
            this.sendCMDERR(10);
            return;
        }
        try {
            this.getNodeNvManager().setNV(index, newval);
            if (this.getsendsWRACKonNVSET()) {
                this.sendWRACK();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.sendCMDERR(10);
        }
    }

    protected void sendCMDERR(int errorId) {
        CanReply r = new CanReply(4);
        r.setElement(0, 111);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        r.setElement(3, errorId & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendWRACK() {
        CanReply r = new CanReply(3);
        r.setElement(0, 89);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    public void flimButton() {
        if (this.getNodeParamManager().getParameter(3) > 0) {
            this.setNodeInSetupMode(true);
            CanReply r = new CanReply(3);
            r.setElement(0, 80);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
    }

    public final void setDummyType(int manu, int type) {
        this.getNodeEventManager().resetNodeEvents();
        this.setNodeInFLiMMode(false);
        CbusNodeConstants.setDummyNodeParameters(this, manu, type);
        log.info("Simulated CBUS Node: {}", (Object)CbusNodeConstants.getModuleType(manu, type));
    }

    public void setPane(NdPane pane) {
        this._pane = pane;
    }

    protected void setDNN(int nn) {
        this.setNodeNumber(nn);
        this.setNodeInFLiMMode(true);
        this.setNodeInSetupMode(false);
        if (this._pane != null) {
            this._pane.setNodeNum(this.getNodeNumber());
        }
        CanReply r = new CanReply(3);
        r.setElement(0, 82);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }
}

