/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import java.util.ArrayList;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.simulator.Bundle;
import jmri.jmrix.can.cbus.simulator.CbusDummyCSSession;
import jmri.jmrix.can.cbus.simulator.CbusSimCanListener;
import jmri.jmrix.can.cbus.swing.simulator.CsPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusDummyCS
extends CbusSimCanListener {
    private ArrayList<CbusDummyCSSession> _csSessions;
    private int _simType;
    private int _maxSessions;
    private int _currentSessions;
    private boolean _trackOn;
    private boolean _estop;
    private CsPane _pane;
    public ArrayList<String> csTypes = new ArrayList();
    public ArrayList<String> csTypesTip = new ArrayList();
    protected static int DEFAULT_CS_TIMEOUT = 60000;
    protected static int DEFAULT_SESSION_START_SPDDIR = 128;
    private static final Logger log = LoggerFactory.getLogger(CbusDummyCS.class);

    public CbusDummyCS(CanSystemConnectionMemo sysmemo) {
        super(sysmemo, null);
        this.init();
    }

    private void init() {
        this._csSessions = new ArrayList();
        this._maxSessions = 32;
        this._currentSessions = 0;
        this.setDelay(100);
        this._trackOn = true;
        this._estop = false;
        this._pane = null;
        this.csTypes.add(Bundle.getMessage("cSDisabled"));
        this.csTypesTip.add(null);
        this.csTypes.add(Bundle.getMessage("csStandard"));
        this.csTypesTip.add("Based on CANCMD v3");
        this.setDummyType(1);
    }

    public int getNumberSessions() {
        return this._currentSessions;
    }

    public void resetCS() {
        int i = 0;
        while (i < this._csSessions.size()) {
            this.destroySession(this._csSessions.get(i));
            ++i;
        }
        this._csSessions = null;
        this._csSessions = new ArrayList();
        this._currentSessions = 0;
        if (this._pane != null) {
            this._pane.setNumSessions(this._currentSessions);
        }
    }

    public void setDummyType(int type) {
        this._simType = type;
        if (type == 0) {
            this.resetCS();
        }
        log.info("Simulated Command Station: {}", (Object)this.csTypes.get(this._simType));
    }

    public int getDummyType() {
        return this._simType;
    }

    public void setPane(CsPane pane) {
        this._pane = pane;
    }

    public boolean getResponseRSTAT() {
        log.debug("estop {}", (Object)this._estop);
        return false;
    }

    private int getNextSession() {
        log.debug("max sessions {}", (Object)this._maxSessions);
        ArrayList<Integer> nxtSessionList = new ArrayList<Integer>();
        int i = 0;
        while (i < this._csSessions.size()) {
            nxtSessionList.add(this._csSessions.get(i).getSessionNum());
            ++i;
        }
        i = 1;
        while (i < 257) {
            if (!nxtSessionList.contains(i)) {
                return i;
            }
            ++i;
        }
        return 1000;
    }

    private void setTrackPower(Boolean trueorfalse) {
        this._trackOn = trueorfalse;
        CanReply r = new CanReply(1);
        if (this._trackOn) {
            r.setElement(0, 5);
        } else {
            r.setElement(0, 4);
        }
        this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
    }

    protected void setEstop(Boolean estop) {
        this._estop = estop;
        if (this._estop) {
            CanReply r = new CanReply(1);
            r.setElement(0, 6);
            this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
            int i = 0;
            while (i < this._csSessions.size()) {
                this._csSessions.get(i).setSpd(1);
                ++i;
            }
        }
    }

    private int getExistingSession(int rcvdIntAddr, Boolean rcvdIsLong) {
        int i = 0;
        while (i < this._csSessions.size()) {
            if (this._csSessions.get(i).getrcvdIntAddr() == rcvdIntAddr && this._csSessions.get(i).getisLong().equals(rcvdIsLong) && !this._csSessions.get(i).getIsDispatched().booleanValue()) {
                return this._csSessions.get(i).getSessionNum();
            }
            ++i;
        }
        return -1;
    }

    private void processrloc(int rcvdIntAddr, Boolean rcvdIsLong) {
        int exSession = this.getExistingSession(rcvdIntAddr, rcvdIsLong);
        if (exSession > -1) {
            int locoaddr = rcvdIntAddr;
            if (rcvdIsLong.booleanValue()) {
                locoaddr |= 0xC000;
            }
            CanReply r = new CanReply(4);
            r.setElement(0, 99);
            r.setElement(1, locoaddr / 256);
            r.setElement(2, locoaddr & 0xFF);
            r.setElement(3, 2);
            this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
            return;
        }
        int sessionid = this.getNextSession();
        CbusDummyCSSession session = new CbusDummyCSSession(this, sessionid, rcvdIntAddr, rcvdIsLong);
        this._csSessions.add(session);
        ++this._currentSessions;
        if (this._pane != null) {
            this._pane.setNumSessions(this._currentSessions);
        }
        session.sendPloc();
    }

    private void processQloc(int session) {
        int i = 0;
        while (i < this._csSessions.size()) {
            if (this._csSessions.get(i).getSessionNum() == session && !this._csSessions.get(i).getIsDispatched().booleanValue()) {
                this._csSessions.get(i).sendPloc();
                return;
            }
            ++i;
        }
        CanReply r = new CanReply(4);
        r.setElement(0, 99);
        r.setElement(1, session);
        r.setElement(2, 0);
        r.setElement(3, 3);
        this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
    }

    private void processDspd(int session, int speeddir) {
        int i = 0;
        while (i < this._csSessions.size()) {
            if (this._csSessions.get(i).getSessionNum() == session && !this._csSessions.get(i).getIsDispatched().booleanValue()) {
                this._csSessions.get(i).setSpd(speeddir);
                if ((speeddir & 0x7F) != 1) {
                    this.setEstop(false);
                }
                return;
            }
            ++i;
        }
        CanReply r = new CanReply(4);
        r.setElement(0, 99);
        r.setElement(1, session);
        r.setElement(2, 0);
        r.setElement(3, 3);
        this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
    }

    private void processDkeep(int session) {
        int i = 0;
        while (i < this._csSessions.size()) {
            if (this._csSessions.get(i).getSessionNum() == session && !this._csSessions.get(i).getIsDispatched().booleanValue()) {
                this._csSessions.get(i).keepAlive();
                return;
            }
            ++i;
        }
        CanReply r = new CanReply(4);
        r.setElement(0, 99);
        r.setElement(1, session);
        r.setElement(2, 0);
        r.setElement(3, 3);
        this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
    }

    protected void destroySession(CbusDummyCSSession session) {
        int i = 0;
        while (i < this._csSessions.size()) {
            if (this._csSessions.get(i) == session) {
                this._csSessions.get(i).dispose();
                this._csSessions.set(i, null);
                this._csSessions.remove(i);
                --this._currentSessions;
                if (this._pane != null) {
                    this._pane.setNumSessions(this._currentSessions);
                }
                return;
            }
            ++i;
        }
        log.error("session not found to destroy");
    }

    private void processKloc(int session) {
        int i = 0;
        while (i < this._csSessions.size()) {
            if (this._csSessions.get(i).getSessionNum() == session && !this._csSessions.get(i).getIsDispatched().booleanValue()) {
                this.destroySession(this._csSessions.get(i));
                return;
            }
            ++i;
        }
        CanReply r = new CanReply(4);
        r.setElement(0, 99);
        r.setElement(1, session);
        r.setElement(2, 0);
        r.setElement(3, 3);
        this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
    }

    @Override
    protected void startProcessFrame(AbstractMessage m) {
        if (this.getDummyType() == 0) {
            return;
        }
        int opc = m.getElement(0);
        int session = m.getElement(1);
        switch (opc) {
            case 9: {
                this.setTrackPower(true);
                break;
            }
            case 8: {
                this.setTrackPower(false);
                break;
            }
            case 10: {
                this.setEstop(true);
                break;
            }
            case 64: {
                int rcvdIntAddr = (m.getElement(1) & 0x3F) * 256 + m.getElement(2);
                boolean rcvdIsLong = (m.getElement(1) & 0xC0) != 0;
                this.processrloc(rcvdIntAddr, rcvdIsLong);
                break;
            }
            case 34: {
                this.processQloc(session);
                break;
            }
            case 71: {
                this.processDspd(session, m.getElement(2));
                break;
            }
            case 35: {
                this.processDkeep(session);
                break;
            }
            case 33: {
                this.processKloc(session);
                break;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.resetCS();
    }
}

