/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.TimerTask;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeTimerManager {
    private final CbusBasicNodeWithManagers _node;
    protected int fetchNvTimeoutCount;
    private TimerTask nextNvTimerTask;
    protected int fetchEvVarTimeoutCount;
    private TimerTask nextEvTimerTask;
    protected int numEvTimeoutCount;
    private TimerTask numEvTimerTask;
    protected int allEvTimeoutCount;
    protected TimerTask allEvTimerTask;
    protected int paramRequestTimeoutCount;
    private TimerTask allParamTask;
    private TimerTask sendEditNvTask;
    private TimerTask sendEditEvTask;
    protected TimerTask sendEnumTask;
    protected int sendEvErrorCount;
    protected int _sendNVErrorCount;
    public static int SINGLE_MESSAGE_TIMEOUT_TIME = 1500;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeTimerManager.class);

    public CbusNodeTimerManager(CbusBasicNodeWithManagers node) {
        this._node = node;
        this.resetTimeOutCounts();
    }

    protected boolean hasActiveTimers() {
        return this.allParamTask != null || this.allEvTimerTask != null || this.nextEvTimerTask != null || this.nextNvTimerTask != null || this.sendEnumTask != null || this.sendEditEvTask != null || this.sendEditNvTask != null || this.numEvTimerTask != null;
    }

    protected void cancelTimers() {
        this.clearSendEnumTimeout();
        this.clearsendEditEvTimeout();
        this.clearsendEditNvTimeout();
        this.clearAllParamTimeout();
        this.clearAllEvTimeout();
        this.clearNextEvVarTimeout();
        this.clearNextNvVarTimeout();
        this.clearNumEvTimeout();
    }

    protected final void resetTimeOutCounts() {
        this.fetchNvTimeoutCount = 0;
        this.fetchEvVarTimeoutCount = 0;
        this.numEvTimeoutCount = 0;
        this.allEvTimeoutCount = 0;
        this.paramRequestTimeoutCount = 0;
        this.sendEvErrorCount = 0;
    }

    protected void clearNextNvVarTimeout() {
        if (this.nextNvTimerTask != null) {
            this.nextNvTimerTask.cancel();
            this.nextNvTimerTask = null;
            this.fetchNvTimeoutCount = 0;
        }
    }

    protected void setNextNvVarTimeout() {
        this.nextNvTimerTask = new TimerTask(){

            @Override
            public void run() {
                CbusNodeTimerManager.this.nextNvTimerTask = null;
                ++CbusNodeTimerManager.this.fetchNvTimeoutCount;
                if (CbusNodeTimerManager.this.fetchNvTimeoutCount == 1) {
                    log.info("NV Fetch from node {} timed out", (Object)CbusNodeTimerManager.this._node.getNodeNumber());
                } else if (CbusNodeTimerManager.this.fetchNvTimeoutCount == 10) {
                    log.error("Aborting NV Fetch from node {}", (Object)CbusNodeTimerManager.this._node.getNodeNumber());
                    CbusNodeTimerManager.this._node.getNodeNvManager().reset();
                    CbusNodeTimerManager.this._node.getNodeParamManager().setParameter(5, -1);
                }
                CbusNodeTimerManager.this._node.getTableModel().triggerUrgentFetch();
            }
        };
        TimerUtil.schedule(this.nextNvTimerTask, SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    protected void clearNextEvVarTimeout() {
        if (this.nextEvTimerTask != null) {
            this.nextEvTimerTask.cancel();
            this.nextEvTimerTask = null;
            this.fetchEvVarTimeoutCount = 0;
        }
    }

    protected void setNextEvVarTimeout(final int eventVarIndex, final String eventString) {
        this.nextEvTimerTask = new TimerTask(){

            @Override
            public void run() {
                CbusNodeTimerManager.this.nextEvTimerTask = null;
                ++CbusNodeTimerManager.this.fetchEvVarTimeoutCount;
                if (CbusNodeTimerManager.this.fetchEvVarTimeoutCount == 1) {
                    log.info("Event Var fetch Timeout from Node {} event {}index {}", new Object[]{CbusNodeTimerManager.this._node.getNodeStats().getNodeNumberName(), eventString, eventVarIndex});
                }
                if (CbusNodeTimerManager.this.fetchEvVarTimeoutCount == 10) {
                    log.error("Aborting Event Variable fetch from Node {} Event {}Index {}", new Object[]{CbusNodeTimerManager.this._node.getNodeStats().getNodeNumberName(), eventString, eventVarIndex});
                    CbusNodeTimerManager.this._node.getNodeEventManager().resetNodeEvents();
                    CbusNodeTimerManager.this.fetchEvVarTimeoutCount = 0;
                }
                CbusNodeTimerManager.this._node.getTableModel().triggerUrgentFetch();
            }
        };
        TimerUtil.schedule(this.nextEvTimerTask, SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    protected void clearNumEvTimeout() {
        if (this.numEvTimerTask != null) {
            this.numEvTimerTask.cancel();
            this.numEvTimerTask = null;
        }
        this.numEvTimeoutCount = 0;
    }

    protected void setNumEvTimeout() {
        this.numEvTimerTask = new TimerTask(){

            @Override
            public void run() {
                CbusNodeTimerManager.this.numEvTimerTask = null;
                if (CbusNodeTimerManager.this._node.getNodeEventManager().getTotalNodeEvents() < 0) {
                    ++CbusNodeTimerManager.this.numEvTimeoutCount;
                    if (CbusNodeTimerManager.this.numEvTimeoutCount == 1) {
                        log.info("No reponse to RQEVN ( Get Total Events ) from node {}", (Object)CbusNodeTimerManager.this._node);
                    }
                    if (CbusNodeTimerManager.this.numEvTimeoutCount == 10) {
                        log.info("Aborting requests for Total Events from node {}", (Object)CbusNodeTimerManager.this._node);
                        CbusNodeTimerManager.this._node.getNodeEventManager().resetNodeEvents();
                        CbusNodeTimerManager.this.numEvTimeoutCount = 0;
                    }
                }
            }
        };
        TimerUtil.schedule(this.numEvTimerTask, 5000L);
    }

    protected void clearAllEvTimeout() {
        if (this.allEvTimerTask != null) {
            this.allEvTimerTask.cancel();
            this.allEvTimerTask = null;
        }
    }

    protected void setAllEvTimeout() {
        this.allEvTimerTask = new TimerTask(){

            @Override
            public void run() {
                CbusNodeTimerManager.this.clearAllEvTimeout();
                if (CbusNodeTimerManager.this._node.getNodeEventManager().getOutstandingIndexNodeEvents() > 0) {
                    ++CbusNodeTimerManager.this.allEvTimeoutCount;
                    if (CbusNodeTimerManager.this.allEvTimeoutCount < 10) {
                        log.warn("Re-attempting whole event / node / index fetch from node {}", (Object)CbusNodeTimerManager.this._node);
                        CbusNodeTimerManager.this.setAllEvTimeout();
                        ((CbusNodeTimerManager)CbusNodeTimerManager.this)._node.send.nERD(CbusNodeTimerManager.this._node.getNodeNumber());
                    } else {
                        log.warn("Aborting whole event / node / index fetch from node {}", (Object)CbusNodeTimerManager.this._node);
                        CbusNodeTimerManager.this._node.getNodeEventManager().resetNodeEvents();
                    }
                }
            }
        };
        TimerUtil.schedule(this.allEvTimerTask, 5000L);
    }

    protected void clearAllParamTimeout() {
        if (this.allParamTask != null) {
            this.allParamTask.cancel();
            this.allParamTask = null;
        }
    }

    protected void setAllParamTimeout(final int index) {
        this.clearAllParamTimeout();
        this.allParamTask = new TimerTask(){

            @Override
            public void run() {
                CbusNodeTimerManager.this.allParamTask = null;
                if (CbusNodeTimerManager.this.paramRequestTimeoutCount == 0) {
                    log.warn("No response to parameter {} request from node {}", (Object)index, (Object)CbusNodeTimerManager.this._node);
                }
                ++CbusNodeTimerManager.this.paramRequestTimeoutCount;
                if (CbusNodeTimerManager.this.paramRequestTimeoutCount == 10) {
                    log.warn("Aborting requests to parameter {} for node {}", (Object)index, (Object)CbusNodeTimerManager.this._node);
                    if (CbusNodeTimerManager.this._node instanceof CbusNode) {
                        ((CbusNode)CbusNodeTimerManager.this._node).nodeOnNetwork(false);
                    }
                }
            }
        };
        TimerUtil.schedule(this.allParamTask, SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    protected void clearsendEditNvTimeout() {
        if (this.sendEditNvTask != null) {
            this.sendEditNvTask.cancel();
            this.sendEditNvTask = null;
        }
    }

    protected void setsendEditNvTimeout() {
        if (!(this._node instanceof CbusNode)) {
            return;
        }
        this.sendEditNvTask = new TimerTask(){

            @Override
            public void run() {
                CbusNodeTimerManager.this.sendEditNvTask = null;
                if (((CbusNode)CbusNodeTimerManager.this._node).getsendsWRACKonNVSET()) {
                    log.warn("teach nv timeout");
                    ++CbusNodeTimerManager.this._sendNVErrorCount;
                }
                CbusNodeTimerManager.this._node.getNodeNvManager().sendNextNvToNode();
            }
        };
        TimerUtil.schedule(this.sendEditNvTask, SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    protected void clearsendEditEvTimeout() {
        if (this.sendEditEvTask != null) {
            this.sendEditEvTask.cancel();
            this.sendEditEvTask = null;
        }
    }

    protected void setsendEditEvTimeout() {
        this.sendEditEvTask = new TimerTask(){

            @Override
            public void run() {
                log.info("Late / no response from node while teaching event");
                CbusNodeTimerManager.this.sendEditEvTask = null;
                ++CbusNodeTimerManager.this.sendEvErrorCount;
                ((CbusNodeTimerManager)CbusNodeTimerManager.this)._node.getNodeEventManager().nextEvInArray = 999;
                CbusNodeTimerManager.this._node.getNodeEventManager().teachNewEvLoop();
            }
        };
        TimerUtil.schedule(this.sendEditEvTask, SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    protected void clearSendEnumTimeout() {
        if (this.sendEnumTask != null) {
            this.sendEnumTask.cancel();
            this.sendEnumTask = null;
        }
    }

    protected void setsendEnumTimeout() {
        this.sendEnumTask = new TimerTask(){

            @Override
            public void run() {
                log.warn("Late response from node while request CAN ID Self Enumeration");
                CbusNodeTimerManager.this.sendEnumTask = null;
            }
        };
        TimerUtil.schedule(this.sendEnumTask, SINGLE_MESSAGE_TIMEOUT_TIME);
    }
}

