/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusSend;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusAllocateNodeNumber;
import jmri.jmrix.can.cbus.node.CbusBasicNodeTableFetch;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeBackupFile;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.FileUtil;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import jmri.util.XmlFilenameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeTableDataModel
extends CbusBasicNodeTableFetch
implements CanListener,
PropertyChangeListener {
    private final CbusSend send;
    private ArrayList<Integer> _nodesFound;
    private CbusAllocateNodeNumber allocate;
    protected CbusPreferences preferences;
    private int csFound = 0;
    private int ndFound = 0;
    private NodeConfigToolPane searchFeedbackPanel;
    private TimerTask searchForNodesTask;
    private boolean searchXmlComplete = false;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeTableDataModel.class);

    public CbusNodeTableDataModel(@Nonnull CanSystemConnectionMemo memo, int row, int column) {
        super(memo, row, column);
        log.debug("Starting MERG CBUS Node Table");
        this._mainArray = new ArrayList();
        this._nodesFound = new ArrayList();
        this.addTc(memo);
        this.send = new CbusSend(memo);
    }

    public void startup() {
        this.preferences = InstanceManager.getDefault(CbusPreferences.class);
        this.setBackgroundAllocateListener(this.preferences.getAllocateNNListener());
        if (this.preferences.getStartupSearchForCs()) {
            this.send.searchForCommandStations();
        }
        if (this.preferences.getStartupSearchForNodes()) {
            this.send.searchForNodes();
            this.setSearchForNodesTimeout(5000);
        } else if (this.preferences.getSearchForNodesBackupXmlOnStartup()) {
            this.startupSearchNodeXmlFile();
        }
    }

    public void setBackgroundAllocateListener(boolean newState) {
        if (newState && !GraphicsEnvironment.isHeadless()) {
            if (this.allocate == null) {
                this.allocate = new CbusAllocateNodeNumber(this._memo, this);
            }
        } else {
            if (this.allocate != null) {
                this.allocate.dispose();
            }
            this.allocate = null;
        }
    }

    @Override
    public void message(CanMessage m) {
    }

    @Override
    public void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int nodenum = m.getElement(1) * 256 + m.getElement(2);
        switch (CbusMessage.getOpcode(m)) {
            case 227: {
                if (this.preferences.getAddCommandStations()) {
                    int csnum = m.getElement(3);
                    CbusNode cs = this.provideCsByNum(csnum, nodenum);
                    cs.setFW(m.getElement(5), m.getElement(6), m.getElement(7));
                    cs.setCsFlags(m.getElement(4));
                    cs.setCanId(CbusMessage.getId(m));
                }
                this._nodesFound.add(nodenum);
                ++this.csFound;
                break;
            }
            case 182: {
                log.debug("Node Report message {}", (Object)m);
                if (this.searchForNodesTask != null && this.preferences.getAddNodes()) {
                    CbusNode nd = this.provideNodeByNodeNum(nodenum);
                    nd.setManuModule(m.getElement(3), m.getElement(4));
                    nd.setNodeFlags(m.getElement(5));
                    nd.setCanId(CbusMessage.getId(m));
                }
                this._nodesFound.add(nodenum);
                ++this.ndFound;
                break;
            }
            case 81: {
                if (this.getNodeRowFromNodeNum(nodenum) <= -1) break;
                log.info(Bundle.getMessage("NdRelease", this.getNodeName(nodenum), nodenum));
                this.removeRow(this.getNodeRowFromNodeNum(nodenum), false);
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (!(ev.getSource() instanceof CbusNode)) {
            return;
        }
        int evRow = this.getNodeRowFromNodeNum(((CbusNode)ev.getSource()).getNodeNumber());
        if (evRow < 0) {
            return;
        }
        ThreadingUtil.runOnGUIEventually(() -> {
            switch (ev.getPropertyName()) {
                case "ALLNVUPDATE": 
                case "SINGLENVUPDATE": {
                    this.fireTableCellUpdated(evRow, 7);
                    this.fireTableCellUpdated(evRow, 8);
                    break;
                }
                case "ALLEVUPDATE": 
                case "SINGLEEVUPDATE": {
                    this.fireTableCellUpdated(evRow, 10);
                    this.fireTableCellUpdated(evRow, 6);
                    this.fireTableCellUpdated(evRow, 7);
                    this.fireTableCellUpdated(evRow, 8);
                    break;
                }
                case "BACKUPS": {
                    this.fireTableCellUpdated(evRow, 11);
                    this.fireTableCellUpdated(evRow, 12);
                    this.fireTableCellUpdated(evRow, 13);
                    break;
                }
                case "PARAMETER": {
                    this.fireTableRowsUpdated(evRow, evRow);
                    break;
                }
                case "LEARNMODE": {
                    this.fireTableCellUpdated(evRow, 9);
                    break;
                }
                case "NAMECHANGE": {
                    this.fireTableCellUpdated(evRow, 2);
                    break;
                }
                case "CANID": {
                    this.fireTableCellUpdated(evRow, 5);
                    break;
                }
            }
        });
    }

    public void startASearchForNodes(NodeConfigToolPane panel, int timeout) {
        this.searchFeedbackPanel = panel;
        this.csFound = 0;
        this.ndFound = 0;
        this.setSearchForNodesTimeout(timeout);
        this.send.searchForCommandStations();
        this.send.searchForNodes();
    }

    private void checkOnlineNodesVsTable() {
        log.debug("{} Nodes found, {}", (Object)this._nodesFound.size(), this._nodesFound);
        int i = 0;
        while (i < this.getRowCount()) {
            if (!this._nodesFound.contains(((CbusNode)this._mainArray.get(i)).getNodeNumber())) {
                log.debug("No network response from Node {}", this._mainArray.get(i));
                ((CbusNode)this._mainArray.get(i)).nodeOnNetwork(false);
            }
            ++i;
        }
        this._nodesFound.stream().map(foundNodeNum -> this.getNodeByNodeNum((int)foundNodeNum)).filter(foundNode -> foundNode != null && foundNode.getNodeBackupManager().getSessionBackupStatus() == CbusNodeConstants.BackupType.NOTONNETWORK).map(foundNode -> {
            foundNode.resetNodeAll();
            return foundNode;
        }).forEachOrdered(_item -> this.startBackgroundFetch());
    }

    private void clearSearchForNodesTimeout() {
        if (this.searchForNodesTask != null) {
            this.searchForNodesTask.cancel();
            this.searchForNodesTask = null;
        }
    }

    private void setSearchForNodesTimeout(int timeout) {
        this._nodesFound = new ArrayList();
        this.searchForNodesTask = new TimerTask(){

            @Override
            public void run() {
                if (CbusNodeTableDataModel.this.searchFeedbackPanel != null) {
                    CbusNodeTableDataModel.this.searchFeedbackPanel.notifyNodeSearchComplete(CbusNodeTableDataModel.this.csFound, CbusNodeTableDataModel.this.ndFound);
                }
                if (CbusNodeTableDataModel.this.preferences.getSearchForNodesBackupXmlOnStartup()) {
                    CbusNodeTableDataModel.this.startupSearchNodeXmlFile();
                }
                CbusNodeTableDataModel.this.checkOnlineNodesVsTable();
                CbusNodeTableDataModel.this.clearSearchForNodesTimeout();
            }
        };
        TimerUtil.schedule(this.searchForNodesTask, timeout);
    }

    public void startupSearchNodeXmlFile() {
        String[] fpList;
        FileUtil.createDirectory(CbusNodeBackupFile.getFileLocation());
        ArrayList<String> names = new ArrayList<String>();
        File fp = new File(CbusNodeBackupFile.getFileLocation());
        if (fp.exists() && (fpList = fp.list(new XmlFilenameFilter())) != null) {
            names.addAll(Arrays.asList(fpList));
        }
        names.forEach(nb -> {
            log.debug("Node: {}", nb);
            int nodeNum = StringUtil.getFirstIntFromString(nb);
            CbusNode nd = this.provideNodeByNodeNum(nodeNum);
            nd.getNodeBackupManager().doLoad();
            log.debug("CbusNode {} added to table", (Object)nd);
        });
        this.searchXmlComplete = true;
    }

    public boolean startupComplete() {
        return this.searchXmlComplete || this.searchForNodesTask == null;
    }

    public void dispose() {
        this.clearSearchForNodesTimeout();
        if (this.trickleFetch != null) {
            this.trickleFetch.dispose();
            this.trickleFetch = null;
        }
        this.setBackgroundAllocateListener(false);
        this.removeTc(this._memo);
        int i = 0;
        while (i < this.getRowCount()) {
            ((CbusNode)this._mainArray.get(i)).removePropertyChangeListener(this);
            ((CbusNode)this._mainArray.get(i)).dispose();
            ++i;
        }
    }
}

