/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeStats {
    private final CbusBasicNodeWithManagers _node;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeStats.class);

    public CbusNodeStats(CbusBasicNodeWithManagers node) {
        this._node = node;
    }

    @Nonnull
    public String getNodeTypeName() {
        if (!CbusNodeConstants.getModuleType(this._node.getNodeParamManager().getParameter(1), this._node.getNodeParamManager().getParameter(3)).isEmpty()) {
            return CbusNodeConstants.getModuleType(this._node.getNodeParamManager().getParameter(1), this._node.getNodeParamManager().getParameter(3));
        }
        if (this._node instanceof CbusNode) {
            return ((CbusNode)this._node).getNodeNameFromName();
        }
        return "";
    }

    @Nonnull
    public String getNodeNumberName() {
        if (!this._node.getUserName().isEmpty()) {
            return this._node.getNodeNumber() + " " + this._node.getUserName();
        }
        if (!this.getNodeTypeName().isEmpty()) {
            return this._node.getNodeNumber() + " " + this.getNodeTypeName();
        }
        return String.valueOf(this._node.getNodeNumber());
    }

    public int totalNodeFileBytes() {
        return Math.max(0, this._node.getNodeParamManager().getParameter(0)) + Math.max(0, this._node.getNodeNvManager().getNV(0)) + Math.max(0, this._node.getNodeParamManager().getParameter(5) * this._node.getNodeEventManager().getTotalNodeEvents());
    }

    public int totalNodeBytes() {
        if (this._node.getNodeParamManager().getParameter(0) < 0 || this._node.getNodeParamManager().getParameter(6) < 0 || this._node.getNodeParamManager().getParameter(5) < 0 || this._node.getNodeEventManager().getTotalNodeEvents() < 0) {
            return -1;
        }
        return this._node.getNodeParamManager().getParameter(0) + this._node.getNodeParamManager().getParameter(6) + this._node.getNodeParamManager().getParameter(5) * this._node.getNodeEventManager().getTotalNodeEvents() + this._node.getNodeEventManager().getTotalNodeEvents();
    }

    public int totalRemainingNodeBytes() {
        if (this._node.getNodeParamManager().getOutstandingParams() < 0 || this._node.getNodeNvManager().getOutstandingNvCount() < 0 || this._node.getNodeEventManager().getOutstandingEvVars() < 0 || this._node.getNodeEventManager().getOutstandingIndexNodeEvents() < 0) {
            return -1;
        }
        return this._node.getNodeParamManager().getOutstandingParams() + this._node.getNodeNvManager().getOutstandingNvCount() + this._node.getNodeEventManager().getOutstandingEvVars() + this._node.getNodeEventManager().getOutstandingIndexNodeEvents();
    }

    public float floatPercentageRemaining() {
        float soFar = 1.0f * (float)(this.totalNodeBytes() - this.totalRemainingNodeBytes()) / (float)this.totalNodeBytes();
        if (soFar > 0.0f && (double)soFar < 1.000001) {
            return soFar;
        }
        return 0.0f;
    }

    protected void checkNodeFinishedLoad() {
        if (!this._node.getNodeBackupManager().getBackupStarted() && this.totalRemainingNodeBytes() == 0) {
            if (!this._node.getNodeBackupManager().doStore(true, this.hasLoadErrors())) {
                log.error("Unable to save Finished Load to Node Backup File");
            }
            this._node.notifyPropertyChangeListener("BACKUPS", null, null);
        }
        if (this._node.getNodeBackupManager().getBackupStarted() && this.totalRemainingNodeBytes() > 0) {
            this._node.getNodeBackupManager().setBackupStarted(false);
        }
    }

    public boolean hasLoadErrors() {
        return this._node.getNodeTimerManager().numEvTimeoutCount + this._node.getNodeTimerManager().paramRequestTimeoutCount + this._node.getNodeTimerManager().allEvTimeoutCount > 0;
    }
}

