/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEditEventFrame;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeSingleEventTableDataModel
extends AbstractTableModel {
    public int[] newEVs;
    private final CbusNodeEvent _ndEv;
    private final CanSystemConnectionMemo _memo;
    public static final int EV_NUMBER_COLUMN = 0;
    public static final int EV_CURRENT_VAL_COLUMN = 1;
    public static final int EV_CURRENT_HEX_COLUMN = 2;
    public static final int EV_CURRENT_BIT_COLUMN = 3;
    public static final int EV_SELECT_COLUMN = 4;
    public static final int EV_SELECT_HEX_COLUMN = 5;
    public static final int EV_SELECT_BIT_COLUMN = 6;
    public static final int MAX_COLUMN = 7;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeSingleEventTableDataModel.class);

    public CbusNodeSingleEventTableDataModel(CanSystemConnectionMemo memo, int row, int column, CbusNodeEvent ndEv) {
        log.debug("Starting a Single Node Event Variable Model");
        this._memo = memo;
        this._ndEv = ndEv;
        if (this._ndEv.getEvVarArray() == null) {
            this.newEVs = new int[0];
        } else {
            this.newEVs = new int[this._ndEv.getEvVarArray().length];
            log.debug(" set node newEVs length {} ", (Object)this.newEVs.length);
            this.newEVs = Arrays.copyOf(this._ndEv.getEvVarArray(), this._ndEv.getEvVarArray().length);
            log.debug(" set ev var arr length {} data {}", (Object)this.newEVs.length, (Object)this.newEVs);
        }
        this.setTableModel();
    }

    public final void setTableModel() {
        this._ndEv.setEditTableModel(this);
    }

    @Override
    public int getRowCount() {
        return this._ndEv.getNumEvVars();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    public void configureTable(JTable eventTable) {
        eventTable.getTableHeader().setReorderingAllowed(true);
        eventTable.setAutoResizeMode(0);
        int i = 0;
        while (i < eventTable.getColumnCount()) {
            int width = CbusNodeSingleEventTableDataModel.getPreferredWidth(i);
            eventTable.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        eventTable.sizeColumnsToFit(-1);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "EV Var";
            }
            case 1: {
                return "Dec.";
            }
            case 2: {
                return "Hex.";
            }
            case 3: {
                return "Bin.";
            }
            case 4: {
                return "New Dec.";
            }
            case 5: {
                return "New Hex.";
            }
            case 6: {
                return "New Bin.";
            }
        }
        return "unknown " + col;
    }

    public static int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 1: 
            case 2: {
                return new JTextField((int)4).getPreferredSize().width;
            }
        }
        return new JTextField((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return String.class;
            }
        }
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int currEvVal = this._ndEv.getEvVar(row + 1);
        switch (col) {
            case 0: {
                return row + 1;
            }
            case 1: {
                if (this.newEVs[row] < 0 && currEvVal > -1) {
                    this.newEVs[row] = currEvVal;
                }
                return currEvVal;
            }
            case 2: {
                if (currEvVal > -1) {
                    return StringUtil.twoHexFromInt(currEvVal);
                }
                return currEvVal;
            }
            case 3: {
                if (currEvVal > -1) {
                    return String.valueOf(String.format("%8s", Integer.toBinaryString(currEvVal)).replace(' ', '0').substring(0, 4)) + " " + String.format("%8s", Integer.toBinaryString(currEvVal)).replace(' ', '0').substring(4, 8);
                }
                return currEvVal;
            }
            case 4: {
                if (this.newEVs[row] > -1) {
                    return this.newEVs[row];
                }
                return currEvVal;
            }
            case 5: {
                if (this.newEVs[row] != currEvVal) {
                    return StringUtil.twoHexFromInt(this.newEVs[row]);
                }
                return "";
            }
            case 6: {
                if (this.newEVs[row] != currEvVal) {
                    return String.valueOf(String.format("%8s", Integer.toBinaryString(this.newEVs[row])).replace(' ', '0').substring(0, 4)) + " " + String.format("%8s", Integer.toBinaryString(this.newEVs[row])).replace(' ', '0').substring(4, 8);
                }
                return "";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        log.debug("set value {} row {} col {}", new Object[]{value, row, col});
        switch (col) {
            case 4: {
                this.newEVs[row] = (Integer)value;
                this.updateFromNode(row, col);
                break;
            }
            case 5: {
                this.newEVs[row] = StringUtil.getByte(0, ((String)value).trim());
                ThreadingUtil.runOnGUIEventually(() -> this.fireTableRowsUpdated(row, row));
                break;
            }
            case 6: {
                try {
                    int newInt = Integer.parseInt(((String)value).replaceAll("\\s+", ""), 2);
                    if (newInt <= -1 || newInt >= 256) break;
                    this.newEVs[row] = newInt;
                    ThreadingUtil.runOnGUIEventually(() -> this.fireTableRowsUpdated(row, row));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
        }
    }

    public void updateFromNode(int arrayid, int col) {
        ThreadingUtil.runOnGUIEventually(() -> this.fireTableDataChanged());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTableLoaded() {
        if (this.getRowCount() < 1) {
            return false;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= this.getRowCount()) {
                    return true;
                }
                if ((Integer)this.getValueAt(i, 1) < 0) {
                    return false;
                }
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean isSingleEvDirty(int evToCheck) {
        return ((Integer)this.getValueAt(evToCheck, 1)).intValue() != ((Integer)this.getValueAt(evToCheck, 4)).intValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTableDirty() {
        try {
            int i = 0;
            while (true) {
                if (i >= this.getRowCount()) {
                    return false;
                }
                if (this.isSingleEvDirty(i)) {
                    return true;
                }
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int getCountDirty() {
        int count = 0;
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.isSingleEvDirty(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void resetnewEVs() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.setValueAt(this.getValueAt(i, 1), i, 4);
            ++i;
        }
    }

    @CheckForNull
    private CbusNode getEventNode() {
        CbusNodeTableDataModel nodeModel = InstanceManager.getDefault(CbusNodeTableDataModel.class);
        return nodeModel.getNodeByNodeNum(this._ndEv.getParentNn());
    }

    public void passNewEvToNode(CbusNodeEditEventFrame frame) {
        CbusNodeEvent newevent = new CbusNodeEvent(this._memo, frame.getNodeVal(), frame.getEventVal(), this._ndEv.getParentNn(), -1, this._ndEv.getNumEvVars());
        newevent.setEvArr(this.newEVs);
        ArrayList<CbusNodeEvent> eventArray = new ArrayList<CbusNodeEvent>(1);
        eventArray.add(newevent);
        log.debug(" pass changes arr length {} ", (Object)this.newEVs.length);
        CbusNode tmpNode = this.getEventNode();
        if (tmpNode != null) {
            tmpNode.getNodeEventManager().sendNewEvSToNode(eventArray);
        }
    }

    public void passEditEvToNode(CbusNodeEditEventFrame frame) {
        if (frame.spinnersDirty()) {
            CbusNode tmpNode = this.getEventNode();
            if (tmpNode != null) {
                tmpNode.getNodeEventManager().deleteEvOnNode(this._ndEv.getNn(), this._ndEv.getEn());
            }
            ThreadingUtil.runOnLayoutDelayed(() -> this.passNewEvToNode(frame), 200);
        } else {
            this.passNewEvToNode(frame);
        }
    }

    public void dispose() {
        this._ndEv.setEditTableModel(null);
    }
}

