/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.Arrays;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeParameterManager {
    private final CbusBasicNodeWithManagers _node;
    private int[] _parameters;
    private boolean _commandStationIdentified;
    private boolean _nodeTraitsSet;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeParameterManager.class);

    public CbusNodeParameterManager(CbusBasicNodeWithManagers node) {
        this._node = node;
        this._parameters = null;
        this._commandStationIdentified = false;
        this._nodeTraitsSet = false;
    }

    public void setParameters(int[] newparams) {
        this._parameters = new int[newparams[0] + 1];
        int i = 0;
        while (i < this._parameters.length) {
            this.setParameter(i, newparams[i]);
            ++i;
        }
        if (this.getParameter(6) > -1) {
            int[] myarray = new int[this.getParameter(6) + 1];
            Arrays.fill(myarray, -1);
            myarray[0] = this.getParameter(6);
            this._node.getNodeNvManager().setNVs(myarray);
        }
    }

    public void setParameter(int index, int newval) {
        if (this._parameters == null) {
            log.error("Parameter set before array initiaised");
            return;
        }
        log.debug("set parameter tot:{} index:{} newval:{}", new Object[]{this._parameters.length, index, newval});
        if (index <= this._parameters.length) {
            this._parameters[index] = newval;
            this._node.notifyPropertyChangeListener("PARAMETER", null, null);
        }
    }

    public int getOutstandingParams() {
        if (this._parameters == null) {
            return 8;
        }
        int count = 0;
        int i = 1;
        while (i < this._parameters.length) {
            if (this._parameters[i] == -1) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getParameter(int index) {
        if (this._parameters == null) {
            return -1;
        }
        try {
            return this._parameters[index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public int[] getParameters() {
        return this._parameters;
    }

    public String getParameterHexString() {
        if (this.getParameters() == null) {
            return "";
        }
        return StringUtil.hexStringFromInts(this.getParameters()).replaceAll("\\s", "").substring(2);
    }

    protected void clearParameters() {
        this._parameters = null;
        this._nodeTraitsSet = false;
    }

    public String getNodeTypeString() {
        StringBuilder n = new StringBuilder(100);
        n.append(CbusNodeConstants.getManu(this.getParameter(1))).append(" ").append(CbusNodeConstants.getModuleTypeExtra(this.getParameter(1), this.getParameter(3))).append(" ").append(CbusNodeConstants.getModuleType(this.getParameter(1), this.getParameter(3))).append(" ").append(Bundle.getMessage("FirmwareVer", this.getParameter(7), Character.toString((char)this.getParameter(2))));
        if (this.getParameter(0) > 19 && this.getParameter(20) > 0) {
            n.append(Bundle.getMessage("FWBeta")).append(this.getParameter(20)).append(" ");
        }
        n.append(Bundle.getMessage("CbusNode")).append(this._node.getNodeNumber());
        return n.toString();
    }

    public void requestEventTot() {
        if (this._node.getNodeTimerManager().hasActiveTimers()) {
            return;
        }
        this._node.getNodeTimerManager().setNumEvTimeout();
        this._node.send.rQEVN(this._node.getNodeNumber());
    }

    public void requestParam(int param) {
        if (this._node.getNodeTimerManager().hasActiveTimers()) {
            return;
        }
        this._node.getNodeTimerManager().setAllParamTimeout(param);
        this._node.send.rQNPN(this._node.getNodeNumber(), param);
    }

    private boolean sentParamRequest(int paramToCheck) {
        if (this.getParameter(paramToCheck) < 0) {
            this.requestParam(paramToCheck);
            return true;
        }
        return false;
    }

    protected void sendRequestNextParam() {
        if (this._parameters == null) {
            this.requestParam(0);
            return;
        }
        if (this.sentParamRequest(1) || this.sentParamRequest(3) || this.sentParamRequest(6)) {
            return;
        }
        if (this.sentParamRequest(5) || this.sentParamRequest(7) || this.sentParamRequest(2)) {
            return;
        }
        this.finishedWhenGotMainParams();
        int i = 1;
        while (i < this._parameters.length) {
            if (this.sentParamRequest(i)) {
                return;
            }
            ++i;
        }
    }

    private void finishedWhenGotMainParams() {
        if (!(this._node instanceof CbusNode)) {
            return;
        }
        if (((CbusNode)this._node).getCsNum() > -1 && !this._commandStationIdentified) {
            log.info("{}", (Object)this.getNodeTypeString());
            this._commandStationIdentified = true;
        }
        if (!this._nodeTraitsSet) {
            CbusNodeConstants.setTraits((CbusNode)this._node);
            this._nodeTraitsSet = true;
        }
        if (this._node.getNodeEventManager().getTotalNodeEvents() < 0) {
            this.requestEventTot();
        }
    }
}

