/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeFromBackup;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeNVTableDataModel
extends AbstractTableModel
implements PropertyChangeListener {
    private int[] newNVs;
    private CbusNode nodeOfInterest;
    public static final int NV_NUMBER_COLUMN = 0;
    public static final int NV_NAME_COLUMN = 1;
    public static final int NV_CURRENT_VAL_COLUMN = 2;
    public static final int NV_CURRENT_HEX_COLUMN = 3;
    public static final int NV_CURRENT_BIT_COLUMN = 4;
    public static final int NV_SELECT_COLUMN = 5;
    public static final int NV_SELECT_HEX_COLUMN = 6;
    public static final int NV_SELECT_BIT_COLUMN = 7;
    public static final int MAX_COLUMN = 8;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeNVTableDataModel.class);

    public CbusNodeNVTableDataModel(CanSystemConnectionMemo memo, int row, int column) {
        log.debug("Starting MERG CBUS Node NV Table");
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("SINGLENVUPDATE")) {
            int newValue = (Integer)ev.getNewValue();
            this.resetNewNvs();
            this.fireTableRowsUpdated(newValue, newValue);
        } else if (ev.getPropertyName().equals("ALLNVUPDATE")) {
            this.resetNewNvs();
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        try {
            return this.nodeOfInterest.getNodeNvManager().getTotalNVs();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "NV";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Dec.";
            }
            case 3: {
                return "Hex.";
            }
            case 4: {
                return "Bin.";
            }
            case 5: {
                return "New Dec.";
            }
            case 6: {
                return "New Hex.";
            }
            case 7: {
                return "New Bin.";
            }
        }
        return "unknown " + col;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return String.class;
            }
        }
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.nodeOfInterest.getNodeNvManager().getTotalNVs() < 1) {
            return null;
        }
        switch (col) {
            case 0: {
                return row + 1;
            }
            case 1: {
                return CbusConfigPaneProvider.getProviderByNode(this.nodeOfInterest).getNVNameByIndex(row + 1);
            }
            case 2: {
                return this.nodeOfInterest.getNodeNvManager().getNV(row + 1);
            }
            case 3: {
                if (this.nodeOfInterest.getNodeNvManager().getNV(row + 1) <= -1) break;
                return StringUtil.twoHexFromInt(this.nodeOfInterest.getNodeNvManager().getNV(row + 1));
            }
            case 4: {
                int num = this.nodeOfInterest.getNodeNvManager().getNV(row + 1);
                if (num <= -1) break;
                return String.valueOf(String.format("%8s", Integer.toBinaryString(num)).replace(' ', '0').substring(0, 4)) + " " + String.format("%8s", Integer.toBinaryString(num)).replace(' ', '0').substring(4, 8);
            }
            case 5: {
                if (this.newNVs.length < row + 1) {
                    return 0;
                }
                if (this.newNVs[row + 1] > -1) {
                    return this.newNVs[row + 1];
                }
                return this.nodeOfInterest.getNodeNvManager().getNV(row + 1);
            }
            case 6: {
                if (this.newNVs.length <= row + 1 || this.newNVs[row + 1] <= -1) break;
                return StringUtil.twoHexFromInt(this.newNVs[row + 1]);
            }
            case 7: {
                if (this.newNVs.length <= row + 1 || this.newNVs[row + 1] <= -1) break;
                return String.valueOf(String.format("%8s", Integer.toBinaryString(this.newNVs[row + 1])).replace(' ', '0').substring(0, 4)) + " " + String.format("%8s", Integer.toBinaryString(this.newNVs[row + 1])).replace(' ', '0').substring(4, 8);
            }
            default: {
                return null;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        log.debug("set value {} row {} col {}", new Object[]{value, row, col});
        if (this.newNVs.length == 0) {
            return;
        }
        switch (col) {
            case 5: {
                int newval;
                this.newNVs[row + 1] = newval = ((Integer)value).intValue();
                ThreadingUtil.runOnGUIEventually(() -> this.fireTableRowsUpdated(row, row));
                break;
            }
            case 6: {
                this.newNVs[row + 1] = StringUtil.getByte(0, ((String)value).trim());
                ThreadingUtil.runOnGUIEventually(() -> this.fireTableRowsUpdated(row, row));
                break;
            }
            case 7: {
                try {
                    int newInt = Integer.parseInt(((String)value).replaceAll("\\s+", ""), 2);
                    if (newInt <= -1 || newInt >= 256) break;
                    this.newNVs[row + 1] = newInt;
                    ThreadingUtil.runOnGUIEventually(() -> this.fireTableRowsUpdated(row, row));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
        }
    }

    public void setNode(CbusNode node) {
        log.debug("setting array for node {}", (Object)node);
        if (this.nodeOfInterest != null) {
            this.nodeOfInterest.removePropertyChangeListener(this);
        }
        this.nodeOfInterest = node;
        if (this.nodeOfInterest == null) {
            return;
        }
        this.resetNewNvs();
        this.nodeOfInterest.addPropertyChangeListener(this);
        ThreadingUtil.runOnGUIEventually(() -> this.fireTableDataChanged());
    }

    public CbusNode getNode() {
        return this.nodeOfInterest;
    }

    public boolean isSingleNvDirty(int nvToCheck) {
        return ((Integer)this.getValueAt(nvToCheck, 2)).intValue() != ((Integer)this.getValueAt(nvToCheck, 5)).intValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTableDirty() {
        try {
            int i = 0;
            while (true) {
                if (i >= this.getRowCount()) {
                    return false;
                }
                if (this.isSingleNvDirty(i)) {
                    return true;
                }
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int getCountDirty() {
        int count = 0;
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.isSingleNvDirty(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void resetNewNvs() {
        if (this.nodeOfInterest.getNodeNvManager().getNvArray() == null) {
            this.newNVs = new int[0];
        } else {
            this.newNVs = new int[this.nodeOfInterest.getNodeNvManager().getNvArray().length];
            this.newNVs = Arrays.copyOf(this.nodeOfInterest.getNodeNvManager().getNvArray(), this.nodeOfInterest.getNodeNvManager().getNvArray().length);
        }
        int i = 0;
        while (i < this.getRowCount()) {
            this.setValueAt(this.getValueAt(i, 2), i, 5);
            ++i;
        }
    }

    public CbusNodeFromBackup getChangedNode() {
        CbusNodeFromBackup temp = new CbusNodeFromBackup(this.nodeOfInterest, null);
        temp.getNodeNvManager().setNVs(this.newNVs);
        return temp;
    }

    public void dispose() {
        if (this.nodeOfInterest != null) {
            this.nodeOfInterest.removePropertyChangeListener(this);
        }
    }
}

