/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeCanListener;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;

public class CbusNodeFromBackup
extends CbusNode
implements Comparable<CbusNodeFromBackup> {
    private Date _timeStamp;
    private String _backupComment = "";
    private CbusNodeConstants.BackupType _backupType;

    public CbusNodeFromBackup(CanSystemConnectionMemo connmemo, int nodenumber) {
        super(connmemo, nodenumber);
    }

    public CbusNodeFromBackup(CbusNode node, Date timeStamp) {
        super(null, node.getNodeNumber());
        this.setBackupResult(CbusNodeConstants.BackupType.INCOMPLETE);
        this._timeStamp = timeStamp;
        if (node.getNodeParamManager().getParameters() != null) {
            super.getNodeParamManager().setParameters(node.getNodeParamManager().getParameters());
        } else {
            this.setBackupResult(CbusNodeConstants.BackupType.COMPLETEDWITHERROR);
        }
        if (node.getNodeNvManager().getNvArray() != null) {
            super.getNodeNvManager().setNVs(node.getNodeNvManager().getNvArray());
        } else {
            this.setBackupResult(CbusNodeConstants.BackupType.COMPLETEDWITHERROR);
        }
        ArrayList<CbusNodeEvent> _tmpArr = node.getNodeEventManager().getEventArray();
        if (_tmpArr != null) {
            _tmpArr.forEach(ndEv -> this.getNodeEventManager().addNewEvent(new CbusNodeEvent((CbusNodeEvent)ndEv)));
        } else {
            this.setBackupResult(CbusNodeConstants.BackupType.COMPLETEDWITHERROR);
        }
        if (this.getBackupResult() == CbusNodeConstants.BackupType.INCOMPLETE) {
            this.setBackupResult(CbusNodeConstants.BackupType.COMPLETE);
        }
    }

    @Override
    public CbusNodeCanListener getNewCanListener() {
        return new DoNothingCanListener();
    }

    protected void setBackupTimeStamp(Date thisDate) {
        this._timeStamp = thisDate;
    }

    public Date getBackupTimeStamp() {
        return this._timeStamp;
    }

    protected final void setBackupResult(CbusNodeConstants.BackupType type) {
        this._backupType = type;
    }

    public final CbusNodeConstants.BackupType getBackupResult() {
        return this._backupType;
    }

    public void setBackupComment(String backupComment) {
        this._backupComment = backupComment;
    }

    public String getBackupComment() {
        return this._backupComment;
    }

    public void addBupEvent(int nn, int en, String evVars) {
        CbusNodeEvent buildEv = new CbusNodeEvent(nn, en, this.getNodeNumber(), evVars);
        this.getNodeEventManager().addNewEvent(buildEv);
    }

    public String compareWithString(CbusNodeFromBackup toTest) {
        if (toTest == null) {
            return "";
        }
        if (this.equals(toTest)) {
            return Bundle.getMessage("NoChanges");
        }
        StringBuilder text = new StringBuilder();
        if (!this.getNodeParamManager().getParameterHexString().equals(toTest.getNodeParamManager().getParameterHexString())) {
            text.append("Parameters Changed ");
        }
        if (!this.getNodeNvManager().getNvHexString().equals(toTest.getNodeNvManager().getNvHexString())) {
            text.append("NV's Changed ");
        }
        if (this.getNodeEventManager().getTotalNodeEvents() != toTest.getNodeEventManager().getTotalNodeEvents()) {
            text.append("Number Events Changed ");
        } else if (this.getEventArrayHash() != toTest.getEventArrayHash()) {
            text.append("Events Changed ");
        }
        if (text.toString().isEmpty()) {
            text.append(Bundle.getMessage("NoChanges"));
        }
        return text.toString();
    }

    @Override
    public int compareTo(CbusNodeFromBackup o) {
        return this.getBackupTimeStamp().compareTo(o.getBackupTimeStamp());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CbusNodeFromBackup)) {
            return false;
        }
        CbusNodeFromBackup t = (CbusNodeFromBackup)obj;
        if (this.getNodeNumber() != t.getNodeNumber()) {
            return false;
        }
        if (!this.getNodeParamManager().getParameterHexString().equals(t.getNodeParamManager().getParameterHexString())) {
            return false;
        }
        if (!this.getNodeNvManager().getNvHexString().equals(t.getNodeNvManager().getNvHexString())) {
            return false;
        }
        if (this.getNodeEventManager().getTotalNodeEvents() != t.getNodeEventManager().getTotalNodeEvents()) {
            return false;
        }
        ArrayList<CbusNodeEvent> thisEvs = this.getNodeEventManager().getEventArray();
        ArrayList<CbusNodeEvent> otherEvs = t.getNodeEventManager().getEventArray();
        if (thisEvs != null && otherEvs != null) {
            Collections.sort(thisEvs);
            Collections.sort(otherEvs);
        }
        return this.getEventArrayHash() == t.getEventArrayHash();
    }

    public int hashCode() {
        return Objects.hash(this.getNodeNumber(), this.getNodeParamManager().getParameterHexString(), this.getNodeNvManager().getNvHexString(), this.getEventArrayHash());
    }

    public int getEventArrayHash() {
        ArrayList<CbusNodeEvent> _tmpArr = this.getNodeEventManager().getEventArray();
        if (_tmpArr == null) {
            return 0;
        }
        return _tmpArr.hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Backup " + this.getBackupTimeStamp();
    }

    protected static class DoNothingCanListener
    extends CbusNodeCanListener {
        public DoNothingCanListener() {
            super(null, null);
        }

        @Override
        public void message(CanMessage m) {
        }

        @Override
        public void reply(CanReply m) {
        }
    }
}

