/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeEventTableDataModel
extends AbstractTableModel
implements PropertyChangeListener {
    private final CbusNameService nameService;
    private CbusNode nodeOfInterest;
    private final NodeConfigToolPane _mainpane;
    public static final int NODE_NUMBER_COLUMN = 0;
    public static final int EVENT_NUMBER_COLUMN = 1;
    public static final int NODE_EDIT_BUTTON_COLUMN = 2;
    public static final int NODE_NAME_COLUMN = 3;
    public static final int EVENT_NAME_COLUMN = 4;
    public static final int EV_VARS_COLUMN = 5;
    public static final int EV_INDEX_COLUMN = 6;
    public static final int MAX_COLUMN = 7;
    private final CanSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeEventTableDataModel.class);

    public CbusNodeEventTableDataModel(NodeConfigToolPane mainpane, CanSystemConnectionMemo memo, int row, int column) {
        log.debug("Starting MERG CBUS Node Event Table");
        this._mainpane = mainpane;
        this._memo = memo;
        this.nameService = new CbusNameService(memo);
    }

    @Override
    public int getRowCount() {
        try {
            return Math.max(0, this.nodeOfInterest.getNodeEventManager().getTotalNodeEvents());
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return "Event Number";
            }
            case 0: {
                return "Node Number";
            }
            case 2: {
                return "Edit";
            }
            case 3: {
                return "Node Name";
            }
            case 4: {
                return "Event Name";
            }
            case 5: {
                return "Event Variables";
            }
            case 6: {
                return "Index";
            }
        }
        return "unknown " + col;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 6: {
                return Integer.class;
            }
            case 3: 
            case 4: 
            case 5: {
                return String.class;
            }
            case 2: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.nodeOfInterest == null) {
            return null;
        }
        CbusNodeEvent toFetch = this.nodeOfInterest.getNodeEventManager().getNodeEventByArrayID(row);
        if (toFetch == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return toFetch.getNn();
            }
            case 1: {
                return toFetch.getEn();
            }
            case 2: {
                return "Edit";
            }
            case 3: {
                if (!toFetch.getTempFcuNodeName().isEmpty()) {
                    return toFetch.getTempFcuNodeName();
                }
                return this.nameService.getNodeName(toFetch.getNn());
            }
            case 4: {
                if (!toFetch.getName().isEmpty()) {
                    return toFetch.getName();
                }
                return this.nameService.getEventName(toFetch.getNn(), toFetch.getEn());
            }
            case 5: {
                return toFetch.getEvVarString();
            }
            case 6: {
                return toFetch.getIndex();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2 && this._mainpane != null) {
            CbusNodeEvent ndEv = this.nodeOfInterest.getNodeEventManager().getNodeEventByArrayID(row);
            ThreadingUtil.runOnGUIDelayed(() -> this._mainpane.getEditEvFrame().initComponents(this._memo, ndEv), 10);
        }
    }

    public void setNode(CbusNode node) {
        if (node == this.nodeOfInterest) {
            return;
        }
        if (this.nodeOfInterest != null) {
            this.nodeOfInterest.removePropertyChangeListener(this);
        }
        this.nodeOfInterest = node;
        if (this.nodeOfInterest != null) {
            this.nodeOfInterest.addPropertyChangeListener(this);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("SINGLEEVUPDATE")) {
            int newValue = (Integer)ev.getNewValue();
            this.fireTableRowsUpdated(newValue, newValue);
        } else if (ev.getPropertyName().equals("ALLEVUPDATE")) {
            this.fireTableDataChanged();
        }
    }

    public void dispose() {
        this.setNode(null);
    }

    void removeRow(int row) {
        ThreadingUtil.runOnGUI(() -> this.fireTableRowsDeleted(row, row));
    }
}

