/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeEventManager {
    private final CbusBasicNodeWithManagers _node;
    private final CanSystemConnectionMemo _memo;
    protected int nextEvInArray;
    private ArrayList<CbusNodeEvent> _nodeEvents;
    private boolean _eventIndexValid;
    private ArrayList<CbusNodeEvent> eventsToTeachArray;
    private int nextEvVar;
    protected boolean TEACH_OUTSTANDING_EVS;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeEventManager.class);

    public CbusNodeEventManager(CanSystemConnectionMemo memo, CbusBasicNodeWithManagers node) {
        this._node = node;
        this._memo = memo;
        this._nodeEvents = null;
        this._eventIndexValid = false;
        this.TEACH_OUTSTANDING_EVS = false;
    }

    public int getTotalNodeEvents() {
        if (this._nodeEvents == null) {
            return -1;
        }
        return this._nodeEvents.size();
    }

    public int getLoadedNodeEvents() {
        if (this._nodeEvents == null) {
            return -1;
        }
        int count = 0;
        int i = 0;
        while (i < this._nodeEvents.size()) {
            if (this._nodeEvents.get(i).getNn() != -1 && this._nodeEvents.get(i).getEn() != -1) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getOutstandingIndexNodeEvents() {
        return this.getTotalNodeEvents() - this.getLoadedNodeEvents();
    }

    public void addNewEvent(@Nonnull CbusNodeEvent newEvent) {
        if (this._nodeEvents == null) {
            this._nodeEvents = new ArrayList();
        }
        this._nodeEvents.add(newEvent);
        this.setEvIndexValid(false);
    }

    public void removeEvent(int nn, int en) {
        this._nodeEvents.remove(this.getNodeEvent(nn, en));
        this.setEvIndexValid(false);
    }

    @CheckForNull
    public CbusNodeEvent getNodeEvent(int nn, int en) {
        if (this._nodeEvents == null) {
            return null;
        }
        int i = 0;
        while (i < this._nodeEvents.size()) {
            if (this._nodeEvents.get(i).getNn() == nn && this._nodeEvents.get(i).getEn() == en) {
                return this._nodeEvents.get(i);
            }
            ++i;
        }
        return null;
    }

    @Nonnull
    public CbusNodeEvent provideNodeEvent(int nn, int en) {
        CbusNodeEvent newev;
        if (this._nodeEvents == null) {
            this._nodeEvents = new ArrayList();
        }
        if ((newev = this.getNodeEvent(nn, en)) == null) {
            newev = new CbusNodeEvent(this._memo, nn, en, this._node.getNodeNumber(), -1, this._node.getNodeParamManager().getParameter(5));
            this.addNewEvent(newev);
        }
        this.setEvIndexValid(false);
        return newev;
    }

    protected void updateNodeFromLearn(int nn, int en, int evvarindex, int evvarval) {
        CbusNodeEvent nodeEv = this.provideNodeEvent(nn, en);
        nodeEv.setEvVar(evvarindex, evvarval);
        this._node.notifyPropertyChangeListener("ALLEVUPDATE", null, null);
    }

    @CheckForNull
    public CbusNodeEvent getNodeEventByIndex(int index) {
        if (this._nodeEvents == null) {
            return null;
        }
        int i = 0;
        while (i < this._nodeEvents.size()) {
            if (this._nodeEvents.get(i).getIndex() == index) {
                return this._nodeEvents.get(i);
            }
            ++i;
        }
        return null;
    }

    protected int getEventRowFromIndex(int index) {
        int i = 0;
        while (i < this._nodeEvents.size()) {
            if (this._nodeEvents.get(i).getIndex() == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @CheckForNull
    public CbusNodeEvent getNodeEventByArrayID(int index) {
        return this._nodeEvents.get(index);
    }

    @CheckForNull
    public ArrayList<CbusNodeEvent> getEventArray() {
        return this._nodeEvents;
    }

    public int getOutstandingEvVars() {
        int count = 0;
        ArrayList<CbusNodeEvent> _evs = this.getEventArray();
        if (_evs == null) {
            return -1;
        }
        int i = 0;
        while (i < _evs.size()) {
            count += _evs.get(i).getOutstandingVars();
            ++i;
        }
        return count;
    }

    protected void remainingEvVarsNotNeeded() {
        ArrayList<CbusNodeEvent> _evs = this.getEventArray();
        if (_evs != null) {
            int i = 0;
            while (i < _evs.size()) {
                if (_evs.get(i).getNextOutstanding() > 0) {
                    _evs.get(i).allOutstandingEvVarsNotNeeded();
                    this._node.getNodeTimerManager().clearNextEvVarTimeout();
                    this._node.notifyPropertyChangeListener("SINGLEEVUPDATE", null, i);
                    return;
                }
                ++i;
            }
        }
    }

    protected void sendNextEvVarToFetch() {
        ArrayList<CbusNodeEvent> _evs = this.getEventArray();
        if (this._node.getTableModel().getAnyNodeInLearnMode() > -1 || _evs == null || this._node.getNodeTimerManager().hasActiveTimers()) {
            return;
        }
        if (this.getTotalNodeEvents() > 0 && this.getOutstandingIndexNodeEvents() > 0) {
            this._node.send.nERD(this._node.getNodeNumber());
            this._node.getNodeTimerManager().setAllEvTimeout();
            return;
        }
        int i = 0;
        while (i < _evs.size()) {
            if (_evs.get(i).getOutstandingVars() > 0) {
                int index = _evs.get(i).getIndex();
                int nextevvar = _evs.get(i).getNextOutstanding();
                if (index > -1) {
                    this._node.getNodeTimerManager().setNextEvVarTimeout(nextevvar, _evs.get(i).toString());
                    this._node.send.rEVAL(this._node.getNodeNumber(), index, nextevvar);
                    return;
                }
                log.info("Invalid index, resetting events for node {}", (Object)this._node);
                this._nodeEvents = null;
                return;
            }
            ++i;
        }
    }

    protected void setEvVarByIndex(int eventIndex, int eventVarIndex, int newVal) {
        CbusNodeEvent nodeEvByIndex = this.getNodeEventByIndex(eventIndex);
        if (nodeEvByIndex != null) {
            nodeEvByIndex.setEvVar(eventVarIndex, newVal);
            this._node.notifyPropertyChangeListener("SINGLEEVUPDATE", null, this.getEventRowFromIndex(eventIndex));
        }
    }

    protected void setNextEmptyNodeEvent(int nn, int en, int index) {
        ArrayList<CbusNodeEvent> _evs = this.getEventArray();
        if (_evs == null) {
            log.error("Indexed events are not expected as total number of events unknown");
            return;
        }
        int i = 0;
        while (i < _evs.size()) {
            if (_evs.get(i).getIndex() == index) {
                _evs.get(i).setNn(nn);
                _evs.get(i).setEn(en);
                this._node.notifyPropertyChangeListener("SINGLEEVUPDATE", null, i);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this._nodeEvents.size()) {
            if (this._nodeEvents.get(i).getNn() == -1 && this._nodeEvents.get(i).getEn() == -1) {
                this._nodeEvents.get(i).setNn(nn);
                this._nodeEvents.get(i).setEn(en);
                this._nodeEvents.get(i).setIndex(index);
                this._node.notifyPropertyChangeListener("SINGLEEVUPDATE", null, i);
                return;
            }
            ++i;
        }
        log.error("Issue setting node event, index {} not valid", (Object)index);
        this._nodeEvents = null;
    }

    protected boolean isEventIndexValid() {
        return this._eventIndexValid;
    }

    protected void setEvIndexValid(boolean newval) {
        this._eventIndexValid = newval;
        if (!newval) {
            int i = 0;
            while (i < this._nodeEvents.size()) {
                this._nodeEvents.get(i).setIndex(-1);
                ++i;
            }
        }
        this._node.notifyPropertyChangeListener("ALLEVUPDATE", null, null);
    }

    public void sendNewEvSToNode(@Nonnull ArrayList<CbusNodeEvent> evArray) {
        this.eventsToTeachArray = evArray;
        if (this.eventsToTeachArray == null) {
            this._node.getNodeTimerManager().sendEvErrorCount = 1;
            this.teachEventsComplete();
            return;
        }
        if (this.eventsToTeachArray.isEmpty()) {
            this.teachEventsComplete();
            return;
        }
        if (this._node.getTableModel().getAnyNodeInLearnMode() > -1) {
            String err = "Cancelling teach event.  Node " + this._node.getTableModel().getAnyNodeInLearnMode() + " is already in Learn Mode";
            log.warn(err);
            this._node.notifyPropertyChangeListener("ADDEVCOMPLETE", null, err);
            return;
        }
        this.TEACH_OUTSTANDING_EVS = true;
        this.nextEvInArray = 0;
        this.nextEvVar = 1;
        this._node.getNodeTimerManager().sendEvErrorCount = 0;
        this._node.send.nodeEnterLearnEvMode(this._node.getNodeNumber());
        log.debug("sendNewEvSToNode {}", evArray);
        ThreadingUtil.runOnLayoutDelayed(() -> this.teachNewEvLoop(), 50);
    }

    public void deleteEvOnNode(int nn, int en) {
        if (this._node.getTableModel().getAnyNodeInLearnMode() > -1) {
            String err = "Cancelling delete event.  Node " + this._node.getTableModel().getAnyNodeInLearnMode() + " is already in Learn Mode";
            log.warn(err);
            this._node.notifyPropertyChangeListener("DELETEEVCOMPLETE", null, err);
            return;
        }
        this._node.send.nodeEnterLearnEvMode(this._node.getNodeNumber());
        ThreadingUtil.runOnLayoutDelayed(() -> {
            this._node.send.nodeUnlearnEvent(nn, en);
            this.setEvIndexValid(false);
        }, 50);
        ThreadingUtil.runOnGUIDelayed(() -> {
            this._node.send.nodeExitLearnEvMode(this._node.getNodeNumber());
            this._node.notifyPropertyChangeListener("DELETEEVCOMPLETE", null, null);
        }, 100);
    }

    private void teachEventsComplete() {
        String err;
        this.TEACH_OUTSTANDING_EVS = false;
        this._node.send.nodeExitLearnEvMode(this._node.getNodeNumber());
        if (this._node.getNodeTimerManager().sendEvErrorCount == 0) {
            log.info("Completed Event Write with No errors, node {}.", (Object)this._node);
            err = "";
        } else {
            err = "Event Write Failed with " + this._node.getNodeTimerManager().sendEvErrorCount + " errors.";
            log.error("{} Node {}.", (Object)err, (Object)this._node);
        }
        ThreadingUtil.runOnGUIDelayed(() -> {
            this._node.notifyPropertyChangeListener("ADDEVCOMPLETE", null, err);
            this._node.notifyPropertyChangeListener("ADDALLEVCOMPLETE", null, this._node.getNodeTimerManager().sendEvErrorCount);
            this._node.getNodeTimerManager().sendEvErrorCount = 0;
        }, 50);
    }

    protected void teachNewEvLoop() {
        if (this.nextEvVar > this._node.getNodeParamManager().getParameter(5)) {
            this.nextEvVar = 1;
            ++this.nextEvInArray;
        }
        if (this.nextEvInArray >= this.eventsToTeachArray.size()) {
            log.debug("all done");
            this.teachEventsComplete();
            return;
        }
        CbusNodeEvent wholeEvent = this.eventsToTeachArray.get(this.nextEvInArray);
        log.debug("teach event var {}  val {} ", (Object)this.nextEvVar, (Object)wholeEvent.getEvVar(this.nextEvVar));
        CbusNodeEvent existingEvent = this.getNodeEvent(wholeEvent.getNn(), wholeEvent.getEn());
        log.debug("teach event {} with existing event {}", (Object)wholeEvent, (Object)existingEvent);
        if (existingEvent != null && existingEvent.getEvVar(this.nextEvVar) == wholeEvent.getEvVar(this.nextEvVar)) {
            ++this.nextEvVar;
            this.teachNewEvLoop();
            return;
        }
        this._node.getNodeTimerManager().setsendEditEvTimeout();
        this._node.send.nodeTeachEventLearnMode(wholeEvent.getNn(), wholeEvent.getEn(), this.nextEvVar, wholeEvent.getEvVar(this.nextEvVar));
        ++this.nextEvVar;
    }

    public void resetNodeEvents() {
        this._nodeEvents = null;
        this._node.notifyPropertyChangeListener("ALLEVUPDATE", null, null);
    }

    public void resetNodeEventsToZero() {
        this._nodeEvents = null;
        this._nodeEvents = new ArrayList();
        this._node.notifyPropertyChangeListener("ALLEVUPDATE", null, null);
    }

    public int getNextFreeIndex() {
        int newIndex = 1;
        int i = 0;
        while (i < this.getTotalNodeEvents()) {
            CbusNodeEvent a = this.getNodeEventByArrayID(i);
            if (a != null && newIndex <= a.getIndex()) {
                newIndex = a.getIndex() + 1;
            }
            ++i;
        }
        log.debug("dummy node sets index {}", (Object)newIndex);
        return newIndex;
    }

    public String toString() {
        return "Node Events";
    }
}

