/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.Arrays;
import java.util.Objects;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusBasicNodeEvent;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeEvent
extends CbusBasicNodeEvent
implements Comparable<CbusNodeEvent> {
    private int[] _evVarArr;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeEvent.class);

    public CbusNodeEvent(CanSystemConnectionMemo memo, int nn, int en, int thisnode, int index, int maxEvVar) {
        super(memo, nn, en, thisnode, index);
        this._evVarArr = new int[maxEvVar];
        Arrays.fill(this._evVarArr, -1);
    }

    protected CbusNodeEvent(int nn, int en, int thisnode, String eventString) {
        super(null, nn, en, thisnode, -1);
        this._evVarArr = StringUtil.intBytesWithTotalFromNonSpacedHexString(eventString, false);
        this.setTempFcuNodeName(null);
    }

    protected CbusNodeEvent(CbusNodeEvent existing) {
        super(null, existing.getNn(), existing.getEn(), existing.getParentNn(), existing.getIndex());
        this.setEvArr(Arrays.copyOf(existing.getEvVarArray(), existing.getEvVarArray().length));
        this.setTempFcuNodeName(existing.getTempFcuNodeName());
    }

    public void setEvVar(int index, int value) {
        if (index < 1) {
            log.error("Event Index needs to be more than 0");
            return;
        }
        if (value > 255) {
            log.error("Event Variable value needs to be less than 255 (oxff)");
            return;
        }
        this._evVarArr[index - 1] = value;
        this.notifyModel();
    }

    public final void setEvArr(int[] newArray) {
        this._evVarArr = newArray;
        this.notifyModel();
    }

    public int getEvVar(int index) {
        return this._evVarArr[index - 1];
    }

    public int[] getEvVarArray() {
        return this._evVarArr;
    }

    public String getEvVarString() {
        StringBuilder n = new StringBuilder();
        int i = 0;
        while (i < this._evVarArr.length) {
            if (this._evVarArr[i] > -1) {
                n.append(this._evVarArr[i]);
            } else {
                n.append(" ");
            }
            if (i != this._evVarArr.length - 1) {
                n.append(", ");
            }
            ++i;
        }
        return n.toString();
    }

    public String getHexEvVarString() {
        if (this.getEvVarArray() != null) {
            return StringUtil.hexStringFromInts(this.getEvVarArray()).replaceAll("\\s", "");
        }
        return "";
    }

    public int getOutstandingVars() {
        if (this.getEvVarArray() == null) {
            return 0;
        }
        int count = 0;
        int[] nArray = this.getEvVarArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            if (val == -1) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int getNextOutstanding() {
        int i = 0;
        while (i < this._evVarArr.length) {
            if (this._evVarArr[i] == -1) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public int getNumEvVars() {
        return this._evVarArr.length;
    }

    protected void allOutstandingEvVarsNotNeeded() {
        int i = 0;
        while (i < this._evVarArr.length) {
            if (this._evVarArr[i] == -1) {
                this._evVarArr[i] = 0;
            }
            ++i;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CbusNodeEvent)) {
            return false;
        }
        CbusNodeEvent t = (CbusNodeEvent)o;
        if (this.getEn() != t.getEn() || this.getNn() != t.getNn()) {
            return false;
        }
        if (this.getParentNn() != t.getParentNn()) {
            return false;
        }
        return this.getHexEvVarString().equals(t.getHexEvVarString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getEn(), this.getNn(), this.getParentNn(), this.getHexEvVarString());
    }

    @Override
    public int compareTo(CbusNodeEvent o) {
        return Integer.compare(this.listOrder(), o.listOrder());
    }

    private int listOrder() {
        return this.getNn() * 65535 + this.getEn() + 100 + Objects.hash(this.getHexEvVarString()) % 100;
    }
}

