/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.simulator.CbusDummyNode;

public class CbusNodeConstants {
    private static final Map<Integer, String> manMap = CbusNodeConstants.createManMap();
    private static final Map<Integer, String> busMap = CbusNodeConstants.createBusMap();
    private static final Map<Integer, String> type165Map = CbusNodeConstants.createType165Map();
    private static final Map<Integer, String> type70Map = CbusNodeConstants.createType70Map();
    private static final Map<Integer, String> type80Map = CbusNodeConstants.createType80Map();
    private static final Map<Integer, String> type44Map = CbusNodeConstants.createType44Map();
    private static final Map<Integer, String> extra165Map = CbusNodeConstants.createExtra165Map();
    private static final Map<Integer, String> extra70Map = CbusNodeConstants.createExtra70Map();
    private static final Map<Integer, String> extra80Map = CbusNodeConstants.createExtra80Map();
    private static final Map<Integer, String> extra44Map = CbusNodeConstants.createExtra44Map();
    private static final Map<Integer, String> link165Map = CbusNodeConstants.createLink165Map();
    private static final Map<Integer, String> link70Map = CbusNodeConstants.createLink70Map();
    private static final Map<Integer, String> link44Map = CbusNodeConstants.createLink44Map();
    private static final Map<Integer, String> resMod = CbusNodeConstants.createModMap();
    private static final Map<String, BackupType> nameIndex = new HashMap<String, BackupType>(BackupType.values().length);
    private static final Map<BackupType, String> displayPhraseIndex;

    static {
        BackupType[] backupTypeArray = BackupType.values();
        int n = backupTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BackupType t = backupTypeArray[n2];
            nameIndex.put(t.name(), t);
            ++n2;
        }
        displayPhraseIndex = new HashMap<BackupType, String>(BackupType.values().length);
        displayPhraseIndex.put(BackupType.INCOMPLETE, Bundle.getMessage("BackupIncomplete"));
        displayPhraseIndex.put(BackupType.COMPLETE, Bundle.getMessage("BackupComplete"));
        displayPhraseIndex.put(BackupType.COMPLETEDWITHERROR, Bundle.getMessage("BackupCompleteError"));
        displayPhraseIndex.put(BackupType.NOTONNETWORK, Bundle.getMessage("BackupNotOnNetwork"));
        displayPhraseIndex.put(BackupType.OUTSTANDING, Bundle.getMessage("BackupOutstanding"));
        displayPhraseIndex.put(BackupType.SLIM, Bundle.getMessage("NodeInSlim"));
    }

    public static void setTraits(@Nonnull CbusNode node) {
        block14: {
            block13: {
                node.setsendsWRACKonNVSET(true);
                if (node.getNodeParamManager().getParameter(1) != 165) break block13;
                switch (node.getNodeParamManager().getParameter(3)) {
                    case 29: {
                        node.setsendsWRACKonNVSET(false);
                        break;
                    }
                    case 10: 
                    case 12: 
                    case 55: {
                        if (node.getNodeParamManager().getParameter(7) == 4) {
                            node.getNodeEventManager().resetNodeEventsToZero();
                            node.setStatResponseFlagsAccurate(false);
                            break;
                        }
                        break block14;
                    }
                    case 46: {
                        if (node.getNodeParamManager().getParameter(7) == 1) {
                            node.getNodeEventManager().resetNodeEventsToZero();
                            break;
                        }
                        break block14;
                    }
                    case 9: {
                        node.getNodeEventManager().resetNodeEventsToZero();
                        break;
                    }
                    case 50: {
                        node.setnvWriteInLearnOnly(true);
                        break;
                    }
                }
                break block14;
            }
            if (node.getNodeParamManager().getParameter(1) == 44) {
                switch (node.getNodeParamManager().getParameter(3)) {
                    case 8: {
                        node.setnvWriteInLearnOnly(true);
                        break;
                    }
                }
            }
        }
    }

    public static void setDummyNodeParameters(CbusDummyNode thisNode, int manu, int type) {
        if (manu == 165) {
            if (type == 29) {
                int[] nArray = new int[21];
                nArray[0] = 20;
                nArray[1] = 165;
                nArray[2] = 89;
                nArray[3] = 29;
                nArray[4] = 128;
                nArray[5] = 13;
                nArray[6] = 1;
                nArray[7] = 1;
                nArray[8] = 13;
                nArray[9] = 13;
                nArray[10] = 1;
                nArray[12] = 8;
                nArray[19] = 1;
                nArray[20] = 1;
                int[] _params = nArray;
                thisNode.getNodeParamManager().setParameters(_params);
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                thisNode.getNodeNvManager().setNVs(nArray2);
                thisNode.setNodeNameFromName("PAN");
            } else if (type == 255) {
                int[] nArray = new int[21];
                nArray[0] = 20;
                nArray[1] = 165;
                nArray[2] = 89;
                nArray[3] = 255;
                nArray[4] = 255;
                nArray[5] = 255;
                nArray[6] = 255;
                nArray[7] = 1;
                nArray[8] = 13;
                nArray[9] = 13;
                nArray[10] = 1;
                nArray[12] = 8;
                nArray[19] = 1;
                nArray[20] = 1;
                int[] _params = nArray;
                thisNode.getNodeParamManager().setParameters(_params);
                int[] nvArray = new int[256];
                nvArray[0] = 255;
                int i = 1;
                while (i < nvArray.length) {
                    nvArray[i] = i;
                    ++i;
                }
                int[] evVarArray = new int[255];
                int i2 = 0;
                while (i2 < evVarArray.length) {
                    evVarArray[i2] = i2 + 1;
                    ++i2;
                }
                i2 = 1;
                while (i2 < 256) {
                    CbusNodeEvent singleEv = new CbusNodeEvent(thisNode._memo, i2, i2, -1, i2, 255);
                    singleEv.setEvArr(evVarArray);
                    thisNode.getNodeEventManager().addNewEvent(singleEv);
                    ++i2;
                }
                thisNode.getNodeNvManager().setNVs(nvArray);
                thisNode.setNodeNameFromName("TSTMAXND");
            } else {
                int[] nArray = new int[9];
                nArray[0] = 8;
                nArray[1] = 165;
                thisNode.getNodeParamManager().setParameters(nArray);
                thisNode.getNodeNvManager().setNVs(new int[1]);
            }
        } else if (manu == 44) {
            if (type == 1) {
                int[] nArray = new int[21];
                nArray[0] = 20;
                nArray[1] = 44;
                nArray[2] = 102;
                nArray[3] = 1;
                nArray[6] = 1;
                nArray[7] = 3;
                nArray[9] = 25;
                nArray[12] = 8;
                nArray[13] = 4;
                nArray[19] = 1;
                nArray[20] = 1;
                int[] _params = nArray;
                thisNode.getNodeParamManager().setParameters(_params);
                int[] nArray3 = new int[2];
                nArray3[0] = 1;
                thisNode.getNodeNvManager().setNVs(nArray3);
                thisNode.setNodeNameFromName("PSPROG3");
            } else {
                int[] nArray = new int[9];
                nArray[0] = 8;
                nArray[1] = 44;
                thisNode.getNodeParamManager().setParameters(nArray);
                thisNode.getNodeNvManager().setNVs(new int[1]);
            }
        } else {
            int[] nArray = new int[9];
            nArray[0] = 8;
            nArray[1] = 165;
            thisNode.getNodeParamManager().setParameters(nArray);
            thisNode.getNodeNvManager().setNVs(new int[1]);
        }
        CbusNodeConstants.setTraits(thisNode);
    }

    public static String getManu(int man) {
        if (man < 1) {
            return "";
        }
        String format = manMap.get(man);
        if (format == null) {
            return "Manufacturer " + man;
        }
        return format;
    }

    private static Map<Integer, String> createManMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(70, "ROCRAIL");
        result.put(80, "SPECTRUM");
        result.put(165, "MERG");
        result.put(44, "SPROG DCC");
        return Collections.unmodifiableMap(result);
    }

    public static String getBusType(int type) {
        String format = busMap.get(type);
        if (format == null) {
            return "Unknown";
        }
        return format;
    }

    private static Map<Integer, String> createBusMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "None");
        result.put(1, "CAN");
        result.put(2, "ETH");
        result.put(3, "MIWI");
        return Collections.unmodifiableMap(result);
    }

    public static String getModuleType(int man, int type) {
        String format = "";
        if (man == 165) {
            format = type165Map.get(type);
        } else if (man == 70) {
            format = type70Map.get(type);
        } else if (man == 80) {
            format = type80Map.get(type);
        } else if (man == 44) {
            format = type44Map.get(type);
        }
        if (format == null) {
            return "";
        }
        return format;
    }

    private static Map<Integer, String> createType165Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "SLIM");
        result.put(1, "CANACC4");
        result.put(2, "CANACC5");
        result.put(3, "CANACC8");
        result.put(4, "CANACE3");
        result.put(5, "CANACE8C");
        result.put(6, "CANLED");
        result.put(7, "CANLED64");
        result.put(8, "CANACC4_2");
        result.put(9, "CANCAB");
        result.put(10, "CANCMD");
        result.put(11, "CANSERVO");
        result.put(12, "CANBC");
        result.put(13, "CANRPI");
        result.put(14, "CANTTCA");
        result.put(15, "CANTTCB");
        result.put(16, "CANHS");
        result.put(17, "CANTOTI");
        result.put(18, "CAN8I8O");
        result.put(19, "CANSERVO8C");
        result.put(20, "CANRFID");
        result.put(21, "CANTC4");
        result.put(22, "CANACE16C");
        result.put(23, "CANIO8");
        result.put(24, "CANSNDX");
        result.put(25, "CANEther");
        result.put(26, "CANSIG64");
        result.put(27, "CANSIG8");
        result.put(28, "CANCOND8C");
        result.put(29, "CANPAN");
        result.put(30, "CANACE3C");
        result.put(31, "CANPanel");
        result.put(32, "CANMIO");
        result.put(33, "CANACE8MIO");
        result.put(34, "CANSOL");
        result.put(35, "CANBIP");
        result.put(36, "CANCDU");
        result.put(37, "CANACC4CDU");
        result.put(38, "CANWiBase");
        result.put(39, "WiCAB");
        result.put(40, "CANWiFi");
        result.put(41, "CANFTT");
        result.put(42, "CANHNDST");
        result.put(43, "CANTCHNDST");
        result.put(44, "CANRFID8");
        result.put(45, "CANmchRFID");
        result.put(46, "CANPiWi");
        result.put(47, "CAN4DC");
        result.put(48, "CANELEV");
        result.put(49, "CANSCAN");
        result.put(50, "CANMIO_SVO");
        result.put(51, "CANMIO_INP");
        result.put(52, "CANMIO_OUT");
        result.put(53, "CANBIP_OUT");
        result.put(54, "CANASTOP");
        result.put(55, "CANCSB");
        result.put(56, "CANMAG");
        result.put(57, "CANACE16CMIO");
        result.put(58, "CANPiNODE");
        result.put(59, "CANDISP");
        result.put(60, "CANCOMPUTE");
        result.put(61, "CANRC522");
        result.put(62, "CANINP");
        result.put(63, "CANOUT");
        result.put(64, "CANEMIO");
        result.put(65, "CANCABDC");
        result.put(66, "CANRCOM");
        result.put(253, "CANUSB");
        result.put(254, "EMPTY");
        result.put(255, "CAN_SW");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createType70Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "CANGC1");
        result.put(2, "CANGC2");
        result.put(3, "CANGC3");
        result.put(4, "CANGC4");
        result.put(5, "CANGC5");
        result.put(6, "CANGC6");
        result.put(7, "CANGC7");
        result.put(11, "CANGC1e");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createType80Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "AMCTRLR");
        result.put(2, "DUALCAB");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createType44Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "CANPiSPRG3");
        result.put(2, "CANSPROG3P");
        result.put(3, "CANSPROG");
        result.put(4, "SBOOST");
        result.put(5, "Unsupported");
        result.put(6, "CANISB");
        result.put(7, "CANCBUSIO");
        result.put(8, "CANSERVOIO");
        result.put(9, "CANSOLIO");
        return Collections.unmodifiableMap(result);
    }

    public static String getModuleTypeExtra(int man, int type) {
        String format = "";
        if (man == 165) {
            format = extra165Map.get(type);
        } else if (man == 70) {
            format = extra70Map.get(type);
        } else if (man == 80) {
            format = extra80Map.get(type);
        } else if (man == 44) {
            format = extra44Map.get(type);
        }
        return format;
    }

    private static Map<Integer, String> createExtra165Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "Default for SLiM nodes");
        result.put(1, "Solenoid point driver");
        result.put(2, "Motorised point driver");
        result.put(3, "8 digital outputs ( + 8 inputs if modded)");
        result.put(4, "Control panel switch/button encoder");
        result.put(5, "8 digital inputs");
        result.put(6, "64 led driver");
        result.put(7, "64 led driver (multi leds per event)");
        result.put(8, "12v version of CANACC4 Solenoid point driver");
        result.put(9, "CANCAB hand throttle");
        result.put(10, "Command Station");
        result.put(11, "8 servo driver (on canacc8 or similar hardware)");
        result.put(12, "BC1a Command Station");
        result.put(13, "RPI and RFID interface");
        result.put(14, "Turntable controller (turntable end)");
        result.put(15, "Turntable controller (control panel end)");
        result.put(16, "Handset controller for old BC1a type handsets");
        result.put(17, "Track occupancy detector");
        result.put(18, "8 inputs 8 outputs");
        result.put(19, "Canservo with servo position feedback");
        result.put(20, "RFID input");
        result.put(21, "CANTC4");
        result.put(22, "16 inputs");
        result.put(23, "8 way I/O");
        result.put(24, "CANSNDX");
        result.put(25, "Ethernet interface");
        result.put(26, "Multiple aspect signalling for CANLED module");
        result.put(27, "Multiple aspect signalling for CANACC8 module");
        result.put(28, "Conditional event generation");
        result.put(29, "Control panel 32 Outputs + 32 Inputs");
        result.put(30, "Newer version of CANACE3 firmware");
        result.put(31, "Control panel 64 Inputs / 64 Outputs");
        result.put(32, "Multiple I/O \u2013 Universal CANMIO firmware");
        result.put(33, "Multiple IO module 16 inputs emulating CANACE8C on CANMIO hardware");
        result.put(34, "Solenoid driver module");
        result.put(35, "Universal CANBIP firmware - Bipolar IO module with additional 8 I/O pins (CANMIO family)");
        result.put(36, "Solenoid driver module with additional 6 I/O pins (CANMIO family)");
        result.put(37, "CANACC4 firmware ported to CANCDU");
        result.put(38, "CAN to MiWi base station");
        result.put(39, "Wireless cab using MiWi protocol");
        result.put(40, "CAN to WiFi connection with Withrottle to CBUS protocol conversion");
        result.put(41, "Turntable controller configured using FLiM");
        result.put(42, "Handset (alternative to CANCAB)");
        result.put(43, "Touchscreen handset");
        result.put(44, "multi-channel RFID reader");
        result.put(45, "either a 2ch or 8ch RFID reader");
        result.put(46, "Raspberry Pi based module for WiFi");
        result.put(47, "DC train controller");
        result.put(48, "Nelevator controller");
        result.put(49, "128 switch inputs");
        result.put(50, "16MHz 25k80 version of CANSERVO8c on CANMIO hardware");
        result.put(51, "16MHz 25k80 version of CANACE8MIO on CANMIO hardware");
        result.put(52, "16MHz 25k80 version of CANACC8 on CANMIO hardware");
        result.put(53, "16MHz 25k80 version of CANACC5 on CANMIO hardware");
        result.put(54, "DCC stop generator");
        result.put(55, "Command Station with 3A booster");
        result.put(56, "Magnet on Track detector");
        result.put(57, "16 input equivaent to CANACE8C");
        result.put(58, "CBUS module based on Raspberry Pi");
        result.put(59, "25K80 version of CANLED64");
        result.put(60, "Compute Event processing engine");
        result.put(61, "Read/Write from/to RC522 RFID tags");
        result.put(62, "8 inputs module (2g version of CANACE8c)");
        result.put(63, "8 outputs module (2g version of CANACC8)");
        result.put(64, "Extended CANMIO (24 I/O ports)");
        result.put(65, "DC cab");
        result.put(66, "DCC Railcom detector/reader");
        result.put(253, "USB interface");
        result.put(254, "Empty module, bootloader only");
        result.put(255, "Software nodes");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createExtra70Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "RS232 PC interface.");
        result.put(2, "16 I/O.");
        result.put(3, "Command station (derived from cancmd).");
        result.put(4, "8 channel RFID reader.");
        result.put(5, "Cab for fixed panels (derived from cancab).");
        result.put(6, "4 channel servo controller.");
        result.put(7, "Fast clock module.");
        result.put(11, "CAN Ethernet interface.");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createExtra80Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "Animation controller (firmware derived from cancmd).");
        result.put(2, "Dual cab based on cancab.");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createExtra44Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "Pi-SPROG 3 programmer/command station.");
        result.put(2, "SPROG 3 Plus programmer/command station.");
        result.put(3, "CAN SPROG programmer/command station.");
        result.put(4, "System booster");
        result.put(5, "Unsuppoerted module type");
        result.put(6, "CBUS I/O module.");
        result.put(7, "Isolated USB to CAN interface with CBUS node.");
        result.put(8, "8-channel servo I/O.");
        result.put(9, "8-channel twin-coil solenoid I/O.");
        return Collections.unmodifiableMap(result);
    }

    public static String getModuleSupportLink(int man, int type) {
        String format = "";
        if (man == 165) {
            format = link165Map.get(type);
        } else if (man == 70) {
            format = link70Map.get(type);
        } else if (man == 44) {
            format = link44Map.get(type);
        }
        if (format == null) {
            return "";
        }
        return format;
    }

    private static Map<Integer, String> createLink165Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canacc4");
        result.put(2, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canacc5");
        result.put(3, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canacc8");
        result.put(4, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canace3");
        result.put(5, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canace8c");
        result.put(7, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canled64");
        result.put(8, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canacc4");
        result.put(9, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cancab");
        result.put(10, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cancmd");
        result.put(14, "https://www.merg.org.uk/merg_wiki/doku.php?id=other_download:turntable");
        result.put(15, "https://www.merg.org.uk/merg_wiki/doku.php?id=other_download:turntable");
        result.put(17, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canace8c");
        result.put(19, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canservo8");
        result.put(20, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canrfid");
        result.put(25, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canether");
        result.put(26, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cansig");
        result.put(27, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cansig");
        result.put(28, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canccond8c");
        result.put(29, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canpan");
        result.put(30, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canace3");
        result.put(31, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canpanel");
        result.put(32, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canmio");
        result.put(34, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cansol");
        result.put(35, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canbip");
        result.put(36, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cancdu");
        result.put(44, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canrfid8");
        result.put(45, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canmchrfid");
        result.put(46, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canwi");
        result.put(47, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:can4dc");
        result.put(49, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canscan");
        result.put(50, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canmio");
        result.put(51, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canmio");
        result.put(52, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canmio");
        result.put(54, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canastop");
        result.put(55, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cancsb");
        result.put(59, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:candisp");
        result.put(60, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:cancompute");
        result.put(61, "https://merg.org.uk/merg_wiki/doku.php?id=cbus:canrc522");
        result.put(62, "https://merg.org.uk/merg_wiki/doku.php?id=cbus:caninp");
        result.put(63, "https://merg.org.uk/merg_wiki/doku.php?id=cbus:canout");
        result.put(65, "https://merg.org.uk/merg_wiki/doku.php?id=cbus:cancabdc");
        result.put(66, "https://www.merg.org.uk/merg_wiki/doku.php?id=cbus:canrcom");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createLink70Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "https://wiki.rocrail.net/doku.php?id=can-gca1-en");
        result.put(2, "https://wiki.rocrail.net/doku.php?id=can-gca2-en");
        result.put(3, "https://wiki.rocrail.net/doku.php?id=can-gc3-en");
        result.put(4, "https://wiki.rocrail.net/doku.php?id=can-gc4-en");
        result.put(5, "https://wiki.rocrail.net/doku.php?id=can-gca5-en");
        result.put(6, "https://wiki.rocrail.net/doku.php?id=can-gc6-en");
        result.put(7, "https://wiki.rocrail.net/doku.php?id=can-gc7-en");
        result.put(11, "https://wiki.rocrail.net/doku.php?id=can-gca1e-en");
        return Collections.unmodifiableMap(result);
    }

    private static Map<Integer, String> createLink44Map() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "https://www.sprog-dcc.co.uk/download-page");
        result.put(2, "https://www.sprog-dcc.co.uk/download-page");
        result.put(3, "https://www.sprog-dcc.co.uk/download-page");
        result.put(4, "https://www.sprog-dcc.co.uk/download-page");
        result.put(5, "https://www.sprog-dcc.co.uk/download-page");
        return Collections.unmodifiableMap(result);
    }

    public static String getReservedModule(int modnum) {
        String format = resMod.get(modnum);
        if (format == null) {
            return "";
        }
        return format;
    }

    private static Map<Integer, String> createModMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        int i = 100;
        while (i < 126) {
            result.put(i, Bundle.getMessage("NdNumReserveFixed"));
            ++i;
        }
        result.put(126, "Reserved for CAN_RS Modules");
        result.put(127, "Reserved for CAN_USB Modules");
        result.put(65534, "Reserved for Command Station");
        result.put(65535, "Reserved, used by all CABS");
        return Collections.unmodifiableMap(result);
    }

    public static String displayPhrase(BackupType type) {
        return displayPhraseIndex.get((Object)type);
    }

    public static BackupType lookupByName(String name) {
        return nameIndex.get(name);
    }

    public static enum BackupType {
        INCOMPLETE(0),
        COMPLETE(1),
        COMPLETEDWITHERROR(2),
        NOTONNETWORK(3),
        OUTSTANDING(4),
        SLIM(5);

        private final int v;

        private BackupType(int v) {
            this.v = v;
        }

        public int getValue() {
            return this.v;
        }
    }
}

