/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import jmri.PowerManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusPowerManager;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBasicNodeWithMgrsCommandStation
extends CbusBasicNodeWithManagers {
    private int _csNum = -1;
    private boolean _StatResponseFlagsAccurate = false;
    private int _csFlags = -1;
    private static final Logger log = LoggerFactory.getLogger(CbusBasicNodeWithMgrsCommandStation.class);

    public CbusBasicNodeWithMgrsCommandStation(CanSystemConnectionMemo connmemo, int nodenumber) {
        super(connmemo, nodenumber);
    }

    public void setCsNum(int csnum) {
        this._csNum = csnum;
    }

    public int getCsNum() {
        return this._csNum;
    }

    public void setCsFlags(int flags) {
        log.debug("flags value {}", (Object)flags);
        if (!this.getStatResponseFlagsAccurate()) {
            return;
        }
        this._csFlags = flags;
        this.checkSingleFlag(0, "Command Station {} Reporting Hardware Error (self test)");
        this.checkSingleFlag(1, "Command Station {} Reporting Track Error");
        this.setTrackPower((flags >> 2 & 1) == 1);
        this.checkSingleFlag(3, "Command Station {} Reporting Bus Halted");
    }

    private void setTrackPower(boolean powerOn) {
        CbusPowerManager pm = (CbusPowerManager)this._memo.get(PowerManager.class);
        pm.updatePower(powerOn ? 2 : 4);
    }

    private void checkSingleFlag(int flagNum, String errorText) {
        if ((this._csFlags >> flagNum & 1) == 1) {
            log.error(errorText, (Object)(this.getCsNum() + " " + this.getNodeNumber()));
        }
    }

    public void setStatResponseFlagsAccurate(boolean accurate) {
        this._StatResponseFlagsAccurate = accurate;
    }

    public boolean getStatResponseFlagsAccurate() {
        return this._StatResponseFlagsAccurate;
    }
}

