/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusBasicNode;
import jmri.jmrix.can.cbus.node.CbusNodeBackupManager;
import jmri.jmrix.can.cbus.node.CbusNodeCanListener;
import jmri.jmrix.can.cbus.node.CbusNodeEventManager;
import jmri.jmrix.can.cbus.node.CbusNodeNVManager;
import jmri.jmrix.can.cbus.node.CbusNodeParameterManager;
import jmri.jmrix.can.cbus.node.CbusNodeStats;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTimerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBasicNodeWithManagers
extends CbusBasicNode {
    private final CbusNodeTimerManager _timers;
    private final CbusNodeParameterManager _nodeParameters;
    private final CbusNodeNVManager _nvManager;
    private final CbusNodeEventManager _evManager;
    private final CbusNodeStats _nodeStats;
    private final CbusNodeBackupManager thisNodeBackupFile;
    private CbusNodeCanListener _canListener;
    private CbusNodeTableDataModel tableModel;
    protected int _fwMaj;
    protected int _fwMin;
    protected int _fwBuild;
    private int _manu;
    private int _type;
    private String _nodeUserName = "";
    private static final Logger log = LoggerFactory.getLogger(CbusBasicNodeWithManagers.class);

    public CbusBasicNodeWithManagers(CanSystemConnectionMemo connmemo, int nodenumber) {
        super(connmemo, nodenumber);
        if (this._memo != null) {
            log.debug("New CanListener {}", (Object)this.getCanListener());
        }
        this._timers = new CbusNodeTimerManager(this);
        this._nodeParameters = new CbusNodeParameterManager(this);
        this._nvManager = new CbusNodeNVManager(this);
        this._evManager = new CbusNodeEventManager(this._memo, this);
        this.thisNodeBackupFile = new CbusNodeBackupManager(this);
        this._nodeStats = new CbusNodeStats(this);
        this._manu = -1;
        this._type = -1;
        this.setFW(-1, -1, -1);
    }

    @Nonnull
    public CbusNodeCanListener getNewCanListener() {
        return new CbusNodeCanListener(this._memo, this);
    }

    @Nonnull
    public final CbusNodeCanListener getCanListener() {
        if (this._canListener == null) {
            this._canListener = this.getNewCanListener();
        }
        return this._canListener;
    }

    @Nonnull
    public final CbusNodeTimerManager getNodeTimerManager() {
        return this._timers;
    }

    @Nonnull
    public final CbusNodeParameterManager getNodeParamManager() {
        return this._nodeParameters;
    }

    @Nonnull
    public final CbusNodeNVManager getNodeNvManager() {
        return this._nvManager;
    }

    @Nonnull
    public final CbusNodeEventManager getNodeEventManager() {
        return this._evManager;
    }

    @Nonnull
    public final CbusNodeBackupManager getNodeBackupManager() {
        return this.thisNodeBackupFile;
    }

    @Nonnull
    public final CbusNodeStats getNodeStats() {
        return this._nodeStats;
    }

    protected void setTableModel(CbusNodeTableDataModel model) {
        this.tableModel = model;
    }

    protected CbusNodeTableDataModel getTableModel() {
        return this.tableModel;
    }

    public final void setFW(int fwMaj, int fwMin, int fwBuild) {
        this._fwMaj = fwMaj;
        this._fwMin = fwMin;
        this._fwBuild = fwBuild;
    }

    protected void setManuModule(int manu, int modtype) {
        this._manu = manu;
        this._type = modtype;
    }

    protected int getPnnManufacturer() {
        return this._manu;
    }

    protected int getPnnModule() {
        return this._type;
    }

    public String getUserName() {
        return this._nodeUserName;
    }

    public void setUserName(String newName) {
        this._nodeUserName = newName;
        this.notifyPropertyChangeListener("NAMECHANGE", null, newName);
        if (this.getNodeBackupManager().getBackupStarted() && !this.getNodeBackupManager().doStore(false, this.getNodeStats().hasLoadErrors())) {
            log.error("Unable to save Node Name to Node {} Backup File", (Object)this);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        this.getCanListener().dispose();
        this.getNodeTimerManager().cancelTimers();
    }
}

