/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusBasicNodeTable;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBasicNodeTableOperations
extends CbusBasicNodeTable {
    private int requestNodeToDisplay = 0;
    private static final Logger log = LoggerFactory.getLogger(CbusBasicNodeTableOperations.class);

    public CbusBasicNodeTableOperations(@Nonnull CanSystemConnectionMemo memo, int row, int column) {
        super(memo, row, column);
    }

    public void addNode(CbusNode node) {
        this._mainArray.add(node);
        if (this instanceof CbusNodeTableDataModel) {
            node.setTableModel((CbusNodeTableDataModel)this);
            node.addPropertyChangeListener((CbusNodeTableDataModel)this);
            ((CbusNodeTableDataModel)this).startBackgroundFetch();
        }
        if (this._mainArray.size() == 1) {
            this.setRequestNodeDisplay(node.getNodeNumber());
        }
        ThreadingUtil.runOnGUIEventually(() -> this.fireTableDataChanged());
    }

    @CheckForNull
    public CbusNode getCsByNum(int csnum) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getCsNum() == csnum) {
                return (CbusNode)this._mainArray.get(i);
            }
            ++i;
        }
        return null;
    }

    @Nonnull
    protected CbusNode provideCsByNum(int csnum, int nodenum) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getCsNum() == csnum) {
                ((CbusNode)this._mainArray.get(i)).setNodeNumber(nodenum);
                return (CbusNode)this._mainArray.get(i);
            }
            ++i;
        }
        CbusNode cs = this.provideNodeByNodeNum(nodenum);
        cs.setCsNum(csnum);
        return cs;
    }

    @Nonnull
    public CbusNode provideNodeByNodeNum(int nodenum) {
        if (nodenum < 1 || nodenum > 65535) {
            throw new IllegalArgumentException("Node number should be between 1 and 65535");
        }
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getNodeNumber() == nodenum) {
                return (CbusNode)this._mainArray.get(i);
            }
            ++i;
        }
        CbusNode cs = new CbusNode(this._memo, nodenum);
        this.addNode(cs);
        return cs;
    }

    public CbusNode getNodeByRowNum(int rowNum) {
        return (CbusNode)this._mainArray.get(rowNum);
    }

    public int getNodeRowFromNodeNum(int nodenum) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getNodeNumber() == nodenum) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getNodeNameFromCanId(int canId) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getNodeCanId() == canId) {
                return ((CbusNode)this._mainArray.get(i)).getNodeStats().getNodeNumberName();
            }
            ++i;
        }
        return "";
    }

    public int getAnyNodeInLearnMode() {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getNodeInLearnMode()) {
                return ((CbusNode)this._mainArray.get(i)).getNodeNumber();
            }
            ++i;
        }
        return -1;
    }

    @CheckForNull
    public CbusNode getNodeByNodeNum(int nodenum) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getNodeNumber() == nodenum) {
                return (CbusNode)this._mainArray.get(i);
            }
            ++i;
        }
        return null;
    }

    public void removeRow(int row, boolean removeXml) {
        CbusNode toRemove = this.getNodeByNodeNum(((CbusNode)this._mainArray.get(row)).getNodeNumber());
        this._mainArray.remove(row);
        if (toRemove != null) {
            if (this instanceof CbusNodeTableDataModel) {
                toRemove.removePropertyChangeListener((CbusNodeTableDataModel)this);
            }
            if (removeXml && !toRemove.getNodeBackupManager().removeNode(true)) {
                log.error("Unable to delete node xml file");
            }
            ThreadingUtil.runOnGUI(() -> this.fireTableRowsDeleted(row, row));
            toRemove.dispose();
        }
    }

    public int getNextAvailableNodeNumber(int higherthan) {
        if (this.getRowCount() > 0) {
            int i = 0;
            while (i < this.getRowCount()) {
                if (((CbusNode)this._mainArray.get(i)).getNodeNumber() < 65534 && ((CbusNode)this._mainArray.get(i)).getNodeNumber() >= higherthan) {
                    higherthan = ((CbusNode)this._mainArray.get(i)).getNodeNumber() + 1;
                }
                ++i;
            }
        }
        return higherthan;
    }

    @Nonnull
    public ArrayList<String> getListOfNodeNumberNames() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.getRowCount()) {
            list.add(((CbusNode)this._mainArray.get(i)).getNodeStats().getNodeNumberName());
            ++i;
        }
        return list;
    }

    public String getNodeNumberName(int nodenum) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getNodeNumber() == nodenum) {
                return ((CbusNode)this._mainArray.get(i)).getNodeStats().getNodeNumberName();
            }
            ++i;
        }
        return "";
    }

    @Nonnull
    public String getNodeName(int nn) {
        int rownum = this.getNodeRowFromNodeNum(nn);
        if (rownum < 0) {
            return "";
        }
        if (!((CbusNode)this._mainArray.get(rownum)).getUserName().isEmpty()) {
            return ((CbusNode)this._mainArray.get(rownum)).getUserName();
        }
        if (!((CbusNode)this._mainArray.get(rownum)).getNodeStats().getNodeTypeName().isEmpty()) {
            return ((CbusNode)this._mainArray.get(rownum)).getNodeStats().getNodeTypeName();
        }
        return "";
    }

    public int getRequestNodeRowToDisplay() {
        return this.getNodeRowFromNodeNum(this.requestNodeToDisplay);
    }

    public void setRequestNodeDisplay(int nodeNumber) {
        this.requestNodeToDisplay = nodeNumber;
    }
}

