/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import javax.annotation.Nonnull;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.node.CbusBasicNodeTableOperations;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTrickleFetch;

public class CbusBasicNodeTableFetch
extends CbusBasicNodeTableOperations {
    protected CbusNodeTrickleFetch trickleFetch;
    private int urgentNode = -1;
    private int nodebefore = -1;
    private int nodeafter = -1;
    private boolean urgentActive = false;

    public CbusBasicNodeTableFetch(@Nonnull CanSystemConnectionMemo memo, int row, int column) {
        super(memo, row, column);
    }

    public void startUrgentFetch() {
        this.urgentActive = true;
        this.startBackgroundFetch();
    }

    protected void setUrgentNode(int nodeNum) {
        this.urgentNode = nodeNum;
        this.urgentActive = true;
        this.startBackgroundFetch();
    }

    public void setUrgentFetch(int nodenum, int urgentNodeBefore, int urgentNodeAfter) {
        this.urgentNode = nodenum;
        this.nodebefore = urgentNodeBefore;
        this.nodeafter = urgentNodeAfter;
        this.urgentActive = true;
        this.startBackgroundFetch();
    }

    public void triggerUrgentFetch() {
        if (this.urgentActive) {
            this.sendNextBackgroundFetch();
        }
    }

    public void startBackgroundFetch() {
        if (!(this instanceof CbusNodeTableDataModel)) {
            return;
        }
        CbusPreferences pref = ((CbusNodeTableDataModel)this).preferences;
        if (this.trickleFetch != null) {
            this.trickleFetch.dispose();
        }
        this.trickleFetch = null;
        if (pref != null && pref.getNodeBackgroundFetchDelay() > 0L) {
            this.trickleFetch = new CbusNodeTrickleFetch(this._memo, this, pref.getNodeBackgroundFetchDelay());
        }
    }

    private boolean hasActiveTimers() {
        int i = 0;
        while (i < this.getRowCount()) {
            ((CbusNode)this._mainArray.get(i)).getNodeBackupManager().doLoad();
            if (((CbusNode)this._mainArray.get(i)).getNodeTimerManager().hasActiveTimers()) {
                return true;
            }
            ((CbusNode)this._mainArray.get(i)).getNodeStats().checkNodeFinishedLoad();
            ++i;
        }
        return false;
    }

    private boolean sentCommandStationFetch() {
        int i = 0;
        while (i < this.getRowCount()) {
            if (((CbusNode)this._mainArray.get(i)).getCsNum() > -1) {
                if (this.sentOutstandingParam((CbusNode)this._mainArray.get(i))) {
                    return true;
                }
                if (((CbusNode)this._mainArray.get(i)).getNodeParamManager().getParameter(6) > 15 && ((CbusNode)this._mainArray.get(i)).getNodeNvManager().getNV(16) < 0) {
                    ((CbusNode)this._mainArray.get(i)).getNodeNvManager().sendNextNVToFetch();
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean sentAnAllNodeParam() {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.sentOutstandingParam((CbusNode)this._mainArray.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean sentOutstandingNvs(CbusNode thisnode) {
        if (thisnode != null && thisnode.getNodeNvManager().getOutstandingNvCount() > 0) {
            thisnode.getNodeNvManager().sendNextNVToFetch();
            return true;
        }
        return false;
    }

    private boolean sentOutstandingEvs(CbusNode thisnode) {
        if (thisnode != null && thisnode.getNodeEventManager().getOutstandingEvVars() > 0) {
            thisnode.getNodeEventManager().sendNextEvVarToFetch();
            return true;
        }
        return false;
    }

    private boolean sentOutstandingNvsOrEvs(CbusNode thisnode) {
        return this.sentOutstandingNvs(thisnode) || this.sentOutstandingEvs(thisnode);
    }

    private boolean sentOutstandingParam(CbusNode thisnode) {
        if (thisnode != null && thisnode.getNodeParamManager().getOutstandingParams() > 0) {
            thisnode.getNodeParamManager().sendRequestNextParam();
            return true;
        }
        return false;
    }

    private boolean sentUrgentFetches() {
        CbusNode _urgentNode = this.getNodeByNodeNum(this.urgentNode);
        CbusNode _beforeNode = this.getNodeByNodeNum(this.nodebefore);
        CbusNode _afterNode = this.getNodeByNodeNum(this.nodeafter);
        if (this.sentOutstandingNvsOrEvs(_urgentNode)) {
            return true;
        }
        if (this.sentOutstandingNvs(_afterNode) || this.sentOutstandingNvs(_beforeNode)) {
            return true;
        }
        if (this.sentOutstandingEvs(_afterNode) || this.sentOutstandingEvs(_beforeNode)) {
            return true;
        }
        this.urgentActive = false;
        return false;
    }

    protected void sendNextBackgroundFetch() {
        if (this.getAnyNodeInLearnMode() > 0 || this.hasActiveTimers()) {
            return;
        }
        if (this.sentCommandStationFetch() || this.sentAnAllNodeParam()) {
            return;
        }
        if (this.sentUrgentFetches()) {
            return;
        }
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.sentOutstandingNvsOrEvs((CbusNode)this._mainArray.get(i))) {
                return;
            }
            ++i;
        }
        if (this.trickleFetch != null) {
            this.trickleFetch.dispose();
        }
        this.trickleFetch = null;
    }
}

