/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBasicNodeTable
extends AbstractTableModel {
    protected ArrayList<CbusNode> _mainArray = new ArrayList();
    protected final CanSystemConnectionMemo _memo;
    public static final int NODE_NUMBER_COLUMN = 0;
    public static final int NODE_TYPE_NAME_COLUMN = 1;
    public static final int NODE_USER_NAME_COLUMN = 2;
    public static final int NODE_RESYNC_BUTTON_COLUMN = 3;
    public static final int COMMAND_STAT_NUMBER_COLUMN = 4;
    public static final int CANID_COLUMN = 5;
    public static final int NODE_EVENTS_COLUMN = 6;
    public static final int BYTES_REMAINING_COLUMN = 7;
    public static final int NODE_TOTAL_BYTES_COLUMN = 8;
    public static final int NODE_IN_LEARN_MODE_COLUMN = 9;
    public static final int NODE_EVENT_INDEX_VALID_COLUMN = 10;
    public static final int SESSION_BACKUP_STATUS_COLUMN = 11;
    public static final int NUMBER_BACKUPS_COLUMN = 12;
    public static final int LAST_BACKUP_COLUMN = 13;
    public static final int MAX_COLUMN = 14;
    public static final String[] COLUMNTOOLTIPS;
    private static final Logger log;

    static {
        String[] stringArray = new String[14];
        stringArray[10] = "Index invalid when an event addition or deletion has taken place since last fetch.";
        stringArray[11] = "Session Backup Status";
        stringArray[12] = "Total backups in xml file";
        COLUMNTOOLTIPS = stringArray;
        log = LoggerFactory.getLogger(CbusBasicNodeTable.class);
    }

    public CbusBasicNodeTable(@Nonnull CanSystemConnectionMemo memo, int row, int column) {
        this._memo = memo;
    }

    @Override
    public int getRowCount() {
        if (this._mainArray == null) {
            log.error("Node Table Array _mainArray not initialised");
            return 0;
        }
        return this._mainArray.size();
    }

    @Override
    public int getColumnCount() {
        return 14;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 5: {
                return Bundle.getMessage("CanID");
            }
            case 0: {
                return Bundle.getMessage("NodeNumberCol");
            }
            case 2: {
                return Bundle.getMessage("UserName");
            }
            case 3: {
                return Bundle.getMessage("ReSynchronizeButton");
            }
            case 1: {
                return Bundle.getMessage("ColumnType");
            }
            case 4: {
                return Bundle.getMessage("CommandStationNumber");
            }
            case 6: {
                return Bundle.getMessage("CbusEvents");
            }
            case 8: {
                return Bundle.getMessage("TotalBytes");
            }
            case 7: {
                return Bundle.getMessage("FetchProgress");
            }
            case 9: {
                return Bundle.getMessage("LearnMode");
            }
            case 10: {
                return Bundle.getMessage("EventIndexValid");
            }
            case 11: {
                return "Backup Status";
            }
            case 12: {
                return "Num. Backups";
            }
            case 13: {
                return "Last Backup";
            }
        }
        return "unknown " + col;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (this._mainArray.isEmpty() || this.getValueAt(0, col) == null) {
            return Object.class;
        }
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2 || col == 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this._mainArray.get(row).getNodeNumber();
            }
            case 2: {
                return this._mainArray.get(row).getUserName();
            }
            case 1: {
                return this._mainArray.get(row).getNodeStats().getNodeTypeName();
            }
            case 5: {
                return this._mainArray.get(row).getNodeCanId();
            }
            case 4: {
                return this._mainArray.get(row).getCsNum();
            }
            case 6: {
                return this._mainArray.get(row).getNodeEventManager().getTotalNodeEvents();
            }
            case 8: {
                return this._mainArray.get(row).getNodeStats().totalNodeBytes();
            }
            case 7: {
                return Float.valueOf(this._mainArray.get(row).getNodeStats().floatPercentageRemaining());
            }
            case 9: {
                return this._mainArray.get(row).getNodeInLearnMode();
            }
            case 3: {
                return "Re-Sync";
            }
            case 10: {
                return this._mainArray.get(row).getNodeEventManager().isEventIndexValid();
            }
            case 11: {
                return this._mainArray.get(row).getNodeBackupManager().getSessionBackupStatus();
            }
            case 12: {
                return this._mainArray.get(row).getNodeBackupManager().getNumCompleteBackups();
            }
            case 13: {
                return this._mainArray.get(row).getNodeBackupManager().getLastBackupTime();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 2: {
                this._mainArray.get(row).setUserName((String)value);
                ThreadingUtil.runOnGUI(() -> this.fireTableCellUpdated(row, col));
                break;
            }
            case 3: {
                this._mainArray.get(row).saveForResync();
                this._mainArray.get(row).resetNodeAll();
                if (!(this instanceof CbusNodeTableDataModel)) break;
                ((CbusNodeTableDataModel)this).setUrgentNode(this._mainArray.get(row).getNodeNumber());
                ((CbusNodeTableDataModel)this).startBackgroundFetch();
                break;
            }
            default: {
                log.debug("invalid column");
            }
        }
    }
}

