/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.TimerTask;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import jmri.InstanceManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusSend;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTimerManager;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusAllocateNodeNumber
implements CanListener {
    private final CbusNodeTableDataModel nodeModel;
    private final CanSystemConnectionMemo _memo;
    private final CbusSend send;
    private JLabel rqNNtext;
    private int baseNodeNum;
    private boolean WAITINGRESPONSE_RQNN_PARAMS;
    private boolean NODE_NUM_DIALOGUE_OPEN;
    private boolean WAITING_RESPONSE_NAME;
    private int[] _paramsArr;
    private String _tempNodeName;
    private JLabel rqNNspinnerlabel;
    private int _timeout;
    protected TimerTask sendSNNTask;
    private static final Logger log = LoggerFactory.getLogger(CbusAllocateNodeNumber.class);

    public CbusAllocateNodeNumber(CanSystemConnectionMemo memo, CbusNodeTableDataModel model) {
        this.nodeModel = model;
        this._memo = memo;
        this.addTc(memo);
        this.send = new CbusSend(memo);
        this.baseNodeNum = 256;
        this._paramsArr = null;
        this.WAITINGRESPONSE_RQNN_PARAMS = false;
        this.NODE_NUM_DIALOGUE_OPEN = false;
        this.WAITING_RESPONSE_NAME = false;
        this._timeout = CbusNodeTimerManager.SINGLE_MESSAGE_TIMEOUT_TIME;
        this._tempNodeName = "";
    }

    private void startnodeallocation(int nn, String nodeText) {
        int option;
        String popuplabel;
        if (this.NODE_NUM_DIALOGUE_OPEN) {
            return;
        }
        this.NODE_NUM_DIALOGUE_OPEN = true;
        this._tempNodeName = "";
        JPanel rqNNpane = new JPanel();
        JPanel bottomrqNNpane = new JPanel();
        this.rqNNspinnerlabel = new JLabel(Bundle.getMessage("NdRqNnSelect"));
        bottomrqNNpane.setLayout(new GridLayout(2, 1));
        rqNNpane.setLayout(new BorderLayout());
        this.rqNNtext = new JLabel(Bundle.getMessage("NdRqNdDetails"));
        this.baseNodeNum = this.nodeModel.getNextAvailableNodeNumber(this.baseNodeNum);
        switch (nn) {
            case 0: {
                popuplabel = Bundle.getMessage("NdEntrSlimTitle");
                this._paramsArr = null;
                break;
            }
            case -1: {
                popuplabel = "Node found in Setup Mode";
                if (nodeText == null) break;
                this.rqNNtext.setText(nodeText);
                break;
            }
            default: {
                popuplabel = Bundle.getMessage("NdEntrNumTitle", String.valueOf(nn));
                this._paramsArr = null;
                this.baseNodeNum = nn;
            }
        }
        JSpinner rqnnSpinner = this.getNewRqnnSpinner();
        rqnnSpinner.firePropertyChange("open", false, true);
        rqNNpane.add((Component)this.rqNNtext, "Center");
        bottomrqNNpane.add(this.rqNNspinnerlabel);
        bottomrqNNpane.add(rqnnSpinner);
        rqNNpane.add((Component)bottomrqNNpane, "Last");
        Toolkit.getDefaultToolkit().beep();
        if (this._paramsArr == null) {
            this.WAITINGRESPONSE_RQNN_PARAMS = true;
            this.send.nodeRequestParamSetup();
        }
        if ((option = JOptionPane.showOptionDialog(null, rqNNpane, popuplabel, 2, 3, null, null, null)) == 0) {
            int newval;
            this.baseNodeNum = newval = ((Integer)rqnnSpinner.getValue()).intValue();
            this.setSendSNNTimeout();
            this.send.nodeSetNodeNumber(newval);
        }
        this.NODE_NUM_DIALOGUE_OPEN = false;
        this.WAITINGRESPONSE_RQNN_PARAMS = false;
    }

    private JSpinner getNewRqnnSpinner() {
        JSpinner rqnnSpinner = new JSpinner(new SpinnerNumberModel(this.baseNodeNum, 1, 65535, 1));
        rqnnSpinner.setToolTipText(Bundle.getMessage("ToolTipNodeNumber"));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(rqnnSpinner, "#");
        rqnnSpinner.setEditor(editor);
        JFormattedTextField rqfield = (JFormattedTextField)editor.getComponent(0);
        DefaultFormatter rqformatter = (DefaultFormatter)rqfield.getFormatter();
        rqformatter.setCommitsOnValidEdit(true);
        rqfield.setBackground(Color.white);
        rqnnSpinner.addChangeListener(e -> {
            int newval = (Integer)rqnnSpinner.getValue();
            if (!CbusNodeConstants.getReservedModule(newval).isEmpty()) {
                this.rqNNspinnerlabel.setText(CbusNodeConstants.getReservedModule(newval));
                rqfield.setBackground(Color.yellow);
            } else {
                this.rqNNspinnerlabel.setText(Bundle.getMessage("NdRqNnSelect"));
                rqfield.setBackground(Color.white);
            }
            if (!this.nodeModel.getNodeNumberName(newval).isEmpty()) {
                this.rqNNspinnerlabel.setText(Bundle.getMessage("NdNumInUse", this.nodeModel.getNodeNumberName(newval)));
                rqfield.setBackground(Color.red);
            }
        });
        return rqnnSpinner;
    }

    private void clearSendSNNTimeout() {
        if (this.sendSNNTask != null) {
            this.sendSNNTask.cancel();
            this.sendSNNTask = null;
        }
    }

    private void setSendSNNTimeout() {
        this.sendSNNTask = new TimerTask(){

            @Override
            public void run() {
                CbusAllocateNodeNumber.this.sendSNNTask = null;
                log.error("No confirmation from node when setting node number {}", (Object)CbusAllocateNodeNumber.this.baseNodeNum);
                JOptionPane.showMessageDialog(null, Bundle.getMessage("NnAllocError", CbusAllocateNodeNumber.this.baseNodeNum), Bundle.getMessage("WarningTitle"), 0);
                CbusAllocateNodeNumber.this.clearSendSNNTimeout();
            }
        };
        TimerUtil.schedule(this.sendSNNTask, this._timeout);
    }

    protected void setTimeout(int newVal) {
        this._timeout = newVal;
    }

    @Override
    public void message(CanMessage m) {
        if (m.extendedOrRtr()) {
            return;
        }
        if (CbusMessage.getOpcode(m) == 13 && !this.NODE_NUM_DIALOGUE_OPEN) {
            this.send.nodeRequestParamSetup();
        }
    }

    @Override
    public void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        ThreadingUtil.runOnGUIEventually(() -> this.processAllocateFrame(m));
    }

    private void processAllocateFrame(CanReply m) {
        switch (CbusMessage.getOpcode(m)) {
            case 80: {
                this.startnodeallocation(m.getElement(1) * 256 + m.getElement(2), null);
                break;
            }
            case 239: {
                this.processNodeParams(m);
                break;
            }
            case 82: {
                this.clearSendSNNTimeout();
                if (InstanceManager.getDefault(CbusPreferences.class).getAddNodes()) {
                    int nodeNum = m.getElement(1) * 256 + m.getElement(2);
                    this.nodeModel.setRequestNodeDisplay(nodeNum);
                    CbusNode nd = this.nodeModel.provideNodeByNodeNum(nodeNum);
                    nd.getCanListener().setParamsFromSetup(this._paramsArr);
                    nd.setNodeNameFromName(this._tempNodeName);
                    nd.resetNodeAll();
                    this.nodeModel.startUrgentFetch();
                    this.nodeModel.setRequestNodeDisplay(-1);
                    this.send.searchForCommandStations();
                }
                this._paramsArr = null;
                break;
            }
            case 226: {
                this.processNodeName(m);
                break;
            }
        }
    }

    private void processNodeParams(CanReply m) {
        this._paramsArr = new int[]{m.getElement(1), m.getElement(2), m.getElement(3), m.getElement(4), m.getElement(5), m.getElement(6), m.getElement(7)};
        StringBuilder nodepropbuilder = new StringBuilder(40);
        nodepropbuilder.append(CbusNodeConstants.getManu(this._paramsArr[0]));
        nodepropbuilder.append(" ");
        nodepropbuilder.append(CbusNodeConstants.getModuleType(this._paramsArr[0], this._paramsArr[2]));
        if (this.WAITINGRESPONSE_RQNN_PARAMS) {
            this.rqNNtext.setText(nodepropbuilder.toString());
            this.WAITINGRESPONSE_RQNN_PARAMS = false;
        } else if (!this.NODE_NUM_DIALOGUE_OPEN) {
            this.startnodeallocation(-1, nodepropbuilder.toString());
        }
        if (CbusNodeConstants.getModuleType(this._paramsArr[0], this._paramsArr[2]).isEmpty()) {
            this.WAITING_RESPONSE_NAME = true;
            this.send.rQmn();
        }
    }

    private void processNodeName(CanReply m) {
        if (this.WAITING_RESPONSE_NAME) {
            this.WAITING_RESPONSE_NAME = false;
            StringBuilder rval = new StringBuilder(10);
            rval.append("CAN");
            rval.append(String.format("%c", Character.valueOf((char)m.getElement(1))));
            rval.append(String.format("%c", Character.valueOf((char)m.getElement(2))));
            rval.append(String.format("%c", Character.valueOf((char)m.getElement(3))));
            rval.append(String.format("%c", Character.valueOf((char)m.getElement(4))));
            rval.append(String.format("%c", Character.valueOf((char)m.getElement(5))));
            rval.append(String.format("%c", Character.valueOf((char)m.getElement(6))));
            rval.append(String.format("%c", Character.valueOf((char)m.getElement(7))));
            this._tempNodeName = rval.toString().trim();
            StringBuilder nodepropbuilder = new StringBuilder(40);
            nodepropbuilder.append(CbusNodeConstants.getManu(this._paramsArr[0]));
            nodepropbuilder.append(" ");
            nodepropbuilder.append(this._tempNodeName);
            this.rqNNtext.setText(nodepropbuilder.toString());
        }
    }

    public void dispose() {
        this.clearSendSNNTimeout();
        this.removeTc(this._memo);
    }
}

