/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.util.ArrayList;
import java.util.Arrays;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.eventtable.Bundle;
import jmri.jmrix.can.cbus.eventtable.CbusBasicEventTableModel;
import jmri.jmrix.can.cbus.eventtable.CbusEventBeanData;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableShutdownTask;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableXmlAction;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventTableDataModel
extends CbusBasicEventTableModel
implements CanListener {
    private final CbusPreferences preferences;
    private final ShutDownTask shutDownTask;
    public static final String[] CBUS_EV_TABLE_COL_TOOLTIPS;
    private static final String[] COLUMN_NAMES;
    public static final int[] BUTTON_COLUMNS;
    private static final int[] EDITABLE_COLS;
    private static final Logger log;

    static {
        String[] stringArray = new String[28];
        stringArray[0] = Bundle.getMessage("NodeColTip");
        stringArray[1] = Bundle.getMessage("EventColTip");
        stringArray[2] = Bundle.getMessage("NameColTip");
        stringArray[3] = Bundle.getMessage("CbusNodeNameTip");
        stringArray[4] = Bundle.getMessage("CommentColTip");
        stringArray[5] = Bundle.getMessage("TypeColTip");
        stringArray[6] = Bundle.getMessage("SendToggleTip");
        stringArray[7] = Bundle.getMessage("SendOntip");
        stringArray[8] = Bundle.getMessage("SendOfftip");
        stringArray[9] = Bundle.getMessage("IDColTip");
        stringArray[10] = Bundle.getMessage("ColumnLastHeard");
        stringArray[11] = Bundle.getMessage("ColumnRequestStatusTip");
        stringArray[12] = Bundle.getMessage("ColumnTotalSession");
        stringArray[13] = Bundle.getMessage("ColumnOnSession");
        stringArray[14] = Bundle.getMessage("ColumnOffSession");
        stringArray[15] = Bundle.getMessage("ColumnInSessionTip");
        stringArray[16] = Bundle.getMessage("ColumnOutSessionTip");
        stringArray[22] = Bundle.getMessage("ColumnEventDeleteTip");
        stringArray[23] = Bundle.getMessage("StlrOnTip");
        stringArray[24] = Bundle.getMessage("StlrOffTip");
        CBUS_EV_TABLE_COL_TOOLTIPS = stringArray;
        COLUMN_NAMES = new String[]{"CbusNode", "CbusEvent", "ColumnName", "CbusNodeName", "ColumnComment", "CbusEventOnOrOff", "ColumnToggle", "CbusSendOnHeader", "CbusSendOffHeader", "CanID", "ColumnLastHeard", "ColumnStatusRequest", "ColumnTotalSession", "ColumnOnSession", "ColumnOffSession", "ColumnInSession", "ColumnOutSession", "ColumnTotalAll", "ColumnTotalOn", "ColumnTotalOff", "ColumnTotalIn", "ColumnTotalOut", "ColumnEventDelete", "JmriOnEv", "JmriOffEv", "Dat1", "Dat2", "Dat3"};
        BUTTON_COLUMNS = new int[]{6, 7, 8, 11, 22};
        EDITABLE_COLS = new int[]{2, 4, 6, 7, 8, 11, 22};
        log = LoggerFactory.getLogger(CbusEventTableDataModel.class);
    }

    public CbusEventTableDataModel(CanSystemConnectionMemo memo, int row, int column) {
        super(memo);
        log.info("Starting MERG CBUS Event Table");
        this.addTc(this._memo);
        this.preferences = InstanceManager.getNullableDefault(CbusPreferences.class);
        this.checkRestoreEvents();
        this.shutDownTask = new CbusEventTableShutdownTask("CbusEventTableShutdownTask", this);
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        this.ta.updatejmricols();
    }

    public static final void checkCreateNewEventModel(CanSystemConnectionMemo memo) {
        CbusEventTableDataModel model = InstanceManager.getNullableDefault(CbusEventTableDataModel.class);
        if (model == null) {
            ThreadingUtil.runOnLayout(() -> {
                CbusEventTableDataModel eventModel = new CbusEventTableDataModel(memo, 5, 28);
                InstanceManager.store(eventModel, CbusEventTableDataModel.class);
            });
        }
    }

    private void checkRestoreEvents() {
        if (this.preferences != null && this.preferences.getSaveRestoreEventTable()) {
            CbusEventTableXmlAction.restoreEventsFromXmlTablestart(this);
        }
    }

    public void skipSaveOnDispose() {
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
    }

    @Override
    public String getColumnName(int col) {
        return Bundle.getMessage(COLUMN_NAMES[col]);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (this._mainArray.isEmpty() || this.getValueAt(0, col) == null) {
            return Object.class;
        }
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return Arrays.stream(EDITABLE_COLS).anyMatch(i -> i == col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 22) {
            ThreadingUtil.runOnGUIEventually(() -> this.ta.buttonDeleteClicked(row));
        } else {
            super.setValueAt(value, row, col);
        }
    }

    @Override
    public void message(CanMessage m) {
        this.ta.parseMessage(m);
    }

    @Override
    public void reply(CanReply m) {
        this.ta.parseMessage(m);
    }

    protected void clearAllEvents() {
        this._mainArray = new ArrayList();
    }

    public CbusEventBeanData getEventBeans(int nn, int en, CbusEventDataElements.EvState state) {
        return this.provideEvent(nn, en).getBeans(state);
    }

    public void dispose() {
        this.ta.dispose();
        if (this.preferences != null && this.preferences.getSaveRestoreEventTable()) {
            CbusEventTableXmlAction.storeEventsToXml(this);
        }
        this.removeTc(this._memo);
    }
}

