/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusEventInterface;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.eventtable.Bundle;
import jmri.jmrix.can.cbus.eventtable.CbusBasicEventTableModel;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.eventtable.CbusTableEvent;
import jmri.util.ThreadingUtil;

public class CbusEventTableAction
implements PropertyChangeListener {
    private final CbusBasicEventTableModel _model;
    protected boolean sessionConfirmDeleteRow = true;
    private final Class<?>[] classTypes = new Class[]{TurnoutManager.class, SensorManager.class, LightManager.class};

    public CbusEventTableAction(@Nonnull CbusBasicEventTableModel model) {
        this._model = model;
        this.addRemoveListenersToNbManagers(true);
    }

    private void linkHwaddtoEvent(NamedBean bean, boolean beanState, CanMessage m) {
        if (m == null) {
            return;
        }
        int en = CbusMessage.getEvent(m);
        int nn = CbusMessage.getNodeNumber(m);
        CbusTableEvent event = this._model.provideEvent(nn, en);
        event.appendOnOffBean(bean, beanState, CbusEvent.getEvState(m));
        this.fireJmriCellsChanged(this._model.getEventTableRow(nn, en));
    }

    private void fireJmriCellsChanged(int row) {
        ThreadingUtil.runOnGUIEventually(() -> {
            this._model.fireTableCellUpdated(row, 23);
            this._model.fireTableCellUpdated(row, 24);
        });
    }

    private void fireAllJmriCellsChanged() {
        int i = 0;
        while (i < this._model.getRowCount()) {
            this.fireJmriCellsChanged(i);
            ++i;
        }
    }

    public void updatejmricols() {
        this._model._mainArray.forEach(n -> n.resetBeans());
        this.fireAllJmriCellsChanged();
        Class<?>[] classArray = this.classTypes;
        int n2 = this.classTypes.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> classType = classArray[n3];
            Manager sm = (Manager)InstanceManager.getDefault(classType);
            sm.getNamedBeanSet().forEach(nb -> {
                if (nb instanceof CbusEventInterface) {
                    this.linkHwaddtoEvent((NamedBean)nb, true, ((CbusEventInterface)nb).getBeanOnMessage());
                    this.linkHwaddtoEvent((NamedBean)nb, false, ((CbusEventInterface)nb).getBeanOffMessage());
                }
            });
            ++n3;
        }
    }

    public void resetAllSessionTotals() {
        this._model.getEvents().forEach(ev -> {
            ev.resetSessionTotals();
            this.updateStatColumnsinGui(this._model.getEventTableRow(ev.getNn(), ev.getEn()));
        });
    }

    protected final void addRemoveListenersToNbManagers(boolean add) {
        Class<?>[] classArray = this.classTypes;
        int n = this.classTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> classType = classArray[n2];
            if (add) {
                ((Manager)InstanceManager.getDefault(classType)).addPropertyChangeListener(this);
            } else {
                ((Manager)InstanceManager.getDefault(classType)).removePropertyChangeListener(this);
            }
            ++n2;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.updatejmricols();
    }

    public void buttonDeleteClicked(int row) {
        if (this.sessionConfirmDeleteRow) {
            ThreadingUtil.runOnGUI(() -> {
                JCheckBox checkbox = new JCheckBox(Bundle.getMessage("PopupSessionConfirmDel"));
                String message = String.valueOf(Bundle.getMessage("DelConfirmOne")) + "\n" + Bundle.getMessage("DelConfirmTwo");
                Object[] params = new Object[]{message, checkbox};
                if (JOptionPane.showConfirmDialog(null, params, Bundle.getMessage("DelEvPopTitle"), 2, 2) == 0) {
                    this.sessionConfirmDeleteRow = !checkbox.isSelected();
                    this.removeRow(row);
                }
            });
        } else {
            this.removeRow(row);
        }
    }

    protected void removeRow(int row) {
        this._model._mainArray.remove(row);
        ThreadingUtil.runOnGUIEventually(() -> this._model.fireTableRowsDeleted(row, row));
    }

    protected void updateGuiCell(int row, int col) {
        ThreadingUtil.runOnGUIEventually(() -> this._model.fireTableCellUpdated(row, col));
    }

    private void updateStatColumnsinGui(int row) {
        int[] nArray = CbusEventTableDataModel.canFrameCols;
        int n = CbusEventTableDataModel.canFrameCols.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.updateGuiCell(row, i);
            ++n2;
        }
    }

    protected void parseMessage(AbstractMessage m) {
        if (!CbusMessage.isEvent(m)) {
            return;
        }
        CbusTableEvent ev = this._model.provideEvent(CbusMessage.getNodeNumber(m), CbusMessage.getEvent(m));
        ev.setState(CbusTableEvent.getEvState(m));
        ev.setCanId(CbusMessage.getId(m));
        ev.setDataFromFrame(m);
        ev.bumpDirection(m instanceof CanReply ? 1 : 2);
        this.updateStatColumnsinGui(this._model.getEventTableRow(CbusMessage.getNodeNumber(m), CbusMessage.getEvent(m)));
    }

    public void dispose() {
        this.addRemoveListenersToNbManagers(false);
    }
}

