/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.eventtable.Bundle;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableAction;
import jmri.jmrix.can.cbus.eventtable.CbusTableEvent;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBasicEventTableModel
extends AbstractTableModel {
    public static final int NODE_COLUMN = 0;
    public static final int EVENT_COLUMN = 1;
    public static final int NAME_COLUMN = 2;
    public static final int NODENAME_COLUMN = 3;
    public static final int COMMENT_COLUMN = 4;
    public static final int STATE_COLUMN = 5;
    public static final int TOGGLE_BUTTON_COLUMN = 6;
    public static final int ON_BUTTON_COLUMN = 7;
    public static final int OFF_BUTTON_COLUMN = 8;
    public static final int CANID_COLUMN = 9;
    public static final int LATEST_TIMESTAMP_COLUMN = 10;
    public static final int STATUS_REQUEST_BUTTON_COLUMN = 11;
    public static final int SESSION_TOTAL_COLUMN = 12;
    public static final int SESSION_ON_COLUMN = 13;
    public static final int SESSION_OFF_COLUMN = 14;
    public static final int SESSION_IN_COLUMN = 15;
    public static final int SESSION_OUT_COLUMN = 16;
    public static final int ALL_TOTAL_COLUMN = 17;
    public static final int ALL_ON_COLUMN = 18;
    public static final int ALL_OFF_COLUMN = 19;
    public static final int ALL_IN_COLUMN = 20;
    public static final int ALL_OUT_COLUMN = 21;
    public static final int DELETE_BUTTON_COLUMN = 22;
    public static final int STLR_ON_COLUMN = 23;
    public static final int STLR_OFF_COLUMN = 24;
    public static final int EVENT_DAT_1 = 25;
    public static final int EVENT_DAT_2 = 26;
    public static final int EVENT_DAT_3 = 27;
    public static final int MAX_COLUMN = 28;
    protected final CanSystemConnectionMemo _memo;
    protected ArrayList<CbusTableEvent> _mainArray;
    public final CbusEventTableAction ta;
    public static final int[] INITIAL_COLS;
    protected static final int[] canFrameCols;
    private static final Logger log;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 6;
        nArray[6] = 23;
        nArray[7] = 24;
        INITIAL_COLS = nArray;
        canFrameCols = new int[]{9, 10, 5, 6, 12, 15, 16, 14, 13, 17, 18, 19, 20, 21, 25, 26, 27};
        log = LoggerFactory.getLogger(CbusBasicEventTableModel.class);
    }

    public CbusBasicEventTableModel(CanSystemConnectionMemo memo) {
        this._memo = memo;
        this._mainArray = new ArrayList();
        this.ta = new CbusEventTableAction(this);
    }

    @Override
    public int getColumnCount() {
        return 28;
    }

    @Override
    public int getRowCount() {
        return this._mainArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this._mainArray.get(row).getNn();
            }
            case 1: {
                return this._mainArray.get(row).getEn();
            }
            case 2: {
                return this._mainArray.get(row).getName();
            }
            case 3: {
                return new CbusNameService(this._memo).getNodeName(this._mainArray.get(row).getNn());
            }
            case 4: {
                return this._mainArray.get(row).getComment();
            }
            case 5: {
                return this._mainArray.get(row).getState();
            }
        }
        return this.getValueAtPt2(row, col);
    }

    private Object getValueAtPt2(int row, int col) {
        switch (col) {
            case 6: {
                if (this._mainArray.get(row).getState() == CbusEventDataElements.EvState.OFF) {
                    return Bundle.getMessage("CbusSendOn");
                }
                return Bundle.getMessage("CbusSendOff");
            }
            case 7: {
                return Bundle.getMessage("CbusSendOn");
            }
            case 8: {
                return Bundle.getMessage("CbusSendOff");
            }
            case 9: {
                return this._mainArray.get(row).getEventCanId();
            }
            case 10: {
                return this._mainArray.get(row).getDate();
            }
        }
        return this.getValueAtPt3(row, col);
    }

    private Object getValueAtPt3(int row, int col) {
        switch (col) {
            case 12: {
                return this._mainArray.get(row).getSessionOnOff(true) + this._mainArray.get(row).getSessionOnOff(false);
            }
            case 13: {
                return this._mainArray.get(row).getSessionOnOff(true);
            }
            case 14: {
                return this._mainArray.get(row).getSessionOnOff(false);
            }
            case 15: {
                return this._mainArray.get(row).getSessionInOut(true);
            }
            case 16: {
                return this._mainArray.get(row).getSessionInOut(false);
            }
        }
        return this.getValueAtPt4(row, col);
    }

    private Object getValueAtPt4(int row, int col) {
        switch (col) {
            case 17: {
                return this._mainArray.get(row).getTotalInOut(true) + this._mainArray.get(row).getTotalInOut(false);
            }
            case 18: {
                return this._mainArray.get(row).getTotalOnOff(true);
            }
            case 19: {
                return this._mainArray.get(row).getTotalOnOff(false);
            }
            case 20: {
                return this._mainArray.get(row).getTotalInOut(true);
            }
            case 21: {
                return this._mainArray.get(row).getTotalInOut(false);
            }
        }
        return this.getValueAtPt5(row, col);
    }

    private Object getValueAtPt5(int row, int col) {
        switch (col) {
            case 5: {
                return this._mainArray.get(row).getState();
            }
            case 11: {
                return Bundle.getMessage("StatusButton");
            }
            case 22: {
                return Bundle.getMessage("ButtonDelete");
            }
            case 23: {
                return this._mainArray.get(row).getBeans(CbusEventDataElements.EvState.ON);
            }
            case 24: {
                return this._mainArray.get(row).getBeans(CbusEventDataElements.EvState.OFF);
            }
        }
        return this.getValueAtPt6(row, col);
    }

    private Object getValueAtPt6(int row, int col) {
        switch (col) {
            case 25: {
                return this._mainArray.get(row).getData(1);
            }
            case 26: {
                return this._mainArray.get(row).getData(2);
            }
            case 27: {
                return this._mainArray.get(row).getData(3);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 2: {
                this._mainArray.get(row).setName((String)value);
                break;
            }
            case 4: {
                this._mainArray.get(row).setComment((String)value);
                break;
            }
            case 7: {
                this._mainArray.get(row).sendEvent(CbusEventDataElements.EvState.ON);
                break;
            }
            case 8: {
                this._mainArray.get(row).sendEvent(CbusEventDataElements.EvState.OFF);
                break;
            }
            default: {
                this.setValueAt2(value, row, col);
            }
        }
    }

    public void setValueAt2(Object value, int row, int col) {
        switch (col) {
            case 6: {
                this._mainArray.get(row).sendEvent(CbusEventDataElements.EvState.TOGGLE);
                this.ta.updateGuiCell(row, col);
                break;
            }
            case 11: {
                this._mainArray.get(row).sendEvent(CbusEventDataElements.EvState.REQUEST);
                break;
            }
            default: {
                log.error("Invalid Column {}", (Object)col);
            }
        }
    }

    @Nonnull
    public CbusTableEvent provideEvent(int nn, int en) {
        if (this.getEventTableRow(nn, en) > -1) {
            return this._mainArray.get(this.getEventTableRow(nn, en));
        }
        CbusTableEvent newtabev = new CbusTableEvent(this._memo, nn, en);
        this._mainArray.add(newtabev);
        ThreadingUtil.runOnGUIEventually(() -> this.fireTableDataChanged());
        return newtabev;
    }

    public int getEventTableRow(int node, int event) {
        return this._mainArray.indexOf(new CbusEvent(node, event));
    }

    @Nonnull
    public String getEventName(int node, int event) {
        int row = this.getEventTableRow(node, event);
        if (row > -1) {
            return this._mainArray.get(row).getName();
        }
        return "";
    }

    @Nonnull
    public String getEventString(int node, int event) {
        int row = this.getEventTableRow(node, event);
        if (row > -1) {
            return this._mainArray.get(row).toString();
        }
        return "";
    }

    @Nonnull
    public ArrayList<CbusTableEvent> getEvents() {
        return new ArrayList<CbusTableEvent>(this._mainArray);
    }
}

