/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.beans.PropertyChangeEvent;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusSensor;
import jmri.managers.AbstractSensorManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusSensorManager
extends AbstractSensorManager {
    private static final Logger log = LoggerFactory.getLogger(CbusSensorManager.class);

    public CbusSensorManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String newAddress;
        String addr = systemName.substring(this.getSystemNamePrefix().length());
        try {
            newAddress = CbusAddress.validateSysName(addr);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            throw e;
        }
        CbusSensor s = new CbusSensor(this.getSystemPrefix(), newAddress, ((CanSystemConnectionMemo)this.getMemo()).getTrafficController());
        s.setUserName(userName);
        return s;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String newAddress;
        try {
            this.validateSystemNamePrefix(String.valueOf(prefix) + this.typeLetter() + curAddress, Locale.getDefault());
            newAddress = CbusAddress.validateSysName(curAddress);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException(e.getMessage());
        }
        return String.valueOf(prefix) + this.typeLetter() + newAddress;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    protected String getIncrement(String curAddress, int increment) throws JmriException {
        return CbusAddress.getIncrement(curAddress);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        this.validateSystemNamePrefix(name, locale);
        try {
            name = CbusAddress.validateSysName(name.substring(this.getSystemNamePrefix().length()));
        }
        catch (IllegalArgumentException ex) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", ex.getMessage());
        }
        return String.valueOf(this.getSystemNamePrefix()) + name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        try {
            String addr = systemName.substring(this.getSystemNamePrefix().length());
            CbusAddress.validateSysName(addr);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException runtimeException) {
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    @Override
    public void updateAll() {
        log.info("Requesting status for all sensors");
        int i = 0;
        for (Sensor nb : this.getNamedBeanSet()) {
            if (!(nb instanceof CbusSensor)) continue;
            ThreadingUtil.runOnLayoutDelayed(() -> nb.requestUpdateFromLayout(), i * this.getMemo().getOutputInterval());
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("inverted")) {
            this.firePropertyChange("beaninverted", null, null);
        }
    }
}

