/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.implementation.AbstractRailComReporter;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusReporterManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusReporter
extends AbstractRailComReporter
implements CanListener {
    private final int _number;
    private final TrafficController tc;
    private final CanSystemConnectionMemo _memo;
    private boolean disposed = false;
    private static final Logger log = LoggerFactory.getLogger(CbusReporter.class);

    @Deprecated
    public CbusReporter(int number, TrafficController tco, String prefix) {
        super(String.valueOf(prefix) + "R" + number);
        this._number = number;
        this.tc = tco;
        this.addTc(this.tc);
        this._memo = null;
        log.debug("Added new reporter {}R{}", (Object)prefix, (Object)number);
        log.warn("Deprecated Constructor - Please use CbusReporter(String,CanSystemConnectionMemo,String) ");
    }

    public CbusReporter(String address, CanSystemConnectionMemo memo) {
        super(String.valueOf(memo.getSystemPrefix()) + "R" + address);
        this._number = Integer.parseInt(address);
        this._memo = memo;
        this.tc = memo.getTrafficController();
        this.addTc(memo.getTrafficController());
        log.debug("Added new reporter {}R{}", (Object)memo.getSystemPrefix(), (Object)address);
    }

    @Override
    public void setState(int s) {
        super.setState(s);
        if (this.getMaintainSensor()) {
            SensorManager sm = (SensorManager)this._memo.get(SensorManager.class);
            sm.provide("+" + this._number).setCommandedState(s == 3 ? 2 : 4);
        }
    }

    @Override
    public void notify(IdTag id) {
        if (this.getCurrentReport() != null && id != null) {
            super.notify(null);
        }
        super.notify(id);
    }

    @Override
    public void message(CanMessage m) {
        this.reply(new CanReply(m));
    }

    @Override
    public void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        if (m.getOpCode() != 250 && m.getOpCode() != 246) {
            return;
        }
        if ((m.getElement(1) << 8) + m.getElement(2) == this._number) {
            if (m.getOpCode() == 250 && !this.getCbusReporterType().equals("Classic RFID")) {
                this.ddesReport(m);
            } else {
                this.classicRFIDReport(m);
            }
        }
    }

    private void ddesReport(CanReply m) {
        int least_significant_bit = m.getElement(3) & 1;
        if (least_significant_bit == 0) {
            this.canRc522Report(m);
        } else {
            this.canRcomReport(m);
        }
    }

    private void classicRFIDReport(CanReply m) {
        String buf = this.toClassicTag(m.getElement(3), m.getElement(4), m.getElement(5), m.getElement(6), m.getElement(7));
        log.debug("Reporter {} {} RFID tag read of tag: {}", new Object[]{this, this.getCbusReporterType(), buf});
        IdTag tag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(buf);
        this.notify(tag);
        this.startTimeout(tag);
    }

    private void canRc522Report(CanReply m) {
        String tagId = String.valueOf((m.getElement(4) << 8) + m.getElement(5));
        log.debug("Reporter {} RFID tag read of tag: {}", (Object)this, (Object)tagId);
        IdTag tag = InstanceManager.getDefault(IdTagManager.class).provideIdTag("ID" + tagId);
        tag.setProperty("DDES Dat3", m.getElement(6));
        tag.setProperty("DDES Dat4", m.getElement(7));
        this.notify(tag);
        this.startTimeout(tag);
    }

    private void canRcomReport(CanReply m) {
        int railcom_id = m.getElement(3) >> 4;
        log.warn("CANRCOM support still in development.");
        log.info("{} detected RailCom ID {}", (Object)this, (Object)railcom_id);
    }

    private String toClassicTag(int b1, int b2, int b3, int b4, int b5) {
        return String.valueOf(String.format("%02X", b1)) + String.format("%02X", b2) + String.format("%02X", b3) + String.format("%02X", b4) + String.format("%02X", b5);
    }

    @Nonnull
    public String getCbusReporterType() {
        Object returnVal = this.getProperty("CBUS Reporter Type");
        return returnVal == null ? CbusReporterManager.CBUS_DEFAULT_REPORTER_TYPE : returnVal.toString();
    }

    public boolean getMaintainSensor() {
        Boolean returnVal = (Boolean)this.getProperty("Maintain CBUS Sensor");
        return returnVal == null ? false : returnVal;
    }

    private void startTimeout(IdTag tag) {
        int delay = this._memo == null ? 2000 : ((CbusReporterManager)this._memo.get(ReporterManager.class)).getTimeout();
        ThreadingUtil.runOnLayoutDelayed(() -> {
            if (!this.disposed && this.getCurrentReport() == tag) {
                this.notify(null);
            }
        }, delay);
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.tc.removeCanListener(this);
        super.dispose();
    }
}

