/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CbusProgrammer
extends AbstractProgrammer
implements CanListener,
AddressedProgrammer {
    TrafficController tc;
    int nodenumber;
    static final ProgrammingMode CBUSNODEVARMODE = new ProgrammingMode("CBUSNODEVARMODE", "CBUSNODEVARMODE");
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    boolean programmerReadOperation = false;
    int operationValue;
    int operationVariableNumber;
    private ProgListener programmerUser = null;
    private static final Logger log = LoggerFactory.getLogger(CbusProgrammer.class);

    public CbusProgrammer(int nodenumber, TrafficController tc) {
        this.nodenumber = nodenumber;
        this.LONG_TIMEOUT = 180000;
        this.tc = tc;
        this.setMode(CBUSNODEVARMODE);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(CBUSNODEVARMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int varnum = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("write {} listens {}", (Object)varnum, (Object)p);
        }
        this.useProgrammer(p);
        this.programmerReadOperation = false;
        this.progState = 0;
        this.operationValue = val;
        this.operationVariableNumber = varnum;
        int[] frame = new int[]{150, this.nodenumber / 256 & 0xFF, this.nodenumber & 0xFF, this.operationVariableNumber & 0xFF, this.operationValue & 0xFF};
        CanMessage m = new CanMessage(frame, this.tc.getCanid());
        this.tc.sendCanMessage(m, this);
        this.progState = 0;
        this.notifyProgListenerEnd(this.operationValue, 0);
    }

    @Override
    public synchronized void confirmCV(String varnum, int val, ProgListener p) throws ProgrammerException {
        this.readCV(varnum, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int varnum = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)varnum, (Object)p);
        }
        this.useProgrammer(p);
        this.programmerReadOperation = true;
        this.progState = 2;
        this.operationVariableNumber = varnum;
        this.startLongTimer();
        int[] frame = new int[]{113, this.nodenumber / 256 & 0xFF, this.nodenumber & 0xFF, this.operationVariableNumber & 0xFF};
        CanMessage m = new CanMessage(frame, this.tc.getCanid());
        this.tc.sendCanMessage(m, this);
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this.programmerUser != null && this.programmerUser != p) {
            if (log.isDebugEnabled()) {
                log.debug("programmer already in use by {}", (Object)this.programmerUser);
            }
            throw new ProgrammerException("programmer in use");
        }
        this.programmerUser = p;
    }

    @Override
    public void message(CanMessage m) {
        log.debug("message received and ignored: {}", (Object)m.toString());
    }

    @Override
    public synchronized void reply(CanReply m) {
        if (this.progState == 0) {
            if (log.isDebugEnabled()) {
                log.debug("reply in NOTPROGRAMMING state");
            }
            return;
        }
        if (this.progState == 2) {
            if (log.isDebugEnabled()) {
                log.debug("reply in COMMANDSENT state");
            }
            this.progState = 0;
            if (m.getElement(0) == 151 && m.getElement(1) == (this.nodenumber / 256 & 0xFF) && m.getElement(2) == (this.nodenumber & 0xFF)) {
                if (this.programmerReadOperation) {
                    this.operationValue = m.getElement(3) & 0xFF;
                }
                this.notifyProgListenerEnd(this.operationValue, 0);
            }
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this.operationValue, 128);
        }
    }

    @Override
    public boolean getLongAddress() {
        return false;
    }

    @Override
    public int getAddressNumber() {
        return this.nodenumber;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    void cleanup() {
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this.programmerUser;
        this.programmerUser = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

