/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jmri.beans.PreferencesBean;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusPreferences
extends PreferencesBean {
    private boolean _addCommandStations = false;
    private boolean _addNodes = false;
    private boolean _allocateNnListener = true;
    private long _nodeBackgroundFetchDelay = 100L;
    private boolean _startupSearchForCs = false;
    private boolean _startupSearchForNodes = false;
    private boolean searchForNodesBackupXmlOnStartup = false;
    private boolean _saveRestoreEventTable = true;
    private int minimumNumBackupsToKeep = 10;
    private int bootWriteDelay = CbusNode.BOOT_PROG_TIMEOUT_FAST;
    private boolean _isGlobalProgrammerAvailable = true;
    private boolean _isAddressedModePossible = true;
    private int _progTrackMode = 0;
    private int _nodeTableSplit = 100;
    private static final Logger log = LoggerFactory.getLogger(CbusPreferences.class);

    public CbusPreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this._addCommandStations = sharedPreferences.getBoolean("_addCommandStations", this.getAddCommandStations());
        this._addNodes = sharedPreferences.getBoolean("_addNodes", this.getAddNodes());
        this._allocateNnListener = sharedPreferences.getBoolean("_allocateNnListener", this.getAllocateNNListener());
        this._nodeBackgroundFetchDelay = sharedPreferences.getLong("_nodeBgFetchDelay", this.getNodeBackgroundFetchDelay());
        this._startupSearchForCs = sharedPreferences.getBoolean("_startupSearchForCs", this.getStartupSearchForCs());
        this._startupSearchForNodes = sharedPreferences.getBoolean("_startupSearchForNodes", this.getStartupSearchForNodes());
        this.searchForNodesBackupXmlOnStartup = sharedPreferences.getBoolean("searchForNodesBackupXmlOnStartup", this.getSearchForNodesBackupXmlOnStartup());
        this.minimumNumBackupsToKeep = sharedPreferences.getInt("minimumNumBackupsToKeep", this.getMinimumNumBackupsToKeep());
        this.bootWriteDelay = sharedPreferences.getInt("bootWriteDelay", this.getBootWriteDelay());
        this._saveRestoreEventTable = sharedPreferences.getBoolean("saveRestoreEventTable", this.getSaveRestoreEventTable());
        this._isGlobalProgrammerAvailable = sharedPreferences.getBoolean("globalprogrammer", this.isGlobalProgrammerAvailable());
        this._isAddressedModePossible = sharedPreferences.getBoolean("addressedprogrammer", this.isAddressedModePossible());
        this._progTrackMode = sharedPreferences.getInt("progtrackmode", this.getProgTrackMode());
        this._nodeTableSplit = sharedPreferences.getInt("nodetablesplit", this.getNodeTableSplit());
    }

    public void savePreferences() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putBoolean("_addCommandStations", this.getAddCommandStations());
        sharedPreferences.putBoolean("_addNodes", this.getAddNodes());
        sharedPreferences.putBoolean("_allocateNnListener", this.getAllocateNNListener());
        sharedPreferences.putLong("_nodeBgFetchDelay", this.getNodeBackgroundFetchDelay());
        sharedPreferences.putBoolean("_startupSearchForCs", this.getStartupSearchForCs());
        sharedPreferences.putBoolean("_startupSearchForNodes", this.getStartupSearchForNodes());
        sharedPreferences.putBoolean("searchForNodesBackupXmlOnStartup", this.getSearchForNodesBackupXmlOnStartup());
        sharedPreferences.putInt("minimumNumBackupsToKeep", this.getMinimumNumBackupsToKeep());
        sharedPreferences.putInt("bootWriteDelay", this.getBootWriteDelay());
        sharedPreferences.putBoolean("saveRestoreEventTable", this.getSaveRestoreEventTable());
        sharedPreferences.putBoolean("globalprogrammer", this.isGlobalProgrammerAvailable());
        sharedPreferences.putBoolean("addressedprogrammer", this.isAddressedModePossible());
        sharedPreferences.putInt("progtrackmode", this.getProgTrackMode());
        sharedPreferences.putInt("nodetablesplit", this.getNodeTableSplit());
        try {
            sharedPreferences.sync();
            log.debug("Updated Cbus Preferences");
        }
        catch (BackingStoreException ex) {
            log.error("Exception while saving preferences", (Throwable)ex);
        }
    }

    boolean isPreferencesValid() {
        return true;
    }

    public boolean getAddCommandStations() {
        return this._addCommandStations;
    }

    public void setAddCommandStations(boolean newVal) {
        this._addCommandStations = newVal;
        this.savePreferences();
    }

    public boolean getAddNodes() {
        return this._addNodes;
    }

    public void setAddNodes(boolean newVal) {
        this._addNodes = newVal;
        this.savePreferences();
    }

    public boolean getAllocateNNListener() {
        return this._allocateNnListener;
    }

    public void setAllocateNNListener(boolean newVal) {
        this._allocateNnListener = newVal;
        this.savePreferences();
    }

    public long getNodeBackgroundFetchDelay() {
        return this._nodeBackgroundFetchDelay;
    }

    public void setNodeBackgroundFetchDelay(long newVal) {
        this._nodeBackgroundFetchDelay = newVal;
        this.savePreferences();
    }

    public boolean getStartupSearchForCs() {
        return this._startupSearchForCs;
    }

    public void setStartupSearchForCs(boolean newVal) {
        this._startupSearchForCs = newVal;
        this.savePreferences();
    }

    public boolean getStartupSearchForNodes() {
        return this._startupSearchForNodes;
    }

    public void setStartupSearchForNodes(boolean newVal) {
        this._startupSearchForNodes = newVal;
        this.savePreferences();
    }

    public boolean getSaveRestoreEventTable() {
        return this._saveRestoreEventTable;
    }

    public void setSaveRestoreEventTable(boolean newVal) {
        this._saveRestoreEventTable = newVal;
        this.savePreferences();
    }

    public boolean getSearchForNodesBackupXmlOnStartup() {
        return this.searchForNodesBackupXmlOnStartup;
    }

    public void setSearchForNodesBackupXmlOnStartup(boolean newVal) {
        this.searchForNodesBackupXmlOnStartup = newVal;
        this.savePreferences();
    }

    public int getMinimumNumBackupsToKeep() {
        return this.minimumNumBackupsToKeep;
    }

    public void setMinimumNumBackupsToKeep(int newVal) {
        this.minimumNumBackupsToKeep = newVal;
        this.savePreferences();
    }

    public int getBootWriteDelay() {
        return this.bootWriteDelay;
    }

    public void setBootWriteDelay(int newVal) {
        this.bootWriteDelay = newVal;
        this.savePreferences();
    }

    public boolean isGlobalProgrammerAvailable() {
        return this._isGlobalProgrammerAvailable;
    }

    public boolean isAddressedModePossible() {
        return this._isAddressedModePossible;
    }

    public void setGlobalProgrammerAvailable(boolean state) {
        this._isGlobalProgrammerAvailable = state;
        this.savePreferences();
    }

    public void setAddressedModePossible(boolean state) {
        this._isAddressedModePossible = state;
        this.savePreferences();
    }

    public void setProgrammersAvailable(boolean global, boolean addressed) {
        this.setGlobalProgrammerAvailable(global);
        this.setAddressedModePossible(addressed);
    }

    public int getProgTrackMode() {
        return this._progTrackMode;
    }

    public void setProgTrackMode(int mode) {
        this._progTrackMode = mode;
        this.savePreferences();
    }

    public int getNodeTableSplit() {
        return this._nodeTableSplit;
    }

    public void setNodeTableSplit(int pixels) {
        this._nodeTableSplit = pixels;
        this.savePreferences();
    }
}

