/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Meter;
import jmri.MeterManager;
import jmri.implementation.DefaultMeter;
import jmri.implementation.MeterUpdateTask;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusPredefinedMeters
implements CanListener {
    private final TrafficController tc;
    private int _nodeToListen;
    private int _eventToListenCurrent;
    private int _eventToListenCurrentExtra;
    private int _eventToListenVoltage;
    private final CanSystemConnectionMemo _memo;
    final MeterUpdateTask updateTask;
    final Meter currentMeter;
    final Meter currentMeterExtra;
    final Meter voltageMeter;
    private static final Logger log = LoggerFactory.getLogger(CbusPredefinedMeters.class);

    public CbusPredefinedMeters(CanSystemConnectionMemo memo) {
        this.tc = memo.getTrafficController();
        this._memo = memo;
        this.updateTask = new UpdateTask(-1);
        this.currentMeter = new DefaultMeter.DefaultCurrentMeter(String.valueOf(memo.getSystemPrefix()) + InstanceManager.getDefault(MeterManager.class).typeLetter() + "CBUSCurrentMeter", Meter.Unit.Milli, 0.0, 65535.0, 1.0, this.updateTask);
        this.currentMeterExtra = new DefaultMeter.DefaultCurrentMeter(String.valueOf(memo.getSystemPrefix()) + InstanceManager.getDefault(MeterManager.class).typeLetter() + "CBUSCurrentMeter2", Meter.Unit.Milli, 0.0, 65535.0, 1.0, this.updateTask);
        this.voltageMeter = new DefaultMeter.DefaultVoltageMeter(String.valueOf(memo.getSystemPrefix()) + InstanceManager.getDefault(MeterManager.class).typeLetter() + "CBUSVoltageMeter", Meter.Unit.NoPrefix, 0.0, 6553.5, 0.1, this.updateTask);
        InstanceManager.getDefault(MeterManager.class).register(this.currentMeter);
        InstanceManager.getDefault(MeterManager.class).register(this.currentMeterExtra);
        InstanceManager.getDefault(MeterManager.class).register(this.voltageMeter);
        log.debug("CbusMultiMeter constructor called");
    }

    @Override
    public void reply(CanReply r) {
        if (r.extendedOrRtr() || CbusMessage.getOpcode(r) != 208 || CbusMessage.getNodeNumber(r) != this._nodeToListen || CbusMessage.getEvent(r) != this._eventToListenCurrent && CbusMessage.getEvent(r) != this._eventToListenVoltage && CbusMessage.getEvent(r) != this._eventToListenCurrentExtra) {
            return;
        }
        try {
            if (CbusMessage.getEvent(r) == this._eventToListenCurrent) {
                int currentInt = r.getElement(5) * 256 + r.getElement(6);
                this.currentMeter.setCommandedAnalogValue((float)currentInt * 1.0f);
            } else if (CbusMessage.getEvent(r) == this._eventToListenCurrentExtra) {
                int currentInt = r.getElement(5) * 256 + r.getElement(6);
                this.currentMeterExtra.setCommandedAnalogValue((float)currentInt * 1.0f);
            } else {
                int voltageInt = r.getElement(5) * 256 + r.getElement(6);
                this.voltageMeter.setCommandedAnalogValue((float)voltageInt / 10.0f);
            }
        }
        catch (JmriException e) {
            log.error("exception thrown by setCurrent or setVoltage", (Throwable)e);
        }
    }

    @Override
    public void message(CanMessage m) {
    }

    public void dispose() {
        this.updateTask.disable(this.currentMeter);
        this.updateTask.disable(this.currentMeterExtra);
        this.updateTask.disable(this.voltageMeter);
        InstanceManager.getDefault(MeterManager.class).deregister(this.currentMeter);
        InstanceManager.getDefault(MeterManager.class).deregister(this.currentMeterExtra);
        InstanceManager.getDefault(MeterManager.class).deregister(this.voltageMeter);
        this.updateTask.dispose(this.currentMeter);
        this.updateTask.dispose(this.currentMeterExtra);
        this.updateTask.dispose(this.voltageMeter);
    }

    private class UpdateTask
    extends MeterUpdateTask {
        public UpdateTask(int interval) {
            super(interval);
        }

        @Override
        public void enable() {
            CbusPredefinedMeters.this._nodeToListen = 65534;
            CbusPredefinedMeters.this._eventToListenCurrent = 1;
            CbusPredefinedMeters.this._eventToListenVoltage = 2;
            CbusPredefinedMeters.this._eventToListenCurrentExtra = 3;
            CbusNodeTableDataModel cs = InstanceManager.getNullableDefault(CbusNodeTableDataModel.class);
            if (cs != null) {
                CbusNode csnode = cs.getCsByNum(0);
                if (csnode != null) {
                    CbusPredefinedMeters.this._nodeToListen = csnode.getNodeNumber();
                }
            } else {
                log.info("Unable to fetch Master Command Station from Node Manager");
            }
            CbusPredefinedMeters.this.tc.addCanListener(CbusPredefinedMeters.this);
            log.info("Enabled meter Long Ex2Data {} {} {}", new Object[]{new CbusNameService(CbusPredefinedMeters.this._memo).getEventNodeString(CbusPredefinedMeters.this._nodeToListen, CbusPredefinedMeters.this._eventToListenCurrent), new CbusNameService(CbusPredefinedMeters.this._memo).getEventNodeString(CbusPredefinedMeters.this._nodeToListen, CbusPredefinedMeters.this._eventToListenVoltage), new CbusNameService(CbusPredefinedMeters.this._memo).getEventNodeString(CbusPredefinedMeters.this._nodeToListen, CbusPredefinedMeters.this._eventToListenCurrentExtra)});
            super.enable();
        }

        @Override
        public void disable() {
            super.disable();
            CbusPredefinedMeters.this.tc.removeCanListener(CbusPredefinedMeters.this);
            log.info("Disabled meter.");
        }

        @Override
        public void requestUpdateFromLayout() {
        }
    }
}

