/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jmri.DccLocoAddress;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanFrame;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusClockControl;
import jmri.jmrix.can.cbus.CbusFilterType;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.util.FileUtil;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CbusOpCodes {
    private static final Logger log = LoggerFactory.getLogger(CbusOpCodes.class);
    private static final Map<Integer, CbusOpc> MAP = CbusOpCodes.createMainMap();

    @Nonnull
    public static final String fullDecode(AbstractMessage msg) {
        StringBuilder buf = new StringBuilder();
        String[] fields = CbusOpCodes.MAP.getOrDefault(msg.getElement(0), CbusOpCodes.getDefaultOpc()).getDecode().split(",");
        int idx = 1;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].startsWith("%")) {
                int value = 0;
                int bytes = Integer.parseInt(fields[i].substring(1, 2));
                while (bytes > 0) {
                    value = value * 256 + msg.getElement(idx++);
                    --bytes;
                }
                fields[i] = String.valueOf(value);
            } else if (fields[i].startsWith("^2")) {
                fields[i] = CbusOpCodes.locoFromBytes(msg.getElement(idx++), msg.getElement(idx++));
            } else if (fields[i].startsWith("$4")) {
                int nn = 256 * msg.getElement(idx++) + msg.getElement(idx++);
                int en = 256 * msg.getElement(idx++) + msg.getElement(idx++);
                fields[i] = new CbusNameService().getEventNodeString(nn, en);
            } else if (fields[i].startsWith("$2")) {
                int nodenum = 256 * msg.getElement(idx++) + msg.getElement(idx++);
                fields[i] = "NN:" + nodenum + " " + new CbusNameService().getNodeName(nodenum);
            }
            buf.append(fields[i]);
            ++i;
        }
        switch (msg.getElement(0)) {
            case 99: {
                buf.append(CbusOpCodes.getCbusErr(msg));
                break;
            }
            case 111: {
                if (msg.getElement(3) <= 0 || msg.getElement(3) >= 13) break;
                buf.append(Bundle.getMessage("CMDERR" + msg.getElement(3)));
                break;
            }
            case 97: {
                CbusOpCodes.appendGloc(msg, buf);
                break;
            }
            case 207: {
                return CbusClockControl.dateFromCanFrame(msg);
            }
        }
        return buf.toString();
    }

    private static void appendGloc(AbstractMessage msg, StringBuilder buf) {
        buf.append(" ");
        if ((msg.getElement(3) & 1) == 1 && (msg.getElement(3) >> 1 & 1) == 1) {
            buf.append(Bundle.getMessage("invalidFlags"));
        } else if ((msg.getElement(3) & 1) == 1) {
            buf.append(Bundle.getMessage("stealRequest"));
        } else if ((msg.getElement(3) >> 1 & 1) == 1) {
            buf.append(Bundle.getMessage("shareRequest"));
        } else {
            buf.append(Bundle.getMessage("standardRequest"));
        }
    }

    @Nonnull
    public static final String getCbusErr(AbstractMessage msg) {
        StringBuilder buf = new StringBuilder();
        switch (msg.getElement(3)) {
            case 1: {
                buf.append(Bundle.getMessage("ERR_LOCO_STACK_FULL")).append(CbusOpCodes.locoFromBytes(msg.getElement(1), msg.getElement(2)));
                break;
            }
            case 2: {
                buf.append(Bundle.getMessage("ERR_LOCO_ADDRESS_TAKEN", CbusOpCodes.locoFromBytes(msg.getElement(1), msg.getElement(2))));
                break;
            }
            case 3: {
                buf.append(Bundle.getMessage("ERR_SESSION_NOT_PRESENT", msg.getElement(1)));
                break;
            }
            case 4: {
                buf.append(Bundle.getMessage("ERR_CONSIST_EMPTY")).append(msg.getElement(1));
                break;
            }
            case 5: {
                buf.append(Bundle.getMessage("ERR_LOCO_NOT_FOUND")).append(msg.getElement(1));
                break;
            }
            case 6: {
                buf.append(Bundle.getMessage("ERR_CAN_BUS_ERROR"));
                break;
            }
            case 7: {
                buf.append(Bundle.getMessage("ERR_INVALID_REQUEST")).append(CbusOpCodes.locoFromBytes(msg.getElement(1), msg.getElement(2)));
                break;
            }
            case 8: {
                buf.append(Bundle.getMessage("ERR_SESSION_CANCELLED", msg.getElement(1)));
                break;
            }
        }
        return buf.toString();
    }

    @Nonnull
    public static final String locoFromBytes(int byteA, int byteB) {
        return new DccLocoAddress((byteA & 0x3F) * 256 + byteB, (byteA & 0xC0) != 0).toString();
    }

    @Nonnull
    public static final String decode(AbstractMessage msg) {
        if (msg instanceof CanFrame) {
            if (!((CanFrame)((Object)msg)).isExtended()) {
                return CbusOpCodes.fullDecode(msg);
            }
            return CbusOpCodes.decodeExtended((CanFrame)((Object)msg));
        }
        return "";
    }

    @Nonnull
    public static final String decodeExtended(CanFrame msg) {
        StringBuilder sb = new StringBuilder(Bundle.getMessage("decodeBootloader"));
        block0 : switch (msg.getHeader()) {
            case 4: {
                switch (msg.getElement(5)) {
                    case 0: {
                        sb.append(Bundle.getMessage("decodeCBUS_BOOT_NOP"));
                        break block0;
                    }
                    case 1: {
                        sb.append(Bundle.getMessage("decodeCBUS_BOOT_RESET"));
                        break block0;
                    }
                    case 2: {
                        int newChecksum = msg.getElement(2) * 65536 + msg.getElement(1) * 256 + msg.getElement(0);
                        sb.append(Bundle.getMessage("decodeCBUS_BOOT_INIT", newChecksum));
                        break block0;
                    }
                    case 3: {
                        int newChecksum = msg.getElement(7) * 256 + msg.getElement(6);
                        sb.append(Bundle.getMessage("decodeCBUS_BOOT_CHECK", newChecksum));
                        break block0;
                    }
                    case 4: {
                        sb.append(Bundle.getMessage("decodeCBUS_BOOT_TEST"));
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                sb.append(Bundle.getMessage("OPC_DA")).append(" :");
                msg.appendHexElements(sb);
                break;
            }
            case 0x10000004: {
                switch (msg.getElement(0)) {
                    case 0: {
                        sb.append(Bundle.getMessage("decodeCBUS_EXT_BOOT_ERROR"));
                        break block0;
                    }
                    case 1: {
                        sb.append(Bundle.getMessage("decodeCBUS_EXT_BOOT_OK"));
                        break block0;
                    }
                    case 2: {
                        sb.append(Bundle.getMessage("decodeCBUS_EXT_BOOTC"));
                        break block0;
                    }
                }
                break;
            }
        }
        if (sb.toString().equals(Bundle.getMessage("decodeBootloader"))) {
            return Bundle.getMessage("decodeUnknownExtended");
        }
        return sb.toString();
    }

    @Nonnull
    public static final String decodeopcNonExtended(AbstractMessage msg) {
        return CbusOpCodes.MAP.getOrDefault(msg.getElement(0), CbusOpCodes.getDefaultOpc()).getName();
    }

    @Nonnull
    public static final String decodeopc(AbstractMessage msg) {
        if (msg instanceof CanFrame && !((CanFrame)((Object)msg)).extendedOrRtr()) {
            return CbusOpCodes.decodeopcNonExtended(msg);
        }
        return "";
    }

    public static final boolean isKnownOpc(AbstractMessage msg) {
        return MAP.get(msg.getElement(0)) != null && msg instanceof CanFrame && !((CanFrame)((Object)msg)).extendedOrRtr();
    }

    public static final boolean isEvent(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters().contains((Object)CbusFilterType.CFEVENT);
    }

    public static final boolean isEventNotRequest(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters().contains((Object)CbusFilterType.CFEVENT) && !CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters().contains((Object)CbusFilterType.CFREQUEST);
    }

    public static final boolean isDcc(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters().contains((Object)CbusFilterType.CFCS);
    }

    public static final boolean isOnEvent(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters().contains((Object)CbusFilterType.CFON);
    }

    public static final boolean isEventRequest(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters().contains((Object)CbusFilterType.CFREQUEST);
    }

    public static final boolean isShortEvent(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters().contains((Object)CbusFilterType.CFSHORT);
    }

    @Nonnull
    public static final EnumSet<CbusFilterType> getOpcFilters(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getFilters();
    }

    @Nonnull
    public static final String getOpcName(int opc) {
        if (MAP.get(opc) != null) {
            return CbusOpCodes.MAP.get(opc).getName();
        }
        return "";
    }

    public static final int getOpcMinPriority(int opc) {
        return CbusOpCodes.MAP.getOrDefault(opc, CbusOpCodes.getDefaultOpc()).getMinPri();
    }

    private static Map<Integer, CbusOpc> createMainMap() {
        HashMap<Integer, CbusOpc> result = new HashMap<Integer, CbusOpc>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(FileUtil.getFile("program:xml/cbus/CbusOpcData.xml"));
            document.getDocumentElement().normalize();
            NodeList nList = document.getElementsByTagName("CbusOpc");
            int temp = 0;
            while (temp < nList.getLength()) {
                Node node = nList.item(temp);
                if (node.getNodeType() == 1) {
                    String[] filters;
                    Element eElement = (Element)node;
                    String[] fields = eElement.getAttribute("decode").split("~");
                    StringBuilder fieldbuf = new StringBuilder();
                    String[] stringArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String field = stringArray[n2];
                        if (field.startsWith("OPC_")) {
                            field = Bundle.getMessage(field);
                        }
                        fieldbuf.append(field);
                        ++n2;
                    }
                    EnumSet<CbusFilterType> filterSet = EnumSet.noneOf(CbusFilterType.class);
                    String[] stringArray2 = filters = eElement.getAttribute("filter").split(",");
                    int n3 = filters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filter = stringArray2[n4];
                        CbusFilterType tmp = CbusFilterType.valueOf(filter);
                        filterSet.add(tmp);
                        ++n4;
                    }
                    result.put(StringUtil.getByte(0, eElement.getAttribute("hex")), new CbusOpc(Integer.parseInt(eElement.getAttribute("minPri")), eElement.getAttribute("name"), fieldbuf.toString(), filterSet));
                }
                ++temp;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            log.error("Error importing xml file. {}", (Throwable)ex);
        }
        return Collections.unmodifiableMap(result);
    }

    @Nonnull
    private static CbusOpc getDefaultOpc() {
        return new CbusOpc(3, Bundle.getMessage("OPC_RESERVED"), "", EnumSet.of(CbusFilterType.CFMISC, CbusFilterType.CFUNKNOWN));
    }

    private static class CbusOpc {
        private final int _minPri;
        private final String _name;
        private final String _decodeText;
        private final EnumSet<CbusFilterType> _filterMap;

        private CbusOpc(int minPri, String name, String decode, EnumSet<CbusFilterType> filterMap) {
            this._minPri = minPri;
            this._name = name;
            this._decodeText = decode;
            this._filterMap = filterMap;
        }

        private int getMinPri() {
            return this._minPri;
        }

        private String getName() {
            return this._name;
        }

        private String getDecode() {
            return this._decodeText;
        }

        private EnumSet<CbusFilterType> getFilters() {
            return EnumSet.copyOf(this._filterMap);
        }
    }
}

