/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.HashSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.eventtable.CbusEventBeanData;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNameService {
    private final CanSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(CbusNameService.class);

    public CbusNameService() {
        this._memo = null;
    }

    public CbusNameService(CanSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Nonnull
    public String getEventNodeString(int nn, int en) {
        String addevbuf;
        CbusEventTableDataModel evMod = this.getEventModel();
        if (evMod != null && !(addevbuf = evMod.getEventString(nn, en)).isEmpty()) {
            return addevbuf;
        }
        return new CbusEvent(nn, en).toString();
    }

    @Nonnull
    public String getEventName(int nn, int en) {
        CbusEventTableDataModel evMod = this.getEventModel();
        if (evMod != null) {
            return evMod.getEventName(nn, en);
        }
        return "";
    }

    @Nonnull
    public String getNodeName(int nn) {
        CbusNodeTableDataModel model = this.getNodeModel();
        if (model != null) {
            return model.getNodeName(nn);
        }
        return "";
    }

    @Nonnull
    public CbusEventBeanData getJmriBeans(int nn, int en, @Nonnull CbusEventDataElements.EvState state) {
        CbusEventTableDataModel evMod = this.getEventModel();
        if (evMod != null) {
            return evMod.getEventBeans(nn, en, state);
        }
        return new CbusEventBeanData(new HashSet<NamedBean>(), new HashSet<NamedBean>());
    }

    @CheckForNull
    private CbusNodeTableDataModel getNodeModel() {
        log.debug("memo: {}", (Object)this._memo);
        return InstanceManager.getNullableDefault(CbusNodeTableDataModel.class);
    }

    @CheckForNull
    private CbusEventTableDataModel getEventModel() {
        return InstanceManager.getNullableDefault(CbusEventTableDataModel.class);
    }
}

