/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Light;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusLight;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusLightManager
extends AbstractLightManager {
    private static final Logger log = LoggerFactory.getLogger(CbusLightManager.class);

    public CbusLightManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CanSystemConnectionMemo getMemo() {
        return (CanSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String addr;
        try {
            this.validateSystemNameFormat(systemName);
            addr = systemName.substring(this.getSystemNamePrefix().length());
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            throw new IllegalArgumentException(e.getMessage());
        }
        String newAddress = CbusAddress.validateSysName(addr);
        CbusLight l = new CbusLight(this.getSystemPrefix(), newAddress, this.getMemo().getTrafficController());
        l.setUserName(userName);
        return l;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        this.validateSystemNamePrefix(name, locale);
        try {
            CbusAddress.validateSysName(name.substring(this.getSystemNamePrefix().length()));
        }
        catch (IllegalArgumentException ex) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", ex.getMessage());
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        try {
            String addr = systemName.substring(this.getSystemPrefix().length() + 1);
            CbusAddress.validateSysName(addr);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException runtimeException) {
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        try {
            return String.valueOf(prefix) + this.typeLetter() + CbusAddress.validateSysName(curAddress);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException(e.getMessage());
        }
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return this.validSystemNameFormat(systemName) == Manager.NameValidity.VALID;
    }

    @Override
    @Nonnull
    protected String getIncrement(String curAddress, int increment) throws JmriException {
        return CbusAddress.getIncrement(curAddress);
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddCbusLightEntryToolTip");
    }
}

