/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.implementation.AbstractLight;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusEventInterface;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusOpCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusLight
extends AbstractLight
implements CanListener,
CbusEventInterface {
    private CbusAddress addrOn;
    private CbusAddress addrOff;
    private final TrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(CbusLight.class);

    protected CbusLight(String prefix, String address, TrafficController tc) {
        super(String.valueOf(prefix) + "L" + address);
        this.tc = tc;
        this.init(address);
    }

    private void init(String address) {
        CbusAddress a = new CbusAddress(address);
        CbusAddress[] v = a.split();
        switch (v.length) {
            case 0: {
                log.error("Did not find usable system name: {}", (Object)address);
                return;
            }
            case 1: {
                this.addrOn = v[0];
                if (address.startsWith("+")) {
                    this.addrOff = new CbusAddress("-" + address.substring(1));
                    break;
                }
                if (address.startsWith("-")) {
                    this.addrOff = new CbusAddress("+" + address.substring(1));
                    break;
                }
                log.error("can't make 2nd event from systemname {}", (Object)address);
                return;
            }
            case 2: {
                this.addrOn = v[0];
                this.addrOff = v[1];
                break;
            }
            default: {
                log.error("Can't parse CbusLight system name: {}", (Object)address);
                return;
            }
        }
        this.addTc(this.tc);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        switch (newState) {
            case 2: {
                CanMessage m = this.addrOn.makeMessage(this.tc.getCanid());
                CbusMessage.setPri(m, 11);
                this.tc.sendCanMessage(m, this);
                break;
            }
            case 4: {
                CanMessage m = this.addrOff.makeMessage(this.tc.getCanid());
                CbusMessage.setPri(m, 11);
                this.tc.sendCanMessage(m, this);
                break;
            }
            default: {
                log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        CanMessage m;
        m.setOpCode(CbusOpCodes.isShortEvent(CbusMessage.getOpcode(m = this.addrOn.makeMessage(this.tc.getCanid()))) ? 154 : 146);
        CbusMessage.setPri(m, 11);
        this.tc.sendCanMessage(m, this);
    }

    @Override
    public void message(CanMessage f) {
        if (f.extendedOrRtr()) {
            return;
        }
        if (this.addrOn.match(f)) {
            this.notifyStateChange(this.getState(), 2);
        } else if (this.addrOff.match(f)) {
            this.notifyStateChange(this.getState(), 4);
        }
    }

    @Override
    public void reply(CanReply origf) {
        if (origf.extendedOrRtr()) {
            return;
        }
        CanReply f = CbusMessage.opcRangeToStl(origf);
        if (this.addrOn.match(f)) {
            this.notifyStateChange(this.getState(), 2);
        } else if (this.addrOff.match(f)) {
            this.notifyStateChange(this.getState(), 4);
        }
    }

    public CanMessage getAddrOn() {
        return this.addrOn.makeMessage(this.tc.getCanid());
    }

    public CanMessage getAddrOff() {
        return this.addrOff.makeMessage(this.tc.getCanid());
    }

    @Override
    public CanMessage getBeanOnMessage() {
        return this.checkEvent(this.getAddrOn());
    }

    @Override
    public CanMessage getBeanOffMessage() {
        return this.checkEvent(this.getAddrOff());
    }

    @Override
    public void dispose() {
        this.tc.removeCanListener(this);
        super.dispose();
    }
}

