/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.EnumSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanFrame;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusFilter;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusOpCodes;

public enum CbusFilterType {
    CFIN(Bundle.getMessage("Incoming"), null){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            if (m instanceof CanReply) {
                return super.action(m, cf);
            }
            return -1;
        }
    }
    ,
    CFOUT(Bundle.getMessage("Outgoing"), null){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            if (m instanceof CanMessage) {
                return super.action(m, cf);
            }
            return -1;
        }
    }
    ,
    CFEVENT(Bundle.getMessage("CbusEvents"), null),
    CFEVENTMIN(Bundle.getMessage("MinEvent"), CFEVENT){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            if (CbusMessage.getEvent(m) < cf.getEvMin()) {
                return super.action(m, cf);
            }
            CbusFilter.incrementCount(this.ordinal(), cf);
            return -1;
        }
    }
    ,
    CFEVENTMAX(Bundle.getMessage("MaxEvent"), CFEVENT){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            if (CbusMessage.getEvent(m) > cf.getEvMax()) {
                return super.action(m, cf);
            }
            CbusFilter.incrementCount(this.ordinal(), cf);
            return -1;
        }
    }
    ,
    CFON(Bundle.getMessage("CbusOnEvents"), CFEVENT),
    CFOF(Bundle.getMessage("CbusOffEvents"), CFEVENT),
    CFSHORT(Bundle.getMessage("ShortEvents"), CFEVENT),
    CFLONG(Bundle.getMessage("LongEvents"), CFEVENT),
    CFSTD(Bundle.getMessage("StandardEvents"), CFEVENT),
    CFREQUEST(Bundle.getMessage("RequestEvents"), CFEVENT),
    CFRESPONSE(Bundle.getMessage("ResponseEvents"), CFEVENT),
    CFED0(Bundle.getMessage("EVD0"), CFEVENT),
    CFED1(Bundle.getMessage("EVD1"), CFEVENT),
    CFED2(Bundle.getMessage("EVD2"), CFEVENT),
    CFED3(Bundle.getMessage("EVD3"), CFEVENT),
    CFNODE(Bundle.getMessage("CbusNodes"), null){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            return CbusFilter.checknode(CbusMessage.getNodeNumber(m), cf);
        }
    }
    ,
    CFNODEMIN(Bundle.getMessage("MinNode"), CFNODE){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            if (CbusMessage.getNodeNumber(m) < cf.getNdMin()) {
                return super.action(m, cf);
            }
            CbusFilter.incrementCount(this.ordinal(), cf);
            return -1;
        }
    }
    ,
    CFNODEMAX(Bundle.getMessage("MaxNode"), CFNODE){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            if (CbusMessage.getNodeNumber(m) > cf.getNdMax()) {
                return super.action(m, cf);
            }
            CbusFilter.incrementCount(this.ordinal(), cf);
            return -1;
        }
    }
    ,
    CFNODES(Bundle.getMessage("CbusNodes"), CFNODE){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            return -1;
        }
    }
    ,
    CFDATA(Bundle.getMessage("OPC_DA"), null),
    CFACDAT("ACDAT", CFDATA),
    CFDDES("DDES + DDWS", CFDATA),
    CFRQDAT("RQDAT", CFDATA),
    CFARDAT("ARDAT", CFDATA),
    CFDDRS("DDRS", CFDATA),
    CFRQDDS("RQDDS", CFDATA),
    CFCABDAT("CABDAT", CFDATA),
    CFCS(Bundle.getMessage("CommandStation"), null),
    CFCSAQRL(Bundle.getMessage("LocoCommands"), CFCS),
    CFCSKA(Bundle.getMessage("KeepAlive"), CFCS),
    CFCSDSPD(Bundle.getMessage("SpeedDirection"), CFCS),
    CFCSFUNC(Bundle.getMessage("Functions"), CFCS),
    CFCSPROG(Bundle.getMessage("Programming"), CFCS),
    CFCSLC(Bundle.getMessage("LayoutCommands"), CFCS),
    CFCSC(Bundle.getMessage("CommandStationControl"), CFCS),
    CFNDCONFIG(Bundle.getMessage("NodeConfiguration"), null),
    CFNDSETUP(Bundle.getMessage("GeneralNodeSetup"), CFNDCONFIG),
    CFNDVAR(Bundle.getMessage("NodeVariables"), CFNDCONFIG),
    CFNDEV(Bundle.getMessage("NodeEvents"), CFNDCONFIG),
    CFNDNUM(Bundle.getMessage("NodeNumbers"), CFNDCONFIG),
    CFMISC(Bundle.getMessage("Misc"), null),
    CFEXTRTR("Extended / RTR", CFMISC){

        @Override
        public int action(AbstractMessage m, CbusFilter cf) {
            if (m instanceof CanFrame && ((CanFrame)((Object)m)).extendedOrRtr()) {
                if (cf.getActiveFilters().get(this.ordinal()).booleanValue()) {
                    return this.ordinal();
                }
                CbusFilter.incrementCount(this.ordinal(), cf);
                return -2;
            }
            return -1;
        }
    }
    ,
    CFNETWK(Bundle.getMessage("NetworkCommands"), CFMISC),
    CFCLOCK(Bundle.getMessage("CBUS_FCLK"), CFMISC),
    CFOTHER(Bundle.getMessage("Others"), CFMISC),
    CFUNKNOWN(Bundle.getMessage("Unknown"), CFMISC);

    private final String _bundleString;
    private final CbusFilterType _category;

    public int action(AbstractMessage m, CbusFilter cf) {
        if (cf.getActiveFilters().get(this.ordinal()).booleanValue()) {
            return this.ordinal();
        }
        CbusFilter.incrementCount(this.ordinal(), cf);
        return -1;
    }

    private CbusFilterType(String bundle, CbusFilterType category) {
        this._bundleString = bundle;
        this._category = category;
    }

    public final String getName() {
        return this._bundleString;
    }

    @CheckForNull
    public final CbusFilterType getCategory() {
        return this._category;
    }

    public static final EnumSet<CbusFilterType> getCatHeads() {
        EnumSet<CbusFilterType> catSet = EnumSet.noneOf(CbusFilterType.class);
        catSet.add(CFEVENT);
        catSet.add(CFNODE);
        catSet.add(CFDATA);
        catSet.add(CFCS);
        catSet.add(CFNDCONFIG);
        catSet.add(CFMISC);
        return catSet;
    }

    public final boolean isCategoryHead() {
        return CbusFilterType.getCatHeads().contains((Object)this);
    }

    public final boolean alwaysDisplay() {
        EnumSet<CbusFilterType> alwaysDisplay = CbusFilterType.getCatHeads();
        alwaysDisplay.add(CFIN);
        alwaysDisplay.add(CFOUT);
        return alwaysDisplay.contains((Object)this);
    }

    public final boolean showSpinners() {
        EnumSet<CbusFilterType> spinnerSet = EnumSet.noneOf(CbusFilterType.class);
        spinnerSet.addAll(EnumSet.of(CFEVENTMIN, CFEVENTMAX, CFNODEMIN, CFNODEMAX));
        return spinnerSet.contains((Object)this);
    }

    @Nonnull
    public static final EnumSet<CbusFilterType> allFilters(int opc) {
        EnumSet<CbusFilterType> mergedSet = EnumSet.noneOf(CbusFilterType.class);
        mergedSet.addAll(EnumSet.of(CFIN, CFOUT, CFEXTRTR));
        mergedSet.addAll(CbusOpCodes.getOpcFilters(opc));
        if (mergedSet.contains((Object)CFEVENT)) {
            mergedSet.addAll(EnumSet.of(CFEVENTMIN, CFEVENTMAX));
        }
        if (mergedSet.contains((Object)CFNODE)) {
            mergedSet.addAll(EnumSet.of(CFNODEMIN, CFNODEMAX));
        }
        return mergedSet;
    }

    @CheckForNull
    public final String getToolTip() {
        StringBuilder t = new StringBuilder();
        int i = 0;
        while (i < 257) {
            if (CbusOpCodes.getOpcFilters(i).contains((Object)this) && !CbusOpCodes.getOpcName(i).isEmpty()) {
                t.append(CbusOpCodes.getOpcName(i)).append(" : ").append(Bundle.getMessage("CBUS_" + CbusOpCodes.getOpcName(i))).append(" : ").append(Bundle.getMessage("CTIP_" + CbusOpCodes.getOpcName(i))).append("<br>");
            }
            ++i;
        }
        if (!t.toString().isEmpty()) {
            t.insert(0, "<html>");
            t.append("<html>");
            return t.toString();
        }
        return null;
    }

    /* synthetic */ CbusFilterType(String string, int n, String string2, CbusFilterType cbusFilterType, CbusFilterType cbusFilterType2) {
        this(string2, cbusFilterType);
    }
}

