/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.cbus.CbusFilterType;
import jmri.jmrix.can.cbus.swing.CbusFilterFrame;
import jmri.util.ThreadingUtil;

public class CbusFilter {
    private final HashMap<Integer, Boolean> _boolean_hash_map;
    private final CbusFilterFrame _filterFrame;
    private final HashMap<Integer, Integer> _nodes_hashmap;
    private int _evMin = 0;
    private int _evMax = 0;
    private int _ndMin = 0;
    private int _ndMax = 0;
    public static final int CFMAXCATS = CbusFilterType.values().length;
    public static final int CFMAX_NODES = 100;

    public CbusFilter(CbusFilterFrame filterFrame) {
        this._filterFrame = filterFrame;
        this._boolean_hash_map = new HashMap(CbusFilter.getHMapSize(CFMAXCATS + 100));
        this._nodes_hashmap = new HashMap(CbusFilter.getHMapSize(100));
        int i = 0;
        while (i < CFMAXCATS + 100) {
            this._boolean_hash_map.put(i, false);
            ++i;
        }
    }

    public int filter(@Nonnull AbstractMessage test) {
        for (CbusFilterType singleFilter : CbusFilterType.allFilters(test.getElement(0))) {
            int _toReturn = singleFilter.action(test, this);
            if (_toReturn > -1) {
                return _toReturn;
            }
            if (_toReturn == -2) break;
        }
        return -1;
    }

    private static int positionInNodeList(int node, @Nonnull HashMap<Integer, Integer> nodes) {
        for (Map.Entry<Integer, Integer> o : nodes.entrySet()) {
            if (!((Object)o.getValue()).equals(node)) continue;
            return o.getKey();
        }
        return -1;
    }

    protected CbusFilterFrame getCbusFilterFrame() {
        return this._filterFrame;
    }

    protected final HashMap<Integer, Boolean> getActiveFilters() {
        return this._boolean_hash_map;
    }

    protected final HashMap<Integer, Integer> getNodes() {
        return this._nodes_hashmap;
    }

    protected static int checknode(int node, @Nonnull CbusFilter cf) {
        if (!cf.getNodes().containsValue(node)) {
            cf.getNodes().put(cf.getNodes().size() + CFMAXCATS, node);
            if (cf.getCbusFilterFrame() != null) {
                cf.getCbusFilterFrame().addNode(node, CbusFilter.positionInNodeList(node, cf.getNodes()));
            }
        }
        if (cf.getActiveFilters().get(CbusFilterType.CFNODE.ordinal()).booleanValue()) {
            return CbusFilterType.CFNODE.ordinal();
        }
        CbusFilter.incrementCount(CbusFilterType.CFNODE.ordinal(), cf);
        if (cf.getActiveFilters().get(CbusFilter.positionInNodeList(node, cf.getNodes())).booleanValue()) {
            return CbusFilter.positionInNodeList(node, cf.getNodes());
        }
        CbusFilter.incrementCount(CbusFilter.positionInNodeList(node, cf.getNodes()), cf);
        return -1;
    }

    protected static void incrementCount(int filternum, @Nonnull CbusFilter cf) {
        if (cf.getCbusFilterFrame() != null) {
            ThreadingUtil.runOnGUIEventually(() -> cf.getCbusFilterFrame().passIncrement(filternum));
        }
    }

    public void setFilter(int id, boolean trueorfalse) {
        this._boolean_hash_map.put(id, trueorfalse);
    }

    public void setMinMax(@Nonnull CbusFilterType filter, int val) {
        switch (filter) {
            case CFEVENTMIN: {
                this._evMin = val;
                break;
            }
            case CFEVENTMAX: {
                this._evMax = val;
                break;
            }
            case CFNODEMIN: {
                this._ndMin = val;
                break;
            }
            case CFNODEMAX: {
                this._ndMax = val;
                break;
            }
        }
    }

    public int getEvMin() {
        return this._evMin;
    }

    public int getEvMax() {
        return this._evMax;
    }

    public int getNdMin() {
        return this._ndMin;
    }

    public int getNdMax() {
        return this._ndMax;
    }

    public static final int getHMapSize(int reqdCapacity) {
        return (reqdCapacity * 4 + 2) / 3;
    }
}

