/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.Objects;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.util.ThreadingUtil;

public class CbusEvent
extends CbusEventDataElements {
    private int _nn;
    private int _en;
    protected CbusEventDataElements.EvState _state;
    protected String _name;
    private final CanSystemConnectionMemo _memo;

    public CbusEvent(int nn, int en) {
        this._nn = nn;
        this._en = en;
        this._state = CbusEventDataElements.EvState.UNKNOWN;
        this._name = "";
        this._memo = null;
    }

    public CbusEvent(CanSystemConnectionMemo memo, int nn, int en) {
        this._nn = nn;
        this._en = en;
        this._state = CbusEventDataElements.EvState.UNKNOWN;
        this._name = "";
        this._memo = memo;
    }

    public CbusEventDataElements.EvState getState() {
        return this._state;
    }

    public void setState(CbusEventDataElements.EvState newval) {
        this._state = newval;
    }

    public int getEn() {
        return this._en;
    }

    public int getNn() {
        return this._nn;
    }

    public void setEn(int en) {
        this._en = en;
    }

    public void setNn(int nn) {
        this._nn = nn;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getNodeName() {
        return new CbusNameService(this._memo).getNodeName(this.getNn());
    }

    public boolean matches(int nn, int en) {
        return nn == this._nn && en == this._en;
    }

    public boolean equals(Object o) {
        return o instanceof CbusEvent && this.matches(((CbusEvent)o).getNn(), ((CbusEvent)o).getEn());
    }

    public int hashCode() {
        return Objects.hash(this.getEn(), this.getNn());
    }

    public void sendOn() {
        this.sendEvent(CbusEventDataElements.EvState.ON);
    }

    public void sendOff() {
        this.sendEvent(CbusEventDataElements.EvState.OFF);
    }

    public void sendRequest() {
        this.sendEvent(CbusEventDataElements.EvState.REQUEST);
    }

    public void sendEvent(CbusEventDataElements.EvState state) {
        CanSystemConnectionMemo memo = this._memo == null ? InstanceManager.getDefault(CanSystemConnectionMemo.class) : this._memo;
        if (state == CbusEventDataElements.EvState.TOGGLE) {
            state = this._state == CbusEventDataElements.EvState.OFF ? CbusEventDataElements.EvState.ON : CbusEventDataElements.EvState.OFF;
        }
        this._state = state;
        ThreadingUtil.runOnLayout(() -> memo.getTrafficController().sendCanMessage(this.getCanMessage(memo.getTrafficController().getCanid(), this._nn, this._en, this._state), null));
    }

    public String toString() {
        StringBuilder addevbuf = new StringBuilder(50);
        if (this._nn > 0) {
            addevbuf.append(Bundle.getMessage("OPC_NN")).append(":");
            addevbuf.append(this._nn).append(" ");
            if (!this.getNodeName().isEmpty()) {
                addevbuf.append(this.getNodeName()).append(" ");
            }
        }
        addevbuf.append(Bundle.getMessage("OPC_EN")).append(":");
        addevbuf.append(this._en).append(" ");
        if (!this.getName().isEmpty()) {
            addevbuf.append(this.getName()).append(" ");
        }
        return addevbuf.toString();
    }
}

