/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.AddressedProgrammer;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusDccOpsModeProgrammer;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.managers.DefaultProgrammerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusDccProgrammerManager
extends DefaultProgrammerManager {
    private boolean _isAddressedModePossible = true;
    private boolean _isGlobalProgrammerAvailable = true;
    private CbusPreferences prefs;
    TrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(CbusDccProgrammerManager.class);

    public CbusDccProgrammerManager(Programmer serviceModeProgrammer, CanSystemConnectionMemo memo) {
        super(serviceModeProgrammer, memo);
        this.tc = memo.getTrafficController();
        this.prefs = InstanceManager.getDefault(CbusPreferences.class);
        log.info("Preferences for programmers start as: global {} addressed {}", (Object)this.prefs.isGlobalProgrammerAvailable(), (Object)this.prefs.isAddressedModePossible());
        this.validateProgrammingModes(memo);
        log.info("Preferences for programmers now: global {} addressed {}", (Object)this.prefs.isGlobalProgrammerAvailable(), (Object)this.prefs.isAddressedModePossible());
        log.info("ProgModeSwitch is {}", (Object)memo.getProgModeSwitch());
    }

    protected final void validateProgrammingModes(CanSystemConnectionMemo memo) {
        boolean igpa = this.prefs.isGlobalProgrammerAvailable();
        boolean iamp = this.prefs.isAddressedModePossible();
        int ptm = this.prefs.getProgTrackMode();
        ConfigurationManager.ProgModeSwitch pms = memo.getProgModeSwitch();
        switch (pms) {
            default: {
                igpa = true;
                iamp = true;
                break;
            }
            case EITHER: {
                if ((!igpa || !iamp) && (igpa || iamp)) break;
                igpa = true;
                iamp = false;
                break;
            }
            case SPROG3PLUS: {
                if (ptm == 2) {
                    igpa = false;
                    iamp = true;
                    break;
                }
                igpa = true;
                iamp = true;
            }
        }
        this.prefs.setProgrammersAvailable(igpa, iamp);
        this.mySetGlobalProgrammerAvailable(igpa);
        this.mySetAddressedModePossible(iamp);
    }

    public boolean isAddressedModeHardwareAvailable() {
        return true;
    }

    public boolean isGlobalProgrammerHardwareAvailable() {
        return true;
    }

    @Override
    public boolean isAddressedModePossible() {
        return this._isAddressedModePossible;
    }

    public final void mySetAddressedModePossible(boolean state) {
        boolean old = this._isAddressedModePossible;
        this._isAddressedModePossible = state;
        this.firePropertyChange("addressedModePossible", old, state);
    }

    public void setAddressedModePossible(boolean state) {
        this.mySetAddressedModePossible(state);
    }

    @Override
    public boolean isGlobalProgrammerAvailable() {
        return this._isGlobalProgrammerAvailable;
    }

    public final void mySetGlobalProgrammerAvailable(boolean state) {
        boolean old = this._isGlobalProgrammerAvailable;
        this._isGlobalProgrammerAvailable = state;
        this.firePropertyChange("globalProgrammerAvailable", old, state);
    }

    public void setGlobalProgrammerAvailable(boolean state) {
        this.mySetGlobalProgrammerAvailable(state);
    }

    @Override
    public AddressedProgrammer getAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return new CbusDccOpsModeProgrammer(pAddress, pLongAddress, this.tc);
    }

    @Override
    public AddressedProgrammer reserveAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return null;
    }
}

